// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarnotifications.model



/**
 * Returns information about an event that has triggered a notification rule.
 */
public class EventTypeSummary private constructor(builder: Builder) {
    /**
     * The system-generated ID of the event. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide*.
     */
    public val eventTypeId: kotlin.String? = builder.eventTypeId
    /**
     * The name of the event.
     */
    public val eventTypeName: kotlin.String? = builder.eventTypeName
    /**
     * The resource type of the event.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The name of the service for which the event applies.
     */
    public val serviceName: kotlin.String? = builder.serviceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codestarnotifications.model.EventTypeSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventTypeSummary(")
        append("eventTypeId=$eventTypeId,")
        append("eventTypeName=$eventTypeName,")
        append("resourceType=$resourceType,")
        append("serviceName=$serviceName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventTypeId?.hashCode() ?: 0
        result = 31 * result + (eventTypeName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventTypeSummary

        if (eventTypeId != other.eventTypeId) return false
        if (eventTypeName != other.eventTypeName) return false
        if (resourceType != other.resourceType) return false
        if (serviceName != other.serviceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codestarnotifications.model.EventTypeSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The system-generated ID of the event. For a complete list of event types and IDs, see [Notification concepts](https://docs.aws.amazon.com/codestar-notifications/latest/userguide/concepts.html#concepts-api) in the *Developer Tools Console User Guide*.
         */
        public var eventTypeId: kotlin.String? = null
        /**
         * The name of the event.
         */
        public var eventTypeName: kotlin.String? = null
        /**
         * The resource type of the event.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The name of the service for which the event applies.
         */
        public var serviceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codestarnotifications.model.EventTypeSummary) : this() {
            this.eventTypeId = x.eventTypeId
            this.eventTypeName = x.eventTypeName
            this.resourceType = x.resourceType
            this.serviceName = x.serviceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codestarnotifications.model.EventTypeSummary = EventTypeSummary(this)
    }
}
