// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarnotifications.paginators

import aws.sdk.kotlin.services.codestarnotifications.CodestarNotificationsClient
import aws.sdk.kotlin.services.codestarnotifications.model.EventTypeSummary
import aws.sdk.kotlin.services.codestarnotifications.model.ListEventTypesRequest
import aws.sdk.kotlin.services.codestarnotifications.model.ListEventTypesResponse
import aws.sdk.kotlin.services.codestarnotifications.model.ListNotificationRulesRequest
import aws.sdk.kotlin.services.codestarnotifications.model.ListNotificationRulesResponse
import aws.sdk.kotlin.services.codestarnotifications.model.ListTargetsRequest
import aws.sdk.kotlin.services.codestarnotifications.model.ListTargetsResponse
import aws.sdk.kotlin.services.codestarnotifications.model.NotificationRuleSummary
import aws.sdk.kotlin.services.codestarnotifications.model.TargetSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListEventTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEventTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventTypesResponse]
 */
public fun CodestarNotificationsClient.listEventTypesPaginated(initialRequest: ListEventTypesRequest): Flow<ListEventTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEventTypesPaginated.listEventTypes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEventTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEventTypesResponse]
 */
public fun CodestarNotificationsClient.listEventTypesPaginated(block: ListEventTypesRequest.Builder.() -> Unit): Flow<ListEventTypesResponse> =
    listEventTypesPaginated(ListEventTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEventTypesPaginated]
 * to access the nested member [EventTypeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EventTypeSummary]
 */
@JvmName("listEventTypesResponseEventTypeSummary")
public fun Flow<ListEventTypesResponse>.eventTypes(): Flow<EventTypeSummary> =
    transform() { response ->
        response.eventTypes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListNotificationRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListNotificationRulesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationRulesResponse]
 */
public fun CodestarNotificationsClient.listNotificationRulesPaginated(initialRequest: ListNotificationRulesRequest): Flow<ListNotificationRulesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listNotificationRulesPaginated.listNotificationRules(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListNotificationRulesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListNotificationRulesResponse]
 */
public fun CodestarNotificationsClient.listNotificationRulesPaginated(block: ListNotificationRulesRequest.Builder.() -> Unit): Flow<ListNotificationRulesResponse> =
    listNotificationRulesPaginated(ListNotificationRulesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listNotificationRulesPaginated]
 * to access the nested member [NotificationRuleSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [NotificationRuleSummary]
 */
@JvmName("listNotificationRulesResponseNotificationRuleSummary")
public fun Flow<ListNotificationRulesResponse>.notificationRules(): Flow<NotificationRuleSummary> =
    transform() { response ->
        response.notificationRules?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTargetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetsResponse]
 */
public fun CodestarNotificationsClient.listTargetsPaginated(initialRequest: ListTargetsRequest): Flow<ListTargetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTargetsPaginated.listTargets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetsResponse]
 */
public fun CodestarNotificationsClient.listTargetsPaginated(block: ListTargetsRequest.Builder.() -> Unit): Flow<ListTargetsResponse> =
    listTargetsPaginated(ListTargetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTargetsPaginated]
 * to access the nested member [TargetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TargetSummary]
 */
@JvmName("listTargetsResponseTargetSummary")
public fun Flow<ListTargetsResponse>.targets(): Flow<TargetSummary> =
    transform() { response ->
        response.targets?.forEach {
            emit(it)
        }
    }
