// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codestarnotifications.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codestarnotifications.model.CodestarNotificationsException
import aws.sdk.kotlin.services.codestarnotifications.model.DescribeNotificationRuleResponse
import aws.sdk.kotlin.services.codestarnotifications.model.DetailType
import aws.sdk.kotlin.services.codestarnotifications.model.EventTypeSummary
import aws.sdk.kotlin.services.codestarnotifications.model.NotificationRuleStatus
import aws.sdk.kotlin.services.codestarnotifications.model.TargetSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeNotificationRuleOperationDeserializer: HttpDeserialize<DescribeNotificationRuleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeNotificationRuleResponse {
        if (!response.status.isSuccess()) {
            throwDescribeNotificationRuleError(context, response)
        }
        val builder = DescribeNotificationRuleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeNotificationRuleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeNotificationRuleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodestarNotificationsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodestarNotificationsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeNotificationRuleOperationBody(builder: DescribeNotificationRuleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATEDBY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedBy"))
    val CREATEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTimestamp"))
    val DETAILTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DetailType"))
    val EVENTTYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EventTypes"))
    val LASTMODIFIEDTIMESTAMP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastModifiedTimestamp"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Resource"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val TARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Targets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDBY_DESCRIPTOR)
        field(CREATEDTIMESTAMP_DESCRIPTOR)
        field(DETAILTYPE_DESCRIPTOR)
        field(EVENTTYPES_DESCRIPTOR)
        field(LASTMODIFIEDTIMESTAMP_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RESOURCE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TARGETS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDBY_DESCRIPTOR.index -> builder.createdBy = deserializeString()
                CREATEDTIMESTAMP_DESCRIPTOR.index -> builder.createdTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                DETAILTYPE_DESCRIPTOR.index -> builder.detailType = deserializeString().let { DetailType.fromValue(it) }
                EVENTTYPES_DESCRIPTOR.index -> builder.eventTypes =
                    deserializer.deserializeList(EVENTTYPES_DESCRIPTOR) {
                        val col0 = mutableListOf<EventTypeSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEventTypeSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LASTMODIFIEDTIMESTAMP_DESCRIPTOR.index -> builder.lastModifiedTimestamp = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RESOURCE_DESCRIPTOR.index -> builder.resource = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { NotificationRuleStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TARGETS_DESCRIPTOR.index -> builder.targets =
                    deserializer.deserializeList(TARGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<TargetSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTargetSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
