// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



class AdminLinkProviderForUserRequest private constructor(builder: Builder) {
    /**
     * The existing user in the user pool that you want to assign to the external identity provider user account. This user can be a native (Username + Password) Amazon Cognito user pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito returns this user when the new user (with the linked identity provider attribute) signs in.
     *
     * For a native username + password user, the `ProviderAttributeValue` for the `DestinationUser` should be the username in the user pool. For a federated user, it should be the provider-specific `user_id`.
     *
     * The `ProviderAttributeName` of the `DestinationUser` is ignored.
     *
     * The `ProviderName` should be set to `Cognito` for users in Cognito user pools.
     *
     * All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom attributes, the operation won't succeed.
     */
    val destinationUser: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType? = builder.destinationUser
    /**
     * An external identity provider account for a user who doesn't exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.
     *
     * If the `SourceUser` is using a federated social identity provider, such as Facebook, Google, or Login with Amazon, you must set the `ProviderAttributeName` to `Cognito_Subject`. For social identity providers, the `ProviderName` will be `Facebook`, `Google`, or `LoginWithAmazon`, and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for `id`, `sub`, and `user_id`, respectively. The `ProviderAttributeValue` for the user must be the same value as the `id`, `sub`, or `user_id` value found in the social identity provider token.
     *
     * For SAML, the `ProviderAttributeName` can be any value that matches a claim in the SAML assertion. If you want to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the `ProviderAttributeName`. If you set `ProviderAttributeName` to `Cognito_Subject`, Amazon Cognito will automatically parse the default unique identifier found in the subject from the SAML token.
     */
    val sourceUser: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType? = builder.sourceUser
    /**
     * The user pool ID for the user pool.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AdminLinkProviderForUserRequest(")
        append("destinationUser=$destinationUser,")
        append("sourceUser=$sourceUser,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationUser?.hashCode() ?: 0
        result = 31 * result + (sourceUser?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AdminLinkProviderForUserRequest

        if (destinationUser != other.destinationUser) return false
        if (sourceUser != other.sourceUser) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The existing user in the user pool that you want to assign to the external identity provider user account. This user can be a native (Username + Password) Amazon Cognito user pools user or a federated user (for example, a SAML or Facebook user). If the user doesn't exist, Amazon Cognito generates an exception. Amazon Cognito returns this user when the new user (with the linked identity provider attribute) signs in.
         *
         * For a native username + password user, the `ProviderAttributeValue` for the `DestinationUser` should be the username in the user pool. For a federated user, it should be the provider-specific `user_id`.
         *
         * The `ProviderAttributeName` of the `DestinationUser` is ignored.
         *
         * The `ProviderName` should be set to `Cognito` for users in Cognito user pools.
         *
         * All attributes in the DestinationUser profile must be mutable. If you have assigned the user any immutable custom attributes, the operation won't succeed.
         */
        var destinationUser: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType? = null
        /**
         * An external identity provider account for a user who doesn't exist yet in the user pool. This user must be a federated user (for example, a SAML or Facebook user), not another native user.
         *
         * If the `SourceUser` is using a federated social identity provider, such as Facebook, Google, or Login with Amazon, you must set the `ProviderAttributeName` to `Cognito_Subject`. For social identity providers, the `ProviderName` will be `Facebook`, `Google`, or `LoginWithAmazon`, and Amazon Cognito will automatically parse the Facebook, Google, and Login with Amazon tokens for `id`, `sub`, and `user_id`, respectively. The `ProviderAttributeValue` for the user must be the same value as the `id`, `sub`, or `user_id` value found in the social identity provider token.
         *
         * For SAML, the `ProviderAttributeName` can be any value that matches a claim in the SAML assertion. If you want to link SAML users based on the subject of the SAML assertion, you should map the subject to a claim through the SAML identity provider and submit that claim name as the `ProviderAttributeName`. If you set `ProviderAttributeName` to `Cognito_Subject`, Amazon Cognito will automatically parse the default unique identifier found in the subject from the SAML token.
         */
        var sourceUser: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType? = null
        /**
         * The user pool ID for the user pool.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest) : this() {
            this.destinationUser = x.destinationUser
            this.sourceUser = x.sourceUser
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminLinkProviderForUserRequest = AdminLinkProviderForUserRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType] inside the given [block]
         */
        fun destinationUser(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType.Builder.() -> kotlin.Unit) {
            this.destinationUser = aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType] inside the given [block]
         */
        fun sourceUser(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType.Builder.() -> kotlin.Unit) {
            this.sourceUser = aws.sdk.kotlin.services.cognitoidentityprovider.model.ProviderUserIdentifierType.invoke(block)
        }
    }
}
