// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The Amazon Pinpoint analytics configuration for collecting metrics for a user pool.
 *
 * In Regions where Amazon Pinpointisn't available, user pools only support sending events to Amazon Pinpoint projects in us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
 */
class AnalyticsConfigurationType private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpointproject declared by the app ARN.
     */
    val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The application ID for an Amazon Pinpoint application.
     */
    val applicationId: kotlin.String? = builder.applicationId
    /**
     * The external ID.
     */
    val externalId: kotlin.String? = builder.externalId
    /**
     * The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * If `UserDataShared` is `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
     */
    val userDataShared: kotlin.Boolean = builder.userDataShared

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalyticsConfigurationType(")
        append("applicationArn=$applicationArn,")
        append("applicationId=$applicationId,")
        append("externalId=$externalId,")
        append("roleArn=$roleArn,")
        append("userDataShared=$userDataShared)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn?.hashCode() ?: 0
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (userDataShared.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalyticsConfigurationType

        if (applicationArn != other.applicationArn) return false
        if (applicationId != other.applicationId) return false
        if (externalId != other.externalId) return false
        if (roleArn != other.roleArn) return false
        if (userDataShared != other.userDataShared) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon Cognito publishes events to the Amazon Pinpointproject declared by the app ARN.
         */
        var applicationArn: kotlin.String? = null
        /**
         * The application ID for an Amazon Pinpoint application.
         */
        var applicationId: kotlin.String? = null
        /**
         * The external ID.
         */
        var externalId: kotlin.String? = null
        /**
         * The ARN of an Identity and Access Management role that authorizes Amazon Cognito to publish events to Amazon Pinpoint analytics.
         */
        var roleArn: kotlin.String? = null
        /**
         * If `UserDataShared` is `true`, Amazon Cognito will include user data in the events it publishes to Amazon Pinpoint analytics.
         */
        var userDataShared: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType) : this() {
            this.applicationArn = x.applicationArn
            this.applicationId = x.applicationId
            this.externalId = x.externalId
            this.roleArn = x.roleArn
            this.userDataShared = x.userDataShared
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType = AnalyticsConfigurationType(this)
    }
}
