// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The device tracking configuration for a user pool. A user pool with device tracking deactivated returns a null value.
 *
 * When you provide values for any DeviceConfiguration field, you activate device tracking.
 */
class DeviceConfigurationType private constructor(builder: Builder) {
    /**
     * When true, device authentication can replace SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).
     *
     * Users that sign in with devices that have not been confirmed or remembered will still have to provide a second factor, whether or not ChallengeRequiredOnNewDevice is true, when your user pool requires MFA.
     */
    val challengeRequiredOnNewDevice: kotlin.Boolean = builder.challengeRequiredOnNewDevice
    /**
     * When true, users can opt in to remembering their device. Your app code must use callback functions to return the user's choice.
     */
    val deviceOnlyRememberedOnUserPrompt: kotlin.Boolean = builder.deviceOnlyRememberedOnUserPrompt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeviceConfigurationType(")
        append("challengeRequiredOnNewDevice=$challengeRequiredOnNewDevice,")
        append("deviceOnlyRememberedOnUserPrompt=$deviceOnlyRememberedOnUserPrompt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = challengeRequiredOnNewDevice.hashCode()
        result = 31 * result + (deviceOnlyRememberedOnUserPrompt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeviceConfigurationType

        if (challengeRequiredOnNewDevice != other.challengeRequiredOnNewDevice) return false
        if (deviceOnlyRememberedOnUserPrompt != other.deviceOnlyRememberedOnUserPrompt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType = Builder(this).apply(block).build()

    class Builder {
        /**
         * When true, device authentication can replace SMS and time-based one-time password (TOTP) factors for multi-factor authentication (MFA).
         *
         * Users that sign in with devices that have not been confirmed or remembered will still have to provide a second factor, whether or not ChallengeRequiredOnNewDevice is true, when your user pool requires MFA.
         */
        var challengeRequiredOnNewDevice: kotlin.Boolean = false
        /**
         * When true, users can opt in to remembering their device. Your app code must use callback functions to return the user's choice.
         */
        var deviceOnlyRememberedOnUserPrompt: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType) : this() {
            this.challengeRequiredOnNewDevice = x.challengeRequiredOnNewDevice
            this.deviceOnlyRememberedOnUserPrompt = x.deviceOnlyRememberedOnUserPrompt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType = DeviceConfigurationType(this)
    }
}
