// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A container for information about an identity provider.
 */
class IdentityProviderType private constructor(builder: Builder) {
    /**
     * A mapping of identity provider attributes to standard and custom user pool attributes.
     */
    val attributeMapping: Map<String, String>? = builder.attributeMapping
    /**
     * The date the identity provider was created.
     */
    val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A list of identity provider identifiers.
     */
    val idpIdentifiers: List<String>? = builder.idpIdentifiers
    /**
     * The date the identity provider was last modified.
     */
    val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The identity provider details. The following list describes the provider detail keys for each identity provider type.
     * + For Google and Login with Amazon:
     *    + client_id
     *    + client_secret
     *    + authorize_scopes
     * + For Facebook:
     *    + client_id
     *    + client_secret
     *    + authorize_scopes
     *    + api_version
     * + For Sign in with Apple:
     *    + client_id
     *    + team_id
     *    + key_id
     *    + private_key
     *    + authorize_scopes
     * + For OIDC providers:
     *    + client_id
     *    + client_secret
     *    + attributes_request_method
     *    + oidc_issuer
     *    + authorize_scopes
     *    + authorize_url *if not available from discovery URL specified by oidc_issuer key*
     *    + token_url *if not available from discovery URL specified by oidc_issuer key*
     *    + attributes_url *if not available from discovery URL specified by oidc_issuer key*
     *    + jwks_uri *if not available from discovery URL specified by oidc_issuer key*
     *    + attributes_url_add_attributes *a read-only property that is set automatically*
     * + For SAML providers:
     *    + MetadataFile or MetadataURL
     *    + IDPSignOut *optional*
     */
    val providerDetails: Map<String, String>? = builder.providerDetails
    /**
     * The identity provider name.
     */
    val providerName: kotlin.String? = builder.providerName
    /**
     * The identity provider type.
     */
    val providerType: aws.sdk.kotlin.services.cognitoidentityprovider.model.IdentityProviderTypeType? = builder.providerType
    /**
     * The user pool ID.
     */
    val userPoolId: kotlin.String? = builder.userPoolId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.IdentityProviderType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IdentityProviderType(")
        append("attributeMapping=$attributeMapping,")
        append("creationDate=$creationDate,")
        append("idpIdentifiers=$idpIdentifiers,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("providerDetails=$providerDetails,")
        append("providerName=$providerName,")
        append("providerType=$providerType,")
        append("userPoolId=$userPoolId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeMapping?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (idpIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (providerDetails?.hashCode() ?: 0)
        result = 31 * result + (providerName?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IdentityProviderType

        if (attributeMapping != other.attributeMapping) return false
        if (creationDate != other.creationDate) return false
        if (idpIdentifiers != other.idpIdentifiers) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (providerDetails != other.providerDetails) return false
        if (providerName != other.providerName) return false
        if (providerType != other.providerType) return false
        if (userPoolId != other.userPoolId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.IdentityProviderType = Builder(this).apply(block).build()

    class Builder {
        /**
         * A mapping of identity provider attributes to standard and custom user pool attributes.
         */
        var attributeMapping: Map<String, String>? = null
        /**
         * The date the identity provider was created.
         */
        var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of identity provider identifiers.
         */
        var idpIdentifiers: List<String>? = null
        /**
         * The date the identity provider was last modified.
         */
        var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identity provider details. The following list describes the provider detail keys for each identity provider type.
         * + For Google and Login with Amazon:
         *    + client_id
         *    + client_secret
         *    + authorize_scopes
         * + For Facebook:
         *    + client_id
         *    + client_secret
         *    + authorize_scopes
         *    + api_version
         * + For Sign in with Apple:
         *    + client_id
         *    + team_id
         *    + key_id
         *    + private_key
         *    + authorize_scopes
         * + For OIDC providers:
         *    + client_id
         *    + client_secret
         *    + attributes_request_method
         *    + oidc_issuer
         *    + authorize_scopes
         *    + authorize_url *if not available from discovery URL specified by oidc_issuer key*
         *    + token_url *if not available from discovery URL specified by oidc_issuer key*
         *    + attributes_url *if not available from discovery URL specified by oidc_issuer key*
         *    + jwks_uri *if not available from discovery URL specified by oidc_issuer key*
         *    + attributes_url_add_attributes *a read-only property that is set automatically*
         * + For SAML providers:
         *    + MetadataFile or MetadataURL
         *    + IDPSignOut *optional*
         */
        var providerDetails: Map<String, String>? = null
        /**
         * The identity provider name.
         */
        var providerName: kotlin.String? = null
        /**
         * The identity provider type.
         */
        var providerType: aws.sdk.kotlin.services.cognitoidentityprovider.model.IdentityProviderTypeType? = null
        /**
         * The user pool ID.
         */
        var userPoolId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.IdentityProviderType) : this() {
            this.attributeMapping = x.attributeMapping
            this.creationDate = x.creationDate
            this.idpIdentifiers = x.idpIdentifiers
            this.lastModifiedDate = x.lastModifiedDate
            this.providerDetails = x.providerDetails
            this.providerName = x.providerName
            this.providerType = x.providerType
            this.userPoolId = x.userPoolId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.IdentityProviderType = IdentityProviderType(this)
    }
}
