// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Initiates the authentication request.
 */
class InitiateAuthRequest private constructor(builder: Builder) {
    /**
     * The Amazon Pinpoint analytics metadata for collecting metrics for `InitiateAuth` calls.
     */
    val analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = builder.analyticsMetadata
    /**
     * The authentication flow for this call to run. The API action will depend on this value. For example:
     * + `REFRESH_TOKEN_AUTH` takes in a valid refresh token and returns new tokens.
     * + `USER_SRP_AUTH` takes in `USERNAME` and `SRP_A` and returns the SRP variables to be used for next challenge execution.
     * + `USER_PASSWORD_AUTH` takes in `USERNAME` and `PASSWORD` and returns the next challenge or tokens.
     *
     * Valid values include:
     * + `USER_SRP_AUTH`: Authentication flow for the Secure Remote Password (SRP) protocol.
     * + `REFRESH_TOKEN_AUTH`/`REFRESH_TOKEN`: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.
     * + `CUSTOM_AUTH`: Custom authentication flow.
     * + `USER_PASSWORD_AUTH`: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if it doesn't find the USERNAME in the user pool.
     *
     * `ADMIN_NO_SRP_AUTH` isn't a valid value.
     */
    val authFlow: aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthFlowType? = builder.authFlow
    /**
     * The authentication parameters. These are inputs corresponding to the `AuthFlow` that you're invoking. The required values depend on the value of `AuthFlow`:
     * + For `USER_SRP_AUTH`: `USERNAME` (required), `SRP_A` (required), `SECRET_HASH` (required if the app client is configured with a client secret), `DEVICE_KEY`.
     * + For `REFRESH_TOKEN_AUTH/REFRESH_TOKEN`: `REFRESH_TOKEN` (required), `SECRET_HASH` (required if the app client is configured with a client secret), `DEVICE_KEY`.
     * + For `CUSTOM_AUTH`: `USERNAME` (required), `SECRET_HASH` (if app client is configured with client secret), `DEVICE_KEY`. To start the authentication flow with password verification, include `ChallengeName: SRP_A` and `SRP_A: (The SRP_A Value)`.
     */
    val authParameters: Map<String, String>? = builder.authParameters
    /**
     * The app client ID.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.
     *
     * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:
     * + Pre signup
     * + Pre authentication
     * + User migration
     *
     * When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a `validationData` attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the `validationData` value to enhance your workflow for your specific needs.
     *
     * When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn't provide the ClientMetadata value as input:
     * + Post authentication
     * + Custom message
     * + Pre token generation
     * + Create auth challenge
     * + Define auth challenge
     * + Verify auth challenge
     *
     * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
     *
     * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
     * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
     * + Validate the ClientMetadata value.
     * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
     */
    val clientMetadata: Map<String, String>? = builder.clientMetadata
    /**
     * Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.
     */
    val userContextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType? = builder.userContextData

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InitiateAuthRequest(")
        append("analyticsMetadata=$analyticsMetadata,")
        append("authFlow=$authFlow,")
        append("authParameters=*** Sensitive Data Redacted ***,")
        append("clientId=*** Sensitive Data Redacted ***,")
        append("clientMetadata=$clientMetadata,")
        append("userContextData=$userContextData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = analyticsMetadata?.hashCode() ?: 0
        result = 31 * result + (authFlow?.hashCode() ?: 0)
        result = 31 * result + (authParameters?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientMetadata?.hashCode() ?: 0)
        result = 31 * result + (userContextData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InitiateAuthRequest

        if (analyticsMetadata != other.analyticsMetadata) return false
        if (authFlow != other.authFlow) return false
        if (authParameters != other.authParameters) return false
        if (clientId != other.clientId) return false
        if (clientMetadata != other.clientMetadata) return false
        if (userContextData != other.userContextData) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Pinpoint analytics metadata for collecting metrics for `InitiateAuth` calls.
         */
        var analyticsMetadata: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType? = null
        /**
         * The authentication flow for this call to run. The API action will depend on this value. For example:
         * + `REFRESH_TOKEN_AUTH` takes in a valid refresh token and returns new tokens.
         * + `USER_SRP_AUTH` takes in `USERNAME` and `SRP_A` and returns the SRP variables to be used for next challenge execution.
         * + `USER_PASSWORD_AUTH` takes in `USERNAME` and `PASSWORD` and returns the next challenge or tokens.
         *
         * Valid values include:
         * + `USER_SRP_AUTH`: Authentication flow for the Secure Remote Password (SRP) protocol.
         * + `REFRESH_TOKEN_AUTH`/`REFRESH_TOKEN`: Authentication flow for refreshing the access token and ID token by supplying a valid refresh token.
         * + `CUSTOM_AUTH`: Custom authentication flow.
         * + `USER_PASSWORD_AUTH`: Non-SRP authentication flow; USERNAME and PASSWORD are passed directly. If a user migration Lambda trigger is set, this flow will invoke the user migration Lambda if it doesn't find the USERNAME in the user pool.
         *
         * `ADMIN_NO_SRP_AUTH` isn't a valid value.
         */
        var authFlow: aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthFlowType? = null
        /**
         * The authentication parameters. These are inputs corresponding to the `AuthFlow` that you're invoking. The required values depend on the value of `AuthFlow`:
         * + For `USER_SRP_AUTH`: `USERNAME` (required), `SRP_A` (required), `SECRET_HASH` (required if the app client is configured with a client secret), `DEVICE_KEY`.
         * + For `REFRESH_TOKEN_AUTH/REFRESH_TOKEN`: `REFRESH_TOKEN` (required), `SECRET_HASH` (required if the app client is configured with a client secret), `DEVICE_KEY`.
         * + For `CUSTOM_AUTH`: `USERNAME` (required), `SECRET_HASH` (if app client is configured with client secret), `DEVICE_KEY`. To start the authentication flow with password verification, include `ChallengeName: SRP_A` and `SRP_A: (The SRP_A Value)`.
         */
        var authParameters: Map<String, String>? = null
        /**
         * The app client ID.
         */
        var clientId: kotlin.String? = null
        /**
         * A map of custom key-value pairs that you can provide as input for certain custom workflows that this action triggers.
         *
         * You create custom workflows by assigning Lambda functions to user pool triggers. When you use the InitiateAuth API action, Amazon Cognito invokes the Lambda functions that are specified for various triggers. The ClientMetadata value is passed as input to the functions for only the following triggers:
         * + Pre signup
         * + Pre authentication
         * + User migration
         *
         * When Amazon Cognito invokes the functions for these triggers, it passes a JSON payload, which the function receives as input. This payload contains a `validationData` attribute, which provides the data that you assigned to the ClientMetadata parameter in your InitiateAuth request. In your function code in Lambda, you can process the `validationData` value to enhance your workflow for your specific needs.
         *
         * When you use the InitiateAuth API action, Amazon Cognito also invokes the functions for the following triggers, but it doesn't provide the ClientMetadata value as input:
         * + Post authentication
         * + Custom message
         * + Pre token generation
         * + Create auth challenge
         * + Define auth challenge
         * + Verify auth challenge
         *
         * For more information, see [ Customizing user pool Workflows with Lambda Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html) in the *Amazon Cognito Developer Guide*.
         *
         * When you use the ClientMetadata parameter, remember that Amazon Cognito won't do the following:
         * + Store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration doesn't include triggers, the ClientMetadata parameter serves no purpose.
         * + Validate the ClientMetadata value.
         * + Encrypt the ClientMetadata value. Don't use Amazon Cognito to provide sensitive information.
         */
        var clientMetadata: Map<String, String>? = null
        /**
         * Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security.
         */
        var userContextData: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthRequest) : this() {
            this.analyticsMetadata = x.analyticsMetadata
            this.authFlow = x.authFlow
            this.authParameters = x.authParameters
            this.clientId = x.clientId
            this.clientMetadata = x.clientMetadata
            this.userContextData = x.userContextData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthRequest = InitiateAuthRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType] inside the given [block]
         */
        fun analyticsMetadata(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.Builder.() -> kotlin.Unit) {
            this.analyticsMetadata = aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsMetadataType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType] inside the given [block]
         */
        fun userContextData(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType.Builder.() -> kotlin.Unit) {
            this.userContextData = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserContextDataType.invoke(block)
        }
    }
}
