// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Initiates the authentication response.
 */
class InitiateAuthResponse private constructor(builder: Builder) {
    /**
     * The result of the authentication response. This result is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, `ChallengeName`, `ChallengeParameters`, and `Session` are returned.
     */
    val authenticationResult: aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType? = builder.authenticationResult
    /**
     * The name of the challenge that you're responding to with this call. This name is returned in the `AdminInitiateAuth` response if you must pass another challenge.
     *
     * Valid values include the following:
     *
     * All of the following challenges require `USERNAME` and `SECRET_HASH` (if applicable) in the parameters.
     *
     * + `SMS_MFA`: Next challenge is to supply an `SMS_MFA_CODE`, delivered via SMS.
     * + `PASSWORD_VERIFIER`: Next challenge is to supply `PASSWORD_CLAIM_SIGNATURE`, `PASSWORD_CLAIM_SECRET_BLOCK`, and `TIMESTAMP` after the client-side SRP calculations.
     * + `CUSTOM_CHALLENGE`: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.
     * + `DEVICE_SRP_AUTH`: If device tracking was activated on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.
     * + `DEVICE_PASSWORD_VERIFIER`: Similar to `PASSWORD_VERIFIER`, but for devices only.
     * + `NEW_PASSWORD_REQUIRED`: For users who are required to change their passwords after successful first login. This challenge should be passed with `NEW_PASSWORD` and any other required attributes.
     * + `MFA_SETUP`: For users who are required to setup an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters `MFA_CAN_SETUP` value.  To set up software token MFA, use the session returned here from `InitiateAuth` as an input to `AssociateSoftwareToken`. Use the session returned by `VerifySoftwareToken` as an input to `RespondToAuthChallenge` with challenge name `MFA_SETUP` to complete sign-in. To set up SMS MFA, an administrator should help the user to add a phone number to their account, and then the user should call `InitiateAuth` again to restart sign-in.
     */
    val challengeName: aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType? = builder.challengeName
    /**
     * The challenge parameters. These are returned in the `InitiateAuth` response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (`RespondToAuthChallenge`).
     *
     * All challenges require `USERNAME` and `SECRET_HASH` (if applicable).
     */
    val challengeParameters: Map<String, String>? = builder.challengeParameters
    /**
     * The session that should pass both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next `RespondToAuthChallenge` API call.
     */
    val session: kotlin.String? = builder.session

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InitiateAuthResponse(")
        append("authenticationResult=$authenticationResult,")
        append("challengeName=$challengeName,")
        append("challengeParameters=$challengeParameters,")
        append("session=$session)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationResult?.hashCode() ?: 0
        result = 31 * result + (challengeName?.hashCode() ?: 0)
        result = 31 * result + (challengeParameters?.hashCode() ?: 0)
        result = 31 * result + (session?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InitiateAuthResponse

        if (authenticationResult != other.authenticationResult) return false
        if (challengeName != other.challengeName) return false
        if (challengeParameters != other.challengeParameters) return false
        if (session != other.session) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The result of the authentication response. This result is only returned if the caller doesn't need to pass another challenge. If the caller does need to pass another challenge before it gets tokens, `ChallengeName`, `ChallengeParameters`, and `Session` are returned.
         */
        var authenticationResult: aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType? = null
        /**
         * The name of the challenge that you're responding to with this call. This name is returned in the `AdminInitiateAuth` response if you must pass another challenge.
         *
         * Valid values include the following:
         *
         * All of the following challenges require `USERNAME` and `SECRET_HASH` (if applicable) in the parameters.
         *
         * + `SMS_MFA`: Next challenge is to supply an `SMS_MFA_CODE`, delivered via SMS.
         * + `PASSWORD_VERIFIER`: Next challenge is to supply `PASSWORD_CLAIM_SIGNATURE`, `PASSWORD_CLAIM_SECRET_BLOCK`, and `TIMESTAMP` after the client-side SRP calculations.
         * + `CUSTOM_CHALLENGE`: This is returned if your custom authentication flow determines that the user should pass another challenge before tokens are issued.
         * + `DEVICE_SRP_AUTH`: If device tracking was activated on your user pool and the previous challenges were passed, this challenge is returned so that Amazon Cognito can start tracking this device.
         * + `DEVICE_PASSWORD_VERIFIER`: Similar to `PASSWORD_VERIFIER`, but for devices only.
         * + `NEW_PASSWORD_REQUIRED`: For users who are required to change their passwords after successful first login. This challenge should be passed with `NEW_PASSWORD` and any other required attributes.
         * + `MFA_SETUP`: For users who are required to setup an MFA factor before they can sign in. The MFA types activated for the user pool will be listed in the challenge parameters `MFA_CAN_SETUP` value.  To set up software token MFA, use the session returned here from `InitiateAuth` as an input to `AssociateSoftwareToken`. Use the session returned by `VerifySoftwareToken` as an input to `RespondToAuthChallenge` with challenge name `MFA_SETUP` to complete sign-in. To set up SMS MFA, an administrator should help the user to add a phone number to their account, and then the user should call `InitiateAuth` again to restart sign-in.
         */
        var challengeName: aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType? = null
        /**
         * The challenge parameters. These are returned in the `InitiateAuth` response if you must pass another challenge. The responses in this parameter should be used to compute inputs to the next call (`RespondToAuthChallenge`).
         *
         * All challenges require `USERNAME` and `SECRET_HASH` (if applicable).
         */
        var challengeParameters: Map<String, String>? = null
        /**
         * The session that should pass both ways in challenge-response calls to the service. If the caller must pass another challenge, they return a session with other challenge parameters. This session should be passed as it is to the next `RespondToAuthChallenge` API call.
         */
        var session: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthResponse) : this() {
            this.authenticationResult = x.authenticationResult
            this.challengeName = x.challengeName
            this.challengeParameters = x.challengeParameters
            this.session = x.session
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.InitiateAuthResponse = InitiateAuthResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType] inside the given [block]
         */
        fun authenticationResult(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType.Builder.() -> kotlin.Unit) {
            this.authenticationResult = aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType.invoke(block)
        }
    }
}
