// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Contains information about the schema attribute.
 */
class SchemaAttributeType private constructor(builder: Builder) {
    /**
     * The attribute data type.
     */
    val attributeDataType: aws.sdk.kotlin.services.cognitoidentityprovider.model.AttributeDataType? = builder.attributeDataType
    /**
     * You should use [WriteAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes) in the user pool client to control how attributes can be mutated for new use cases instead of using `DeveloperOnlyAttribute`.
     *
     * Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won't be able to modify this attribute using their access token. For example, `DeveloperOnlyAttribute` can be modified using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.
     */
    val developerOnlyAttribute: kotlin.Boolean = builder.developerOnlyAttribute
    /**
     * Specifies whether the value of the attribute can be changed.
     *
     * For any user pool attribute that is mapped to an identity provider attribute, you must set this parameter to `true`. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see [Specifying Identity Provider Attribute Mappings for Your User Pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
     */
    val mutable: kotlin.Boolean = builder.mutable
    /**
     * A schema attribute of the name type.
     */
    val name: kotlin.String? = builder.name
    /**
     * Specifies the constraints for an attribute of the number type.
     */
    val numberAttributeConstraints: aws.sdk.kotlin.services.cognitoidentityprovider.model.NumberAttributeConstraintsType? = builder.numberAttributeConstraints
    /**
     * Specifies whether a user pool attribute is required. If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.
     */
    val required: kotlin.Boolean = builder.required
    /**
     * Specifies the constraints for an attribute of the string type.
     */
    val stringAttributeConstraints: aws.sdk.kotlin.services.cognitoidentityprovider.model.StringAttributeConstraintsType? = builder.stringAttributeConstraints

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.SchemaAttributeType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchemaAttributeType(")
        append("attributeDataType=$attributeDataType,")
        append("developerOnlyAttribute=$developerOnlyAttribute,")
        append("mutable=$mutable,")
        append("name=$name,")
        append("numberAttributeConstraints=$numberAttributeConstraints,")
        append("required=$required,")
        append("stringAttributeConstraints=$stringAttributeConstraints)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeDataType?.hashCode() ?: 0
        result = 31 * result + (developerOnlyAttribute.hashCode())
        result = 31 * result + (mutable.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberAttributeConstraints?.hashCode() ?: 0)
        result = 31 * result + (required.hashCode())
        result = 31 * result + (stringAttributeConstraints?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchemaAttributeType

        if (attributeDataType != other.attributeDataType) return false
        if (developerOnlyAttribute != other.developerOnlyAttribute) return false
        if (mutable != other.mutable) return false
        if (name != other.name) return false
        if (numberAttributeConstraints != other.numberAttributeConstraints) return false
        if (required != other.required) return false
        if (stringAttributeConstraints != other.stringAttributeConstraints) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.SchemaAttributeType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The attribute data type.
         */
        var attributeDataType: aws.sdk.kotlin.services.cognitoidentityprovider.model.AttributeDataType? = null
        /**
         * You should use [WriteAttributes](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes) in the user pool client to control how attributes can be mutated for new use cases instead of using `DeveloperOnlyAttribute`.
         *
         * Specifies whether the attribute type is developer only. This attribute can only be modified by an administrator. Users won't be able to modify this attribute using their access token. For example, `DeveloperOnlyAttribute` can be modified using AdminUpdateUserAttributes but can't be updated using UpdateUserAttributes.
         */
        var developerOnlyAttribute: kotlin.Boolean = false
        /**
         * Specifies whether the value of the attribute can be changed.
         *
         * For any user pool attribute that is mapped to an identity provider attribute, you must set this parameter to `true`. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If an attribute is immutable, Amazon Cognito throws an error when it attempts to update the attribute. For more information, see [Specifying Identity Provider Attribute Mappings for Your User Pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
         */
        var mutable: kotlin.Boolean = false
        /**
         * A schema attribute of the name type.
         */
        var name: kotlin.String? = null
        /**
         * Specifies the constraints for an attribute of the number type.
         */
        var numberAttributeConstraints: aws.sdk.kotlin.services.cognitoidentityprovider.model.NumberAttributeConstraintsType? = null
        /**
         * Specifies whether a user pool attribute is required. If the attribute is required and the user doesn't provide a value, registration or sign-in will fail.
         */
        var required: kotlin.Boolean = false
        /**
         * Specifies the constraints for an attribute of the string type.
         */
        var stringAttributeConstraints: aws.sdk.kotlin.services.cognitoidentityprovider.model.StringAttributeConstraintsType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.SchemaAttributeType) : this() {
            this.attributeDataType = x.attributeDataType
            this.developerOnlyAttribute = x.developerOnlyAttribute
            this.mutable = x.mutable
            this.name = x.name
            this.numberAttributeConstraints = x.numberAttributeConstraints
            this.required = x.required
            this.stringAttributeConstraints = x.stringAttributeConstraints
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.SchemaAttributeType = SchemaAttributeType(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.NumberAttributeConstraintsType] inside the given [block]
         */
        fun numberAttributeConstraints(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.NumberAttributeConstraintsType.Builder.() -> kotlin.Unit) {
            this.numberAttributeConstraints = aws.sdk.kotlin.services.cognitoidentityprovider.model.NumberAttributeConstraintsType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.StringAttributeConstraintsType] inside the given [block]
         */
        fun stringAttributeConstraints(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.StringAttributeConstraintsType.Builder.() -> kotlin.Unit) {
            this.stringAttributeConstraints = aws.sdk.kotlin.services.cognitoidentityprovider.model.StringAttributeConstraintsType.invoke(block)
        }
    }
}
