// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * The SMS text message multi-factor authentication (MFA) configuration type.
 */
class SmsMfaConfigType private constructor(builder: Builder) {
    /**
     * The SMS authentication message that will be sent to users with the code they must sign in. The message must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default message will be used.
     */
    val smsAuthenticationMessage: kotlin.String? = builder.smsAuthenticationMessage
    /**
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role that you provide for your Amazon Web Services account.
     */
    val smsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType? = builder.smsConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaConfigType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SmsMfaConfigType(")
        append("smsAuthenticationMessage=$smsAuthenticationMessage,")
        append("smsConfiguration=$smsConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = smsAuthenticationMessage?.hashCode() ?: 0
        result = 31 * result + (smsConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SmsMfaConfigType

        if (smsAuthenticationMessage != other.smsAuthenticationMessage) return false
        if (smsConfiguration != other.smsConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaConfigType = Builder(this).apply(block).build()

    class Builder {
        /**
         * The SMS authentication message that will be sent to users with the code they must sign in. The message must contain the ‘{####}’ placeholder, which is replaced with the code. If the message isn't included, and default message will be used.
         */
        var smsAuthenticationMessage: kotlin.String? = null
        /**
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To request Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role that you provide for your Amazon Web Services account.
         */
        var smsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaConfigType) : this() {
            this.smsAuthenticationMessage = x.smsAuthenticationMessage
            this.smsConfiguration = x.smsConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsMfaConfigType = SmsMfaConfigType(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType] inside the given [block]
         */
        fun smsConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType.Builder.() -> kotlin.Unit) {
            this.smsConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType.invoke(block)
        }
    }
}
