// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Represents the request to update the user pool client.
 */
class UpdateUserPoolClientRequest private constructor(builder: Builder) {
    /**
     * The time limit after which the access token is no longer valid and can't be used.
     */
    val accessTokenValidity: kotlin.Int? = builder.accessTokenValidity
    /**
     * The allowed OAuth flows.
     *
     * Set to `code` to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.
     *
     * Set to `implicit` to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.
     *
     * Set to `client_credentials` to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.
     */
    val allowedOAuthFlows: List<OAuthFlowType>? = builder.allowedOAuthFlows
    /**
     * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
     */
    val allowedOAuthFlowsUserPoolClient: kotlin.Boolean = builder.allowedOAuthFlowsUserPoolClient
    /**
     * The allowed OAuth scopes. Possible values provided by OAuth are: `phone`, `email`, `openid`, and `profile`. Possible values provided by Amazon Web Services are: `aws.cognito.signin.user.admin`. Custom scopes created in Resource Servers are also supported.
     */
    val allowedOAuthScopes: List<String>? = builder.allowedOAuthScopes
    /**
     * The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.
     *
     * In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
     */
    val analyticsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType? = builder.analyticsConfiguration
    /**
     * A list of allowed redirect (callback) URLs for the identity providers.
     *
     * A redirect URI must:
     * + Be an absolute URI.
     * + Be registered with the authorization server.
     * + Not include a fragment component.
     *
     * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
     *
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     *
     * App callback URLs such as `myapp://example` are also supported.
     */
    val callbackUrLs: List<String>? = builder.callbackUrLs
    /**
     * The ID of the client associated with the user pool.
     */
    val clientId: kotlin.String? = builder.clientId
    /**
     * The client name from the update user pool client request.
     */
    val clientName: kotlin.String? = builder.clientName
    /**
     * The default redirect URI. Must be in the `CallbackURLs` list.
     *
     * A redirect URI must:
     * + Be an absolute URI.
     * + Be registered with the authorization server.
     * + Not include a fragment component.
     *
     * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
     *
     * Amazon Cognito requires HTTPS over HTTP except for `http://localhost` for testing purposes only.
     *
     * App callback URLs such as `myapp://example` are also supported.
     */
    val defaultRedirectUri: kotlin.String? = builder.defaultRedirectUri
    /**
     * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
     */
    val enableTokenRevocation: kotlin.Boolean? = builder.enableTokenRevocation
    /**
     * The authentication flows that are supported by the user pool clients. Flow names without the `ALLOW_` prefix are no longer supported in favor of new names with the `ALLOW_` prefix. Note that values with `ALLOW_` prefix must be used only along with values with the `ALLOW_` prefix.
     *
     * Valid values include:
     * + `ALLOW_ADMIN_USER_PASSWORD_AUTH`: Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH`. This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.
     * + `ALLOW_CUSTOM_AUTH`: Enable Lambda trigger based authentication.
     * + `ALLOW_USER_PASSWORD_AUTH`: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
     * + `ALLOW_USER_SRP_AUTH`: Enable SRP-based authentication.
     * + `ALLOW_REFRESH_TOKEN_AUTH`: Enable authflow to refresh tokens.
     */
    val explicitAuthFlows: List<ExplicitAuthFlowsType>? = builder.explicitAuthFlows
    /**
     * The time limit after which the ID token is no longer valid and can't be used.
     */
    val idTokenValidity: kotlin.Int? = builder.idTokenValidity
    /**
     * A list of allowed logout URLs for the identity providers.
     */
    val logoutUrLs: List<String>? = builder.logoutUrLs
    /**
     * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to `ENABLED` and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs return a `UserNotFoundException` exception if the user doesn't exist in the user pool.
     *
     * Valid values include:
     * + `ENABLED` - This prevents user existence-related errors.
     * + `LEGACY` - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.
     */
    val preventUserExistenceErrors: aws.sdk.kotlin.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes? = builder.preventUserExistenceErrors
    /**
     * The read-only attributes of the user pool.
     */
    val readAttributes: List<String>? = builder.readAttributes
    /**
     * The time limit, in days, after which the refresh token is no longer valid and can't be used.
     */
    val refreshTokenValidity: kotlin.Int = builder.refreshTokenValidity
    /**
     * A list of provider names for the identity providers that are supported on this client.
     */
    val supportedIdentityProviders: List<String>? = builder.supportedIdentityProviders
    /**
     * The units in which the validity times are represented. Default for RefreshToken is days, and default for ID and access tokens is hours.
     */
    val tokenValidityUnits: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType? = builder.tokenValidityUnits
    /**
     * The user pool ID for the user pool where you want to update the user pool client.
     */
    val userPoolId: kotlin.String? = builder.userPoolId
    /**
     * The writeable attributes of the user pool.
     */
    val writeAttributes: List<String>? = builder.writeAttributes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateUserPoolClientRequest(")
        append("accessTokenValidity=$accessTokenValidity,")
        append("allowedOAuthFlows=$allowedOAuthFlows,")
        append("allowedOAuthFlowsUserPoolClient=$allowedOAuthFlowsUserPoolClient,")
        append("allowedOAuthScopes=$allowedOAuthScopes,")
        append("analyticsConfiguration=$analyticsConfiguration,")
        append("callbackUrLs=$callbackUrLs,")
        append("clientId=*** Sensitive Data Redacted ***,")
        append("clientName=$clientName,")
        append("defaultRedirectUri=$defaultRedirectUri,")
        append("enableTokenRevocation=$enableTokenRevocation,")
        append("explicitAuthFlows=$explicitAuthFlows,")
        append("idTokenValidity=$idTokenValidity,")
        append("logoutUrLs=$logoutUrLs,")
        append("preventUserExistenceErrors=$preventUserExistenceErrors,")
        append("readAttributes=$readAttributes,")
        append("refreshTokenValidity=$refreshTokenValidity,")
        append("supportedIdentityProviders=$supportedIdentityProviders,")
        append("tokenValidityUnits=$tokenValidityUnits,")
        append("userPoolId=$userPoolId,")
        append("writeAttributes=$writeAttributes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessTokenValidity ?: 0
        result = 31 * result + (allowedOAuthFlows?.hashCode() ?: 0)
        result = 31 * result + (allowedOAuthFlowsUserPoolClient.hashCode())
        result = 31 * result + (allowedOAuthScopes?.hashCode() ?: 0)
        result = 31 * result + (analyticsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (callbackUrLs?.hashCode() ?: 0)
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientName?.hashCode() ?: 0)
        result = 31 * result + (defaultRedirectUri?.hashCode() ?: 0)
        result = 31 * result + (enableTokenRevocation?.hashCode() ?: 0)
        result = 31 * result + (explicitAuthFlows?.hashCode() ?: 0)
        result = 31 * result + (idTokenValidity ?: 0)
        result = 31 * result + (logoutUrLs?.hashCode() ?: 0)
        result = 31 * result + (preventUserExistenceErrors?.hashCode() ?: 0)
        result = 31 * result + (readAttributes?.hashCode() ?: 0)
        result = 31 * result + (refreshTokenValidity)
        result = 31 * result + (supportedIdentityProviders?.hashCode() ?: 0)
        result = 31 * result + (tokenValidityUnits?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        result = 31 * result + (writeAttributes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateUserPoolClientRequest

        if (accessTokenValidity != other.accessTokenValidity) return false
        if (allowedOAuthFlows != other.allowedOAuthFlows) return false
        if (allowedOAuthFlowsUserPoolClient != other.allowedOAuthFlowsUserPoolClient) return false
        if (allowedOAuthScopes != other.allowedOAuthScopes) return false
        if (analyticsConfiguration != other.analyticsConfiguration) return false
        if (callbackUrLs != other.callbackUrLs) return false
        if (clientId != other.clientId) return false
        if (clientName != other.clientName) return false
        if (defaultRedirectUri != other.defaultRedirectUri) return false
        if (enableTokenRevocation != other.enableTokenRevocation) return false
        if (explicitAuthFlows != other.explicitAuthFlows) return false
        if (idTokenValidity != other.idTokenValidity) return false
        if (logoutUrLs != other.logoutUrLs) return false
        if (preventUserExistenceErrors != other.preventUserExistenceErrors) return false
        if (readAttributes != other.readAttributes) return false
        if (refreshTokenValidity != other.refreshTokenValidity) return false
        if (supportedIdentityProviders != other.supportedIdentityProviders) return false
        if (tokenValidityUnits != other.tokenValidityUnits) return false
        if (userPoolId != other.userPoolId) return false
        if (writeAttributes != other.writeAttributes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time limit after which the access token is no longer valid and can't be used.
         */
        var accessTokenValidity: kotlin.Int? = null
        /**
         * The allowed OAuth flows.
         *
         * Set to `code` to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.
         *
         * Set to `implicit` to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.
         *
         * Set to `client_credentials` to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.
         */
        var allowedOAuthFlows: List<OAuthFlowType>? = null
        /**
         * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
         */
        var allowedOAuthFlowsUserPoolClient: kotlin.Boolean = false
        /**
         * The allowed OAuth scopes. Possible values provided by OAuth are: `phone`, `email`, `openid`, and `profile`. Possible values provided by Amazon Web Services are: `aws.cognito.signin.user.admin`. Custom scopes created in Resource Servers are also supported.
         */
        var allowedOAuthScopes: List<String>? = null
        /**
         * The Amazon Pinpoint analytics configuration for collecting metrics for this user pool.
         *
         * In Amazon Web Services Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
         */
        var analyticsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType? = null
        /**
         * A list of allowed redirect (callback) URLs for the identity providers.
         *
         * A redirect URI must:
         * + Be an absolute URI.
         * + Be registered with the authorization server.
         * + Not include a fragment component.
         *
         * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
         *
         * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *
         * App callback URLs such as `myapp://example` are also supported.
         */
        var callbackUrLs: List<String>? = null
        /**
         * The ID of the client associated with the user pool.
         */
        var clientId: kotlin.String? = null
        /**
         * The client name from the update user pool client request.
         */
        var clientName: kotlin.String? = null
        /**
         * The default redirect URI. Must be in the `CallbackURLs` list.
         *
         * A redirect URI must:
         * + Be an absolute URI.
         * + Be registered with the authorization server.
         * + Not include a fragment component.
         *
         * See [OAuth 2.0 - Redirection Endpoint](https://tools.ietf.org/html/rfc6749#section-3.1.2).
         *
         * Amazon Cognito requires HTTPS over HTTP except for `http://localhost` for testing purposes only.
         *
         * App callback URLs such as `myapp://example` are also supported.
         */
        var defaultRedirectUri: kotlin.String? = null
        /**
         * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html).
         */
        var enableTokenRevocation: kotlin.Boolean? = null
        /**
         * The authentication flows that are supported by the user pool clients. Flow names without the `ALLOW_` prefix are no longer supported in favor of new names with the `ALLOW_` prefix. Note that values with `ALLOW_` prefix must be used only along with values with the `ALLOW_` prefix.
         *
         * Valid values include:
         * + `ALLOW_ADMIN_USER_PASSWORD_AUTH`: Enable admin based user password authentication flow `ADMIN_USER_PASSWORD_AUTH`. This setting replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.
         * + `ALLOW_CUSTOM_AUTH`: Enable Lambda trigger based authentication.
         * + `ALLOW_USER_PASSWORD_AUTH`: Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.
         * + `ALLOW_USER_SRP_AUTH`: Enable SRP-based authentication.
         * + `ALLOW_REFRESH_TOKEN_AUTH`: Enable authflow to refresh tokens.
         */
        var explicitAuthFlows: List<ExplicitAuthFlowsType>? = null
        /**
         * The time limit after which the ID token is no longer valid and can't be used.
         */
        var idTokenValidity: kotlin.Int? = null
        /**
         * A list of allowed logout URLs for the identity providers.
         */
        var logoutUrLs: List<String>? = null
        /**
         * Errors and responses that you want Amazon Cognito APIs to return during authentication, account confirmation, and password recovery when the user doesn't exist in the user pool. When set to `ENABLED` and the user doesn't exist, authentication returns an error indicating either the username or password was incorrect. Account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to `LEGACY`, those APIs return a `UserNotFoundException` exception if the user doesn't exist in the user pool.
         *
         * Valid values include:
         * + `ENABLED` - This prevents user existence-related errors.
         * + `LEGACY` - This represents the early behavior of Amazon Cognito where user existence related errors aren't prevented.
         */
        var preventUserExistenceErrors: aws.sdk.kotlin.services.cognitoidentityprovider.model.PreventUserExistenceErrorTypes? = null
        /**
         * The read-only attributes of the user pool.
         */
        var readAttributes: List<String>? = null
        /**
         * The time limit, in days, after which the refresh token is no longer valid and can't be used.
         */
        var refreshTokenValidity: kotlin.Int = 0
        /**
         * A list of provider names for the identity providers that are supported on this client.
         */
        var supportedIdentityProviders: List<String>? = null
        /**
         * The units in which the validity times are represented. Default for RefreshToken is days, and default for ID and access tokens is hours.
         */
        var tokenValidityUnits: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType? = null
        /**
         * The user pool ID for the user pool where you want to update the user pool client.
         */
        var userPoolId: kotlin.String? = null
        /**
         * The writeable attributes of the user pool.
         */
        var writeAttributes: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest) : this() {
            this.accessTokenValidity = x.accessTokenValidity
            this.allowedOAuthFlows = x.allowedOAuthFlows
            this.allowedOAuthFlowsUserPoolClient = x.allowedOAuthFlowsUserPoolClient
            this.allowedOAuthScopes = x.allowedOAuthScopes
            this.analyticsConfiguration = x.analyticsConfiguration
            this.callbackUrLs = x.callbackUrLs
            this.clientId = x.clientId
            this.clientName = x.clientName
            this.defaultRedirectUri = x.defaultRedirectUri
            this.enableTokenRevocation = x.enableTokenRevocation
            this.explicitAuthFlows = x.explicitAuthFlows
            this.idTokenValidity = x.idTokenValidity
            this.logoutUrLs = x.logoutUrLs
            this.preventUserExistenceErrors = x.preventUserExistenceErrors
            this.readAttributes = x.readAttributes
            this.refreshTokenValidity = x.refreshTokenValidity
            this.supportedIdentityProviders = x.supportedIdentityProviders
            this.tokenValidityUnits = x.tokenValidityUnits
            this.userPoolId = x.userPoolId
            this.writeAttributes = x.writeAttributes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolClientRequest = UpdateUserPoolClientRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType] inside the given [block]
         */
        fun analyticsConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType.Builder.() -> kotlin.Unit) {
            this.analyticsConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.AnalyticsConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType] inside the given [block]
         */
        fun tokenValidityUnits(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType.Builder.() -> kotlin.Unit) {
            this.tokenValidityUnits = aws.sdk.kotlin.services.cognitoidentityprovider.model.TokenValidityUnitsType.invoke(block)
        }
    }
}
