// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model



/**
 * Represents the request to update the user pool.
 */
class UpdateUserPoolRequest private constructor(builder: Builder) {
    /**
     * The available verified method a user can use to recover their password when they call `ForgotPassword`. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
     */
    val accountRecoverySetting: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType? = builder.accountRecoverySetting
    /**
     * The configuration for `AdminCreateUser` requests.
     */
    val adminCreateUserConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType? = builder.adminCreateUserConfig
    /**
     * The attributes that are automatically verified when Amazon Cognito requests to update user pools.
     */
    val autoVerifiedAttributes: List<VerifiedAttributeType>? = builder.autoVerifiedAttributes
    /**
     * Device configuration.
     */
    val deviceConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType? = builder.deviceConfiguration
    /**
     * The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for email invitation and verification messages from your user pool.
     */
    val emailConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType? = builder.emailConfiguration
    /**
     * The contents of the email verification message.
     */
    val emailVerificationMessage: kotlin.String? = builder.emailVerificationMessage
    /**
     * The subject of the email verification message.
     */
    val emailVerificationSubject: kotlin.String? = builder.emailVerificationSubject
    /**
     * The Lambda configuration information from the request to update the user pool.
     */
    val lambdaConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType? = builder.lambdaConfig
    /**
     * Can be one of the following values:
     * + `OFF` - MFA tokens aren't required and can't be specified during user registration.
     * + `ON` - MFA tokens are required for all user registrations. You can only specify ON when you're initially creating a user pool. You can use the [SetUserPoolMfaConfig](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html) API operation to turn MFA "ON" for existing user pools.
     * + `OPTIONAL` - Users have the option when registering to create an MFA token.
     */
    val mfaConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolMfaType? = builder.mfaConfiguration
    /**
     * A container with the policies you want to update in a user pool.
     */
    val policies: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType? = builder.policies
    /**
     * The contents of the SMS authentication message.
     */
    val smsAuthenticationMessage: kotlin.String? = builder.smsAuthenticationMessage
    /**
     * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.
     */
    val smsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType? = builder.smsConfiguration
    /**
     * A container with information about the SMS verification message.
     */
    val smsVerificationMessage: kotlin.String? = builder.smsVerificationMessage
    /**
     * Enables advanced security risk detection. Set the key `AdvancedSecurityMode` to the value "AUDIT".
     */
    val userPoolAddOns: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType? = builder.userPoolAddOns
    /**
     * The user pool ID for the user pool you want to update.
     */
    val userPoolId: kotlin.String? = builder.userPoolId
    /**
     * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
     */
    val userPoolTags: Map<String, String>? = builder.userPoolTags
    /**
     * The template for verification messages.
     */
    val verificationMessageTemplate: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType? = builder.verificationMessageTemplate

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateUserPoolRequest(")
        append("accountRecoverySetting=$accountRecoverySetting,")
        append("adminCreateUserConfig=$adminCreateUserConfig,")
        append("autoVerifiedAttributes=$autoVerifiedAttributes,")
        append("deviceConfiguration=$deviceConfiguration,")
        append("emailConfiguration=$emailConfiguration,")
        append("emailVerificationMessage=$emailVerificationMessage,")
        append("emailVerificationSubject=$emailVerificationSubject,")
        append("lambdaConfig=$lambdaConfig,")
        append("mfaConfiguration=$mfaConfiguration,")
        append("policies=$policies,")
        append("smsAuthenticationMessage=$smsAuthenticationMessage,")
        append("smsConfiguration=$smsConfiguration,")
        append("smsVerificationMessage=$smsVerificationMessage,")
        append("userPoolAddOns=$userPoolAddOns,")
        append("userPoolId=$userPoolId,")
        append("userPoolTags=$userPoolTags,")
        append("verificationMessageTemplate=$verificationMessageTemplate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountRecoverySetting?.hashCode() ?: 0
        result = 31 * result + (adminCreateUserConfig?.hashCode() ?: 0)
        result = 31 * result + (autoVerifiedAttributes?.hashCode() ?: 0)
        result = 31 * result + (deviceConfiguration?.hashCode() ?: 0)
        result = 31 * result + (emailConfiguration?.hashCode() ?: 0)
        result = 31 * result + (emailVerificationMessage?.hashCode() ?: 0)
        result = 31 * result + (emailVerificationSubject?.hashCode() ?: 0)
        result = 31 * result + (lambdaConfig?.hashCode() ?: 0)
        result = 31 * result + (mfaConfiguration?.hashCode() ?: 0)
        result = 31 * result + (policies?.hashCode() ?: 0)
        result = 31 * result + (smsAuthenticationMessage?.hashCode() ?: 0)
        result = 31 * result + (smsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (smsVerificationMessage?.hashCode() ?: 0)
        result = 31 * result + (userPoolAddOns?.hashCode() ?: 0)
        result = 31 * result + (userPoolId?.hashCode() ?: 0)
        result = 31 * result + (userPoolTags?.hashCode() ?: 0)
        result = 31 * result + (verificationMessageTemplate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateUserPoolRequest

        if (accountRecoverySetting != other.accountRecoverySetting) return false
        if (adminCreateUserConfig != other.adminCreateUserConfig) return false
        if (autoVerifiedAttributes != other.autoVerifiedAttributes) return false
        if (deviceConfiguration != other.deviceConfiguration) return false
        if (emailConfiguration != other.emailConfiguration) return false
        if (emailVerificationMessage != other.emailVerificationMessage) return false
        if (emailVerificationSubject != other.emailVerificationSubject) return false
        if (lambdaConfig != other.lambdaConfig) return false
        if (mfaConfiguration != other.mfaConfiguration) return false
        if (policies != other.policies) return false
        if (smsAuthenticationMessage != other.smsAuthenticationMessage) return false
        if (smsConfiguration != other.smsConfiguration) return false
        if (smsVerificationMessage != other.smsVerificationMessage) return false
        if (userPoolAddOns != other.userPoolAddOns) return false
        if (userPoolId != other.userPoolId) return false
        if (userPoolTags != other.userPoolTags) return false
        if (verificationMessageTemplate != other.verificationMessageTemplate) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The available verified method a user can use to recover their password when they call `ForgotPassword`. You can use this setting to define a preferred method when a user has more than one method available. With this setting, SMS doesn't qualify for a valid password recovery mechanism if the user also has SMS multi-factor authentication (MFA) activated. In the absence of this setting, Amazon Cognito uses the legacy behavior to determine the recovery method where SMS is preferred through email.
         */
        var accountRecoverySetting: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType? = null
        /**
         * The configuration for `AdminCreateUser` requests.
         */
        var adminCreateUserConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType? = null
        /**
         * The attributes that are automatically verified when Amazon Cognito requests to update user pools.
         */
        var autoVerifiedAttributes: List<VerifiedAttributeType>? = null
        /**
         * Device configuration.
         */
        var deviceConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType? = null
        /**
         * The email configuration of your user pool. The email configuration type sets your preferred sending method, Amazon Web Services Region, and sender for email invitation and verification messages from your user pool.
         */
        var emailConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType? = null
        /**
         * The contents of the email verification message.
         */
        var emailVerificationMessage: kotlin.String? = null
        /**
         * The subject of the email verification message.
         */
        var emailVerificationSubject: kotlin.String? = null
        /**
         * The Lambda configuration information from the request to update the user pool.
         */
        var lambdaConfig: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType? = null
        /**
         * Can be one of the following values:
         * + `OFF` - MFA tokens aren't required and can't be specified during user registration.
         * + `ON` - MFA tokens are required for all user registrations. You can only specify ON when you're initially creating a user pool. You can use the [SetUserPoolMfaConfig](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SetUserPoolMfaConfig.html) API operation to turn MFA "ON" for existing user pools.
         * + `OPTIONAL` - Users have the option when registering to create an MFA token.
         */
        var mfaConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolMfaType? = null
        /**
         * A container with the policies you want to update in a user pool.
         */
        var policies: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType? = null
        /**
         * The contents of the SMS authentication message.
         */
        var smsAuthenticationMessage: kotlin.String? = null
        /**
         * The SMS configuration with the settings that your Amazon Cognito user pool must use to send an SMS message from your Amazon Web Services account through Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon Web Services Region that you want, the Amazon Cognito user pool uses an Identity and Access Management (IAM) role in your Amazon Web Services account.
         */
        var smsConfiguration: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType? = null
        /**
         * A container with information about the SMS verification message.
         */
        var smsVerificationMessage: kotlin.String? = null
        /**
         * Enables advanced security risk detection. Set the key `AdvancedSecurityMode` to the value "AUDIT".
         */
        var userPoolAddOns: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType? = null
        /**
         * The user pool ID for the user pool you want to update.
         */
        var userPoolId: kotlin.String? = null
        /**
         * The tag keys and values to assign to the user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
         */
        var userPoolTags: Map<String, String>? = null
        /**
         * The template for verification messages.
         */
        var verificationMessageTemplate: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolRequest) : this() {
            this.accountRecoverySetting = x.accountRecoverySetting
            this.adminCreateUserConfig = x.adminCreateUserConfig
            this.autoVerifiedAttributes = x.autoVerifiedAttributes
            this.deviceConfiguration = x.deviceConfiguration
            this.emailConfiguration = x.emailConfiguration
            this.emailVerificationMessage = x.emailVerificationMessage
            this.emailVerificationSubject = x.emailVerificationSubject
            this.lambdaConfig = x.lambdaConfig
            this.mfaConfiguration = x.mfaConfiguration
            this.policies = x.policies
            this.smsAuthenticationMessage = x.smsAuthenticationMessage
            this.smsConfiguration = x.smsConfiguration
            this.smsVerificationMessage = x.smsVerificationMessage
            this.userPoolAddOns = x.userPoolAddOns
            this.userPoolId = x.userPoolId
            this.userPoolTags = x.userPoolTags
            this.verificationMessageTemplate = x.verificationMessageTemplate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UpdateUserPoolRequest = UpdateUserPoolRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType] inside the given [block]
         */
        fun accountRecoverySetting(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType.Builder.() -> kotlin.Unit) {
            this.accountRecoverySetting = aws.sdk.kotlin.services.cognitoidentityprovider.model.AccountRecoverySettingType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType] inside the given [block]
         */
        fun adminCreateUserConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType.Builder.() -> kotlin.Unit) {
            this.adminCreateUserConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminCreateUserConfigType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType] inside the given [block]
         */
        fun deviceConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType.Builder.() -> kotlin.Unit) {
            this.deviceConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.DeviceConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType] inside the given [block]
         */
        fun emailConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType.Builder.() -> kotlin.Unit) {
            this.emailConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.EmailConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType] inside the given [block]
         */
        fun lambdaConfig(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType.Builder.() -> kotlin.Unit) {
            this.lambdaConfig = aws.sdk.kotlin.services.cognitoidentityprovider.model.LambdaConfigType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType] inside the given [block]
         */
        fun policies(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType.Builder.() -> kotlin.Unit) {
            this.policies = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolPolicyType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType] inside the given [block]
         */
        fun smsConfiguration(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType.Builder.() -> kotlin.Unit) {
            this.smsConfiguration = aws.sdk.kotlin.services.cognitoidentityprovider.model.SmsConfigurationType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType] inside the given [block]
         */
        fun userPoolAddOns(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType.Builder.() -> kotlin.Unit) {
            this.userPoolAddOns = aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolAddOnsType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType] inside the given [block]
         */
        fun verificationMessageTemplate(block: aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType.Builder.() -> kotlin.Unit) {
            this.verificationMessageTemplate = aws.sdk.kotlin.services.cognitoidentityprovider.model.VerificationMessageTemplateType.invoke(block)
        }
    }
}
