// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The user type.
 */
class UserType private constructor(builder: Builder) {
    /**
     * A container with information about the user type attributes.
     */
    val attributes: List<AttributeType>? = builder.attributes
    /**
     * Specifies whether the user is enabled.
     */
    val enabled: kotlin.Boolean = builder.enabled
    /**
     * The MFA options for the user.
     */
    val mfaOptions: List<MfaOptionType>? = builder.mfaOptions
    /**
     * The creation date of the user.
     */
    val userCreateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.userCreateDate
    /**
     * The last modified date of the user.
     */
    val userLastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.userLastModifiedDate
    /**
     * The user status. This can be one of the following:
     * + UNCONFIRMED - User has been created but not confirmed.
     * + CONFIRMED - User has been confirmed.
     * + ARCHIVED - User is no longer active.
     * + UNKNOWN - User status isn't known.
     * + RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.
     * + FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else.
     */
    val userStatus: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserStatusType? = builder.userStatus
    /**
     * The user name of the user you want to describe.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserType(")
        append("attributes=$attributes,")
        append("enabled=$enabled,")
        append("mfaOptions=$mfaOptions,")
        append("userCreateDate=$userCreateDate,")
        append("userLastModifiedDate=$userLastModifiedDate,")
        append("userStatus=$userStatus,")
        append("username=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (mfaOptions?.hashCode() ?: 0)
        result = 31 * result + (userCreateDate?.hashCode() ?: 0)
        result = 31 * result + (userLastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (userStatus?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserType

        if (attributes != other.attributes) return false
        if (enabled != other.enabled) return false
        if (mfaOptions != other.mfaOptions) return false
        if (userCreateDate != other.userCreateDate) return false
        if (userLastModifiedDate != other.userLastModifiedDate) return false
        if (userStatus != other.userStatus) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserType = Builder(this).apply(block).build()

    class Builder {
        /**
         * A container with information about the user type attributes.
         */
        var attributes: List<AttributeType>? = null
        /**
         * Specifies whether the user is enabled.
         */
        var enabled: kotlin.Boolean = false
        /**
         * The MFA options for the user.
         */
        var mfaOptions: List<MfaOptionType>? = null
        /**
         * The creation date of the user.
         */
        var userCreateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last modified date of the user.
         */
        var userLastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user status. This can be one of the following:
         * + UNCONFIRMED - User has been created but not confirmed.
         * + CONFIRMED - User has been confirmed.
         * + ARCHIVED - User is no longer active.
         * + UNKNOWN - User status isn't known.
         * + RESET_REQUIRED - User is confirmed, but the user must request a code and reset their password before they can sign in.
         * + FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in using a temporary password, but on first sign-in, the user must change their password to a new value before doing anything else.
         */
        var userStatus: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserStatusType? = null
        /**
         * The user name of the user you want to describe.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cognitoidentityprovider.model.UserType) : this() {
            this.attributes = x.attributes
            this.enabled = x.enabled
            this.mfaOptions = x.mfaOptions
            this.userCreateDate = x.userCreateDate
            this.userLastModifiedDate = x.userLastModifiedDate
            this.userStatus = x.userStatus
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cognitoidentityprovider.model.UserType = UserType(this)
    }
}
