// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AdminSetUserMfaPreferenceResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AdminSetUserMFAPreferenceOperationDeserializer: HttpDeserialize<AdminSetUserMfaPreferenceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AdminSetUserMfaPreferenceResponse {
        if (!response.status.isSuccess()) {
            throwAdminSetUserMfaPreferenceError(context, response)
        }
        val builder = AdminSetUserMfaPreferenceResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAdminSetUserMfaPreferenceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PasswordResetRequiredException" -> PasswordResetRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotConfirmedException" -> UserNotConfirmedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
