// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CreateUserPoolResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.UserPoolType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateUserPoolOperationDeserializer: HttpDeserialize<CreateUserPoolResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateUserPoolResponse {
        if (!response.status.isSuccess()) {
            throwCreateUserPoolError(context, response)
        }
        val builder = CreateUserPoolResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateUserPoolOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateUserPoolError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidEmailRoleAccessPolicyException" -> InvalidEmailRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleAccessPolicyException" -> InvalidSmsRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleTrustRelationshipException" -> InvalidSmsRoleTrustRelationshipExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserPoolTaggingException" -> UserPoolTaggingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateUserPoolOperationBody(builder: CreateUserPoolResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val USERPOOL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserPool"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(USERPOOL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                USERPOOL_DESCRIPTOR.index -> builder.userPool = deserializeUserPoolTypeDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
