// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AttributeType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.GetUserResponse
import aws.sdk.kotlin.services.cognitoidentityprovider.model.MfaOptionType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetUserOperationDeserializer: HttpDeserialize<GetUserResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetUserResponse {
        if (!response.status.isSuccess()) {
            throwGetUserError(context, response)
        }
        val builder = GetUserResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetUserOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetUserError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PasswordResetRequiredException" -> PasswordResetRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotConfirmedException" -> UserNotConfirmedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetUserOperationBody(builder: GetUserResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MFAOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("MFAOptions"))
    val PREFERREDMFASETTING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PreferredMfaSetting"))
    val USERATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UserAttributes"))
    val USERMFASETTINGLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UserMFASettingList"))
    val USERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Username"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MFAOPTIONS_DESCRIPTOR)
        field(PREFERREDMFASETTING_DESCRIPTOR)
        field(USERATTRIBUTES_DESCRIPTOR)
        field(USERMFASETTINGLIST_DESCRIPTOR)
        field(USERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MFAOPTIONS_DESCRIPTOR.index -> builder.mfaOptions =
                    deserializer.deserializeList(MFAOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<MfaOptionType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMfaOptionTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PREFERREDMFASETTING_DESCRIPTOR.index -> builder.preferredMfaSetting = deserializeString()
                USERATTRIBUTES_DESCRIPTOR.index -> builder.userAttributes =
                    deserializer.deserializeList(USERATTRIBUTES_DESCRIPTOR) {
                        val col0 = mutableListOf<AttributeType>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAttributeTypeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERMFASETTINGLIST_DESCRIPTOR.index -> builder.userMfaSettingList =
                    deserializer.deserializeList(USERMFASETTINGLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USERNAME_DESCRIPTOR.index -> builder.username = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
