// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cognitoidentityprovider.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.cognitoidentityprovider.model.AuthenticationResultType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.ChallengeNameType
import aws.sdk.kotlin.services.cognitoidentityprovider.model.CognitoIdentityProviderException
import aws.sdk.kotlin.services.cognitoidentityprovider.model.RespondToAuthChallengeResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RespondToAuthChallengeOperationDeserializer: HttpDeserialize<RespondToAuthChallengeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RespondToAuthChallengeResponse {
        if (!response.status.isSuccess()) {
            throwRespondToAuthChallengeError(context, response)
        }
        val builder = RespondToAuthChallengeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRespondToAuthChallengeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRespondToAuthChallengeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CognitoIdentityProviderException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AliasExistsException" -> AliasExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "CodeMismatchException" -> CodeMismatchExceptionDeserializer().deserialize(context, wrappedResponse)
        "ExpiredCodeException" -> ExpiredCodeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidLambdaResponseException" -> InvalidLambdaResponseExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPasswordException" -> InvalidPasswordExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleAccessPolicyException" -> InvalidSmsRoleAccessPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSmsRoleTrustRelationshipException" -> InvalidSmsRoleTrustRelationshipExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidUserPoolConfigurationException" -> InvalidUserPoolConfigurationExceptionDeserializer().deserialize(context, wrappedResponse)
        "MFAMethodNotFoundException" -> MfaMethodNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotAuthorizedException" -> NotAuthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        "PasswordResetRequiredException" -> PasswordResetRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "SoftwareTokenMFANotFoundException" -> SoftwareTokenMfaNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnexpectedLambdaException" -> UnexpectedLambdaExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserLambdaValidationException" -> UserLambdaValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotConfirmedException" -> UserNotConfirmedExceptionDeserializer().deserialize(context, wrappedResponse)
        "UserNotFoundException" -> UserNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CognitoIdentityProviderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRespondToAuthChallengeOperationBody(builder: RespondToAuthChallengeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHENTICATIONRESULT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AuthenticationResult"))
    val CHALLENGENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChallengeName"))
    val CHALLENGEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ChallengeParameters"))
    val SESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Session"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHENTICATIONRESULT_DESCRIPTOR)
        field(CHALLENGENAME_DESCRIPTOR)
        field(CHALLENGEPARAMETERS_DESCRIPTOR)
        field(SESSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHENTICATIONRESULT_DESCRIPTOR.index -> builder.authenticationResult = deserializeAuthenticationResultTypeDocument(deserializer)
                CHALLENGENAME_DESCRIPTOR.index -> builder.challengeName = deserializeString().let { ChallengeNameType.fromValue(it) }
                CHALLENGEPARAMETERS_DESCRIPTOR.index -> builder.challengeParameters =
                    deserializer.deserializeMap(CHALLENGEPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                SESSION_DESCRIPTOR.index -> builder.session = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
