// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.comprehend.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.comprehend.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.crt.CrtAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Comprehend is an AWS service for gaining insight into the content of documents. Use these actions to determine the topics contained in your documents, the topics they discuss, the predominant sentiment expressed in them, the predominant language used, and more.
 */
interface ComprehendClient : SdkClient {

    override val serviceName: String
        get() = "Comprehend"
    /**
     * ComprehendClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ComprehendClient {
            val config = Config.Builder().apply(block).build()
            return DefaultComprehendClient(config)
        }

        operator fun invoke(config: Config): ComprehendClient = DefaultComprehendClient(config)

        /**
         * Construct a [ComprehendClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ComprehendClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultComprehendClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: CrtAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    suspend fun batchDetectDominantLanguage(input: BatchDetectDominantLanguageRequest): BatchDetectDominantLanguageResponse

    /**
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    suspend fun batchDetectDominantLanguage(block: BatchDetectDominantLanguageRequest.Builder.() -> Unit) = batchDetectDominantLanguage(BatchDetectDominantLanguageRequest.Builder().apply(block).build())

    /**
     * Inspects the text of a batch of documents for named entities and returns information about them. For more information about named entities, see how-entities
     */
    suspend fun batchDetectEntities(input: BatchDetectEntitiesRequest): BatchDetectEntitiesResponse

    /**
     * Inspects the text of a batch of documents for named entities and returns information about them. For more information about named entities, see how-entities
     */
    suspend fun batchDetectEntities(block: BatchDetectEntitiesRequest.Builder.() -> Unit) = batchDetectEntities(BatchDetectEntitiesRequest.Builder().apply(block).build())

    /**
     * Detects the key noun phrases found in a batch of documents.
     */
    suspend fun batchDetectKeyPhrases(input: BatchDetectKeyPhrasesRequest): BatchDetectKeyPhrasesResponse

    /**
     * Detects the key noun phrases found in a batch of documents.
     */
    suspend fun batchDetectKeyPhrases(block: BatchDetectKeyPhrasesRequest.Builder.() -> Unit) = batchDetectKeyPhrases(BatchDetectKeyPhrasesRequest.Builder().apply(block).build())

    /**
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, `POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`, in each one.
     */
    suspend fun batchDetectSentiment(input: BatchDetectSentimentRequest): BatchDetectSentimentResponse

    /**
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, `POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`, in each one.
     */
    suspend fun batchDetectSentiment(block: BatchDetectSentimentRequest.Builder.() -> Unit) = batchDetectSentiment(BatchDetectSentimentRequest.Builder().apply(block).build())

    /**
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see how-syntax.
     */
    suspend fun batchDetectSyntax(input: BatchDetectSyntaxRequest): BatchDetectSyntaxResponse

    /**
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see how-syntax.
     */
    suspend fun batchDetectSyntax(block: BatchDetectSyntaxRequest.Builder.() -> Unit) = batchDetectSyntax(BatchDetectSyntaxRequest.Builder().apply(block).build())

    /**
     * Creates a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint.
     */
    suspend fun classifyDocument(input: ClassifyDocumentRequest): ClassifyDocumentResponse

    /**
     * Creates a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint.
     */
    suspend fun classifyDocument(block: ClassifyDocumentRequest.Builder.() -> Unit) = classifyDocument(ClassifyDocumentRequest.Builder().apply(block).build())

    /**
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.
     */
    suspend fun containsPiiEntities(input: ContainsPiiEntitiesRequest): ContainsPiiEntitiesResponse

    /**
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.
     */
    suspend fun containsPiiEntities(block: ContainsPiiEntitiesRequest.Builder.() -> Unit) = containsPiiEntities(ContainsPiiEntitiesRequest.Builder().apply(block).build())

    /**
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that labeled with the categories that you want to use. After the classifier is trained you can use it to categorize a set of labeled documents into the categories. For more information, see how-document-classification.
     */
    suspend fun createDocumentClassifier(input: CreateDocumentClassifierRequest): CreateDocumentClassifierResponse

    /**
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that labeled with the categories that you want to use. After the classifier is trained you can use it to categorize a set of labeled documents into the categories. For more information, see how-document-classification.
     */
    suspend fun createDocumentClassifier(block: CreateDocumentClassifierRequest.Builder.() -> Unit) = createDocumentClassifier(CreateDocumentClassifierRequest.Builder().apply(block).build())

    /**
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model
     */
    suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse

    /**
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model
     */
    suspend fun createEndpoint(block: CreateEndpointRequest.Builder.() -> Unit) = createEndpoint(CreateEndpointRequest.Builder().apply(block).build())

    /**
     * Creates an entity recognizer using submitted files. After your `CreateEntityRecognizer` request is submitted, you can check job status using the API.
     */
    suspend fun createEntityRecognizer(input: CreateEntityRecognizerRequest): CreateEntityRecognizerResponse

    /**
     * Creates an entity recognizer using submitted files. After your `CreateEntityRecognizer` request is submitted, you can check job status using the API.
     */
    suspend fun createEntityRecognizer(block: CreateEntityRecognizerRequest.Builder.() -> Unit) = createEntityRecognizer(CreateEntityRecognizerRequest.Builder().apply(block).build())

    /**
     * Deletes a previously created document classifier
     *
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use.
     */
    suspend fun deleteDocumentClassifier(input: DeleteDocumentClassifierRequest): DeleteDocumentClassifierResponse

    /**
     * Deletes a previously created document classifier
     *
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use.
     */
    suspend fun deleteDocumentClassifier(block: DeleteDocumentClassifierRequest.Builder.() -> Unit) = deleteDocumentClassifier(DeleteDocumentClassifierRequest.Builder().apply(block).build())

    /**
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted.
     */
    suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse

    /**
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted.
     */
    suspend fun deleteEndpoint(block: DeleteEndpointRequest.Builder.() -> Unit) = deleteEndpoint(DeleteEndpointRequest.Builder().apply(block).build())

    /**
     * Deletes an entity recognizer.
     *
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     */
    suspend fun deleteEntityRecognizer(input: DeleteEntityRecognizerRequest): DeleteEntityRecognizerResponse

    /**
     * Deletes an entity recognizer.
     *
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     */
    suspend fun deleteEntityRecognizer(block: DeleteEntityRecognizerRequest.Builder.() -> Unit) = deleteEntityRecognizer(DeleteEntityRecognizerRequest.Builder().apply(block).build())

    /**
     * Deletes a resource-based policy that is attached to a custom model.
     */
    suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes a resource-based policy that is attached to a custom model.
     */
    suspend fun deleteResourcePolicy(block: DeleteResourcePolicyRequest.Builder.() -> Unit) = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.
     */
    suspend fun describeDocumentClassificationJob(input: DescribeDocumentClassificationJobRequest): DescribeDocumentClassificationJobResponse

    /**
     * Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.
     */
    suspend fun describeDocumentClassificationJob(block: DescribeDocumentClassificationJobRequest.Builder.() -> Unit) = describeDocumentClassificationJob(DescribeDocumentClassificationJobRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a document classifier.
     */
    suspend fun describeDocumentClassifier(input: DescribeDocumentClassifierRequest): DescribeDocumentClassifierResponse

    /**
     * Gets the properties associated with a document classifier.
     */
    suspend fun describeDocumentClassifier(block: DescribeDocumentClassifierRequest.Builder.() -> Unit) = describeDocumentClassifier(DescribeDocumentClassifierRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeDominantLanguageDetectionJob(input: DescribeDominantLanguageDetectionJobRequest): DescribeDominantLanguageDetectionJobResponse

    /**
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeDominantLanguageDetectionJob(block: DescribeDominantLanguageDetectionJobRequest.Builder.() -> Unit) = describeDominantLanguageDetectionJob(DescribeDominantLanguageDetectionJobRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.
     */
    suspend fun describeEndpoint(input: DescribeEndpointRequest): DescribeEndpointResponse

    /**
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.
     */
    suspend fun describeEndpoint(block: DescribeEndpointRequest.Builder.() -> Unit) = describeEndpoint(DescribeEndpointRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeEntitiesDetectionJob(input: DescribeEntitiesDetectionJobRequest): DescribeEntitiesDetectionJobResponse

    /**
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeEntitiesDetectionJob(block: DescribeEntitiesDetectionJobRequest.Builder.() -> Unit) = describeEntitiesDetectionJob(DescribeEntitiesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.
     */
    suspend fun describeEntityRecognizer(input: DescribeEntityRecognizerRequest): DescribeEntityRecognizerResponse

    /**
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.
     */
    suspend fun describeEntityRecognizer(block: DescribeEntityRecognizerRequest.Builder.() -> Unit) = describeEntityRecognizer(DescribeEntityRecognizerRequest.Builder().apply(block).build())

    /**
     * Gets the status and details of an events detection job.
     */
    suspend fun describeEventsDetectionJob(input: DescribeEventsDetectionJobRequest): DescribeEventsDetectionJobResponse

    /**
     * Gets the status and details of an events detection job.
     */
    suspend fun describeEventsDetectionJob(block: DescribeEventsDetectionJobRequest.Builder.() -> Unit) = describeEventsDetectionJob(DescribeEventsDetectionJobRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeKeyPhrasesDetectionJob(input: DescribeKeyPhrasesDetectionJobRequest): DescribeKeyPhrasesDetectionJobResponse

    /**
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeKeyPhrasesDetectionJob(block: DescribeKeyPhrasesDetectionJobRequest.Builder.() -> Unit) = describeKeyPhrasesDetectionJob(DescribeKeyPhrasesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.
     */
    suspend fun describePiiEntitiesDetectionJob(input: DescribePiiEntitiesDetectionJobRequest): DescribePiiEntitiesDetectionJobResponse

    /**
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.
     */
    suspend fun describePiiEntitiesDetectionJob(block: DescribePiiEntitiesDetectionJobRequest.Builder.() -> Unit) = describePiiEntitiesDetectionJob(DescribePiiEntitiesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the policy.
     */
    suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse

    /**
     * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the policy.
     */
    suspend fun describeResourcePolicy(block: DescribeResourcePolicyRequest.Builder.() -> Unit) = describeResourcePolicy(DescribeResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeSentimentDetectionJob(input: DescribeSentimentDetectionJobRequest): DescribeSentimentDetectionJobResponse

    /**
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeSentimentDetectionJob(block: DescribeSentimentDetectionJobRequest.Builder.() -> Unit) = describeSentimentDetectionJob(DescribeSentimentDetectionJobRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of the job.
     */
    suspend fun describeTargetedSentimentDetectionJob(input: DescribeTargetedSentimentDetectionJobRequest): DescribeTargetedSentimentDetectionJobResponse

    /**
     * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of the job.
     */
    suspend fun describeTargetedSentimentDetectionJob(block: DescribeTargetedSentimentDetectionJobRequest.Builder.() -> Unit) = describeTargetedSentimentDetectionJob(DescribeTargetedSentimentDetectionJobRequest.Builder().apply(block).build())

    /**
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeTopicsDetectionJob(input: DescribeTopicsDetectionJobRequest): DescribeTopicsDetectionJobResponse

    /**
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection job.
     */
    suspend fun describeTopicsDetectionJob(block: DescribeTopicsDetectionJobRequest.Builder.() -> Unit) = describeTopicsDetectionJob(DescribeTopicsDetectionJobRequest.Builder().apply(block).build())

    /**
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    suspend fun detectDominantLanguage(input: DetectDominantLanguageRequest): DetectDominantLanguageResponse

    /**
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    suspend fun detectDominantLanguage(block: DetectDominantLanguageRequest.Builder.() -> Unit) = detectDominantLanguage(DetectDominantLanguageRequest.Builder().apply(block).build())

    /**
     * Inspects text for named entities, and returns information about them. For more information, about named entities, see how-entities.
     */
    suspend fun detectEntities(input: DetectEntitiesRequest): DetectEntitiesResponse

    /**
     * Inspects text for named entities, and returns information about them. For more information, about named entities, see how-entities.
     */
    suspend fun detectEntities(block: DetectEntitiesRequest.Builder.() -> Unit) = detectEntities(DetectEntitiesRequest.Builder().apply(block).build())

    /**
     * Detects the key noun phrases found in the text.
     */
    suspend fun detectKeyPhrases(input: DetectKeyPhrasesRequest): DetectKeyPhrasesResponse

    /**
     * Detects the key noun phrases found in the text.
     */
    suspend fun detectKeyPhrases(block: DetectKeyPhrasesRequest.Builder.() -> Unit) = detectKeyPhrases(DetectKeyPhrasesRequest.Builder().apply(block).build())

    /**
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.
     */
    suspend fun detectPiiEntities(input: DetectPiiEntitiesRequest): DetectPiiEntitiesResponse

    /**
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.
     */
    suspend fun detectPiiEntities(block: DetectPiiEntitiesRequest.Builder.() -> Unit) = detectPiiEntities(DetectPiiEntitiesRequest.Builder().apply(block).build())

    /**
     * Inspects text and returns an inference of the prevailing sentiment (`POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`).
     */
    suspend fun detectSentiment(input: DetectSentimentRequest): DetectSentimentResponse

    /**
     * Inspects text and returns an inference of the prevailing sentiment (`POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`).
     */
    suspend fun detectSentiment(block: DetectSentimentRequest.Builder.() -> Unit) = detectSentiment(DetectSentimentRequest.Builder().apply(block).build())

    /**
     * Inspects text for syntax and the part of speech of words in the document. For more information, how-syntax.
     */
    suspend fun detectSyntax(input: DetectSyntaxRequest): DetectSyntaxResponse

    /**
     * Inspects text for syntax and the part of speech of words in the document. For more information, how-syntax.
     */
    suspend fun detectSyntax(block: DetectSyntaxRequest.Builder.() -> Unit) = detectSyntax(DetectSyntaxRequest.Builder().apply(block).build())

    /**
     * Creates a new custom model that replicates a source custom model that you import. The source model can be in your AWS account or another one.
     *
     * If the source model is in another AWS account, then it must have a resource-based policy that authorizes you to import it.
     *
     * The source model must be in the same AWS region that you're using when you import. You can't import a model that's in a different region.
     */
    suspend fun importModel(input: ImportModelRequest): ImportModelResponse

    /**
     * Creates a new custom model that replicates a source custom model that you import. The source model can be in your AWS account or another one.
     *
     * If the source model is in another AWS account, then it must have a resource-based policy that authorizes you to import it.
     *
     * The source model must be in the same AWS region that you're using when you import. You can't import a model that's in a different region.
     */
    suspend fun importModel(block: ImportModelRequest.Builder.() -> Unit) = importModel(ImportModelRequest.Builder().apply(block).build())

    /**
     * Gets a list of the documentation classification jobs that you have submitted.
     */
    suspend fun listDocumentClassificationJobs(input: ListDocumentClassificationJobsRequest): ListDocumentClassificationJobsResponse

    /**
     * Gets a list of the documentation classification jobs that you have submitted.
     */
    suspend fun listDocumentClassificationJobs(block: ListDocumentClassificationJobsRequest.Builder.() -> Unit) = listDocumentClassificationJobs(ListDocumentClassificationJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of summaries of the document classifiers that you have created
     */
    suspend fun listDocumentClassifierSummaries(input: ListDocumentClassifierSummariesRequest): ListDocumentClassifierSummariesResponse

    /**
     * Gets a list of summaries of the document classifiers that you have created
     */
    suspend fun listDocumentClassifierSummaries(block: ListDocumentClassifierSummariesRequest.Builder.() -> Unit) = listDocumentClassifierSummaries(ListDocumentClassifierSummariesRequest.Builder().apply(block).build())

    /**
     * Gets a list of the document classifiers that you have created.
     */
    suspend fun listDocumentClassifiers(input: ListDocumentClassifiersRequest): ListDocumentClassifiersResponse

    /**
     * Gets a list of the document classifiers that you have created.
     */
    suspend fun listDocumentClassifiers(block: ListDocumentClassifiersRequest.Builder.() -> Unit) = listDocumentClassifiers(ListDocumentClassifiersRequest.Builder().apply(block).build())

    /**
     * Gets a list of the dominant language detection jobs that you have submitted.
     */
    suspend fun listDominantLanguageDetectionJobs(input: ListDominantLanguageDetectionJobsRequest): ListDominantLanguageDetectionJobsResponse

    /**
     * Gets a list of the dominant language detection jobs that you have submitted.
     */
    suspend fun listDominantLanguageDetectionJobs(block: ListDominantLanguageDetectionJobsRequest.Builder.() -> Unit) = listDominantLanguageDetectionJobs(ListDominantLanguageDetectionJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of all existing endpoints that you've created.
     */
    suspend fun listEndpoints(input: ListEndpointsRequest): ListEndpointsResponse

    /**
     * Gets a list of all existing endpoints that you've created.
     */
    suspend fun listEndpoints(block: ListEndpointsRequest.Builder.() -> Unit) = listEndpoints(ListEndpointsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the entity detection jobs that you have submitted.
     */
    suspend fun listEntitiesDetectionJobs(input: ListEntitiesDetectionJobsRequest): ListEntitiesDetectionJobsResponse

    /**
     * Gets a list of the entity detection jobs that you have submitted.
     */
    suspend fun listEntitiesDetectionJobs(block: ListEntitiesDetectionJobsRequest.Builder.() -> Unit) = listEntitiesDetectionJobs(ListEntitiesDetectionJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of summaries for the entity recognizers that you have created.
     */
    suspend fun listEntityRecognizerSummaries(input: ListEntityRecognizerSummariesRequest): ListEntityRecognizerSummariesResponse

    /**
     * Gets a list of summaries for the entity recognizers that you have created.
     */
    suspend fun listEntityRecognizerSummaries(block: ListEntityRecognizerSummariesRequest.Builder.() -> Unit) = listEntityRecognizerSummaries(ListEntityRecognizerSummariesRequest.Builder().apply(block).build())

    /**
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     *
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     */
    suspend fun listEntityRecognizers(input: ListEntityRecognizersRequest): ListEntityRecognizersResponse

    /**
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     *
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     */
    suspend fun listEntityRecognizers(block: ListEntityRecognizersRequest.Builder.() -> Unit) = listEntityRecognizers(ListEntityRecognizersRequest.Builder().apply(block).build())

    /**
     * Gets a list of the events detection jobs that you have submitted.
     */
    suspend fun listEventsDetectionJobs(input: ListEventsDetectionJobsRequest): ListEventsDetectionJobsResponse

    /**
     * Gets a list of the events detection jobs that you have submitted.
     */
    suspend fun listEventsDetectionJobs(block: ListEventsDetectionJobsRequest.Builder.() -> Unit) = listEventsDetectionJobs(ListEventsDetectionJobsRequest.Builder().apply(block).build())

    /**
     * Get a list of key phrase detection jobs that you have submitted.
     */
    suspend fun listKeyPhrasesDetectionJobs(input: ListKeyPhrasesDetectionJobsRequest): ListKeyPhrasesDetectionJobsResponse

    /**
     * Get a list of key phrase detection jobs that you have submitted.
     */
    suspend fun listKeyPhrasesDetectionJobs(block: ListKeyPhrasesDetectionJobsRequest.Builder.() -> Unit) = listKeyPhrasesDetectionJobs(ListKeyPhrasesDetectionJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the PII entity detection jobs that you have submitted.
     */
    suspend fun listPiiEntitiesDetectionJobs(input: ListPiiEntitiesDetectionJobsRequest): ListPiiEntitiesDetectionJobsResponse

    /**
     * Gets a list of the PII entity detection jobs that you have submitted.
     */
    suspend fun listPiiEntitiesDetectionJobs(block: ListPiiEntitiesDetectionJobsRequest.Builder.() -> Unit) = listPiiEntitiesDetectionJobs(ListPiiEntitiesDetectionJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of sentiment detection jobs that you have submitted.
     */
    suspend fun listSentimentDetectionJobs(input: ListSentimentDetectionJobsRequest): ListSentimentDetectionJobsResponse

    /**
     * Gets a list of sentiment detection jobs that you have submitted.
     */
    suspend fun listSentimentDetectionJobs(block: ListSentimentDetectionJobsRequest.Builder.() -> Unit) = listSentimentDetectionJobs(ListSentimentDetectionJobsRequest.Builder().apply(block).build())

    /**
     * Lists all tags associated with a given Amazon Comprehend resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all tags associated with a given Amazon Comprehend resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     */
    suspend fun listTargetedSentimentDetectionJobs(input: ListTargetedSentimentDetectionJobsRequest): ListTargetedSentimentDetectionJobsResponse

    /**
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     */
    suspend fun listTargetedSentimentDetectionJobs(block: ListTargetedSentimentDetectionJobsRequest.Builder.() -> Unit) = listTargetedSentimentDetectionJobs(ListTargetedSentimentDetectionJobsRequest.Builder().apply(block).build())

    /**
     * Gets a list of the topic detection jobs that you have submitted.
     */
    suspend fun listTopicsDetectionJobs(input: ListTopicsDetectionJobsRequest): ListTopicsDetectionJobsResponse

    /**
     * Gets a list of the topic detection jobs that you have submitted.
     */
    suspend fun listTopicsDetectionJobs(block: ListTopicsDetectionJobsRequest.Builder.() -> Unit) = listTopicsDetectionJobs(ListTopicsDetectionJobsRequest.Builder().apply(block).build())

    /**
     * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another AWS account to import the custom model, which replicates it in Amazon Comprehend in their account.
     */
    suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another AWS account to import the custom model, which replicates it in Amazon Comprehend in their account.
     */
    suspend fun putResourcePolicy(block: PutResourcePolicyRequest.Builder.() -> Unit) = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous document classification job. Use the operation to track the progress of the job.
     */
    suspend fun startDocumentClassificationJob(input: StartDocumentClassificationJobRequest): StartDocumentClassificationJobResponse

    /**
     * Starts an asynchronous document classification job. Use the operation to track the progress of the job.
     */
    suspend fun startDocumentClassificationJob(block: StartDocumentClassificationJobRequest.Builder.() -> Unit) = startDocumentClassificationJob(StartDocumentClassificationJobRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track the status of a job.
     */
    suspend fun startDominantLanguageDetectionJob(input: StartDominantLanguageDetectionJobRequest): StartDominantLanguageDetectionJobResponse

    /**
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track the status of a job.
     */
    suspend fun startDominantLanguageDetectionJob(block: StartDominantLanguageDetectionJobRequest.Builder.() -> Unit) = startDominantLanguageDetectionJob(StartDominantLanguageDetectionJobRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status of a job.
     *
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for custom entity recognition, the optional `EntityRecognizerArn` must be used in order to provide access to the recognizer being used to detect the custom entity.
     */
    suspend fun startEntitiesDetectionJob(input: StartEntitiesDetectionJobRequest): StartEntitiesDetectionJobResponse

    /**
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status of a job.
     *
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for custom entity recognition, the optional `EntityRecognizerArn` must be used in order to provide access to the recognizer being used to detect the custom entity.
     */
    suspend fun startEntitiesDetectionJob(block: StartEntitiesDetectionJobRequest.Builder.() -> Unit) = startEntitiesDetectionJob(StartEntitiesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous event detection job for a collection of documents.
     */
    suspend fun startEventsDetectionJob(input: StartEventsDetectionJobRequest): StartEventsDetectionJobResponse

    /**
     * Starts an asynchronous event detection job for a collection of documents.
     */
    suspend fun startEventsDetectionJob(block: StartEventsDetectionJobRequest.Builder.() -> Unit) = startEventsDetectionJob(StartEventsDetectionJobRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the status of a job.
     */
    suspend fun startKeyPhrasesDetectionJob(input: StartKeyPhrasesDetectionJobRequest): StartKeyPhrasesDetectionJobResponse

    /**
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the status of a job.
     */
    suspend fun startKeyPhrasesDetectionJob(block: StartKeyPhrasesDetectionJobRequest.Builder.() -> Unit) = startKeyPhrasesDetectionJob(StartKeyPhrasesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous PII entity detection job for a collection of documents.
     */
    suspend fun startPiiEntitiesDetectionJob(input: StartPiiEntitiesDetectionJobRequest): StartPiiEntitiesDetectionJobResponse

    /**
     * Starts an asynchronous PII entity detection job for a collection of documents.
     */
    suspend fun startPiiEntitiesDetectionJob(block: StartPiiEntitiesDetectionJobRequest.Builder.() -> Unit) = startPiiEntitiesDetectionJob(StartPiiEntitiesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the status of a job.
     */
    suspend fun startSentimentDetectionJob(input: StartSentimentDetectionJobRequest): StartSentimentDetectionJobResponse

    /**
     * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the status of a job.
     */
    suspend fun startSentimentDetectionJob(block: StartSentimentDetectionJobRequest.Builder.() -> Unit) = startSentimentDetectionJob(StartSentimentDetectionJobRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the operation to track the status of a job.
     */
    suspend fun startTargetedSentimentDetectionJob(input: StartTargetedSentimentDetectionJobRequest): StartTargetedSentimentDetectionJobResponse

    /**
     * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the operation to track the status of a job.
     */
    suspend fun startTargetedSentimentDetectionJob(block: StartTargetedSentimentDetectionJobRequest.Builder.() -> Unit) = startTargetedSentimentDetectionJob(StartTargetedSentimentDetectionJobRequest.Builder().apply(block).build())

    /**
     * Starts an asynchronous topic detection job. Use the `DescribeTopicDetectionJob` operation to track the status of a job.
     */
    suspend fun startTopicsDetectionJob(input: StartTopicsDetectionJobRequest): StartTopicsDetectionJobResponse

    /**
     * Starts an asynchronous topic detection job. Use the `DescribeTopicDetectionJob` operation to track the status of a job.
     */
    suspend fun startTopicsDetectionJob(block: StartTopicsDetectionJobRequest.Builder.() -> Unit) = startTopicsDetectionJob(StartTopicsDetectionJobRequest.Builder().apply(block).build())

    /**
     * Stops a dominant language detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopDominantLanguageDetectionJob(input: StopDominantLanguageDetectionJobRequest): StopDominantLanguageDetectionJobResponse

    /**
     * Stops a dominant language detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopDominantLanguageDetectionJob(block: StopDominantLanguageDetectionJobRequest.Builder.() -> Unit) = stopDominantLanguageDetectionJob(StopDominantLanguageDetectionJobRequest.Builder().apply(block).build())

    /**
     * Stops an entities detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopEntitiesDetectionJob(input: StopEntitiesDetectionJobRequest): StopEntitiesDetectionJobResponse

    /**
     * Stops an entities detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopEntitiesDetectionJob(block: StopEntitiesDetectionJobRequest.Builder.() -> Unit) = stopEntitiesDetectionJob(StopEntitiesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Stops an events detection job in progress.
     */
    suspend fun stopEventsDetectionJob(input: StopEventsDetectionJobRequest): StopEventsDetectionJobResponse

    /**
     * Stops an events detection job in progress.
     */
    suspend fun stopEventsDetectionJob(block: StopEventsDetectionJobRequest.Builder.() -> Unit) = stopEventsDetectionJob(StopEventsDetectionJobRequest.Builder().apply(block).build())

    /**
     * Stops a key phrases detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopKeyPhrasesDetectionJob(input: StopKeyPhrasesDetectionJobRequest): StopKeyPhrasesDetectionJobResponse

    /**
     * Stops a key phrases detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopKeyPhrasesDetectionJob(block: StopKeyPhrasesDetectionJobRequest.Builder.() -> Unit) = stopKeyPhrasesDetectionJob(StopKeyPhrasesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Stops a PII entities detection job in progress.
     */
    suspend fun stopPiiEntitiesDetectionJob(input: StopPiiEntitiesDetectionJobRequest): StopPiiEntitiesDetectionJobResponse

    /**
     * Stops a PII entities detection job in progress.
     */
    suspend fun stopPiiEntitiesDetectionJob(block: StopPiiEntitiesDetectionJobRequest.Builder.() -> Unit) = stopPiiEntitiesDetectionJob(StopPiiEntitiesDetectionJobRequest.Builder().apply(block).build())

    /**
     * Stops a sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopSentimentDetectionJob(input: StopSentimentDetectionJobRequest): StopSentimentDetectionJobResponse

    /**
     * Stops a sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopSentimentDetectionJob(block: StopSentimentDetectionJobRequest.Builder.() -> Unit) = stopSentimentDetectionJob(StopSentimentDetectionJobRequest.Builder().apply(block).build())

    /**
     * Stops a targeted sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopTargetedSentimentDetectionJob(input: StopTargetedSentimentDetectionJobRequest): StopTargetedSentimentDetectionJobResponse

    /**
     * Stops a targeted sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    suspend fun stopTargetedSentimentDetectionJob(block: StopTargetedSentimentDetectionJobRequest.Builder.() -> Unit) = stopTargetedSentimentDetectionJob(StopTargetedSentimentDetectionJobRequest.Builder().apply(block).build())

    /**
     * Stops a document classifier training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and put into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun stopTrainingDocumentClassifier(input: StopTrainingDocumentClassifierRequest): StopTrainingDocumentClassifierResponse

    /**
     * Stops a document classifier training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and put into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun stopTrainingDocumentClassifier(block: StopTrainingDocumentClassifierRequest.Builder.() -> Unit) = stopTrainingDocumentClassifier(StopTrainingDocumentClassifierRequest.Builder().apply(block).build())

    /**
     * Stops an entity recognizer training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and putted into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun stopTrainingEntityRecognizer(input: StopTrainingEntityRecognizerRequest): StopTrainingEntityRecognizerResponse

    /**
     * Stops an entity recognizer training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and putted into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    suspend fun stopTrainingEntityRecognizer(block: StopTrainingEntityRecognizerRequest.Builder.() -> Unit) = stopTrainingEntityRecognizer(StopTrainingEntityRecognizerRequest.Builder().apply(block).build())

    /**
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes a specific tag associated with an Amazon Comprehend resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a specific tag associated with an Amazon Comprehend resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates information about the specified endpoint.
     */
    suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse

    /**
     * Updates information about the specified endpoint.
     */
    suspend fun updateEndpoint(block: UpdateEndpointRequest.Builder.() -> Unit) = updateEndpoint(UpdateEndpointRequest.Builder().apply(block).build())
}
