// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.comprehend.model.*
import aws.sdk.kotlin.services.comprehend.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Comprehend"
const val ServiceApiVersion: String = "2017-11-27"
const val SdkVersion: String = "0.15.2-beta"

internal class DefaultComprehendClient(override val config: ComprehendClient.Config) : ComprehendClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Determines the dominant language of the input text for a batch of documents. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    override suspend fun batchDetectDominantLanguage(input: BatchDetectDominantLanguageRequest): BatchDetectDominantLanguageResponse {
        val op = SdkHttpOperation.build<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse> {
            serializer = BatchDetectDominantLanguageOperationSerializer()
            deserializer = BatchDetectDominantLanguageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDetectDominantLanguage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Inspects the text of a batch of documents for named entities and returns information about them. For more information about named entities, see how-entities
     */
    override suspend fun batchDetectEntities(input: BatchDetectEntitiesRequest): BatchDetectEntitiesResponse {
        val op = SdkHttpOperation.build<BatchDetectEntitiesRequest, BatchDetectEntitiesResponse> {
            serializer = BatchDetectEntitiesOperationSerializer()
            deserializer = BatchDetectEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDetectEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detects the key noun phrases found in a batch of documents.
     */
    override suspend fun batchDetectKeyPhrases(input: BatchDetectKeyPhrasesRequest): BatchDetectKeyPhrasesResponse {
        val op = SdkHttpOperation.build<BatchDetectKeyPhrasesRequest, BatchDetectKeyPhrasesResponse> {
            serializer = BatchDetectKeyPhrasesOperationSerializer()
            deserializer = BatchDetectKeyPhrasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDetectKeyPhrases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Inspects a batch of documents and returns an inference of the prevailing sentiment, `POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`, in each one.
     */
    override suspend fun batchDetectSentiment(input: BatchDetectSentimentRequest): BatchDetectSentimentResponse {
        val op = SdkHttpOperation.build<BatchDetectSentimentRequest, BatchDetectSentimentResponse> {
            serializer = BatchDetectSentimentOperationSerializer()
            deserializer = BatchDetectSentimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDetectSentiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Inspects the text of a batch of documents for the syntax and part of speech of the words in the document and returns information about them. For more information, see how-syntax.
     */
    override suspend fun batchDetectSyntax(input: BatchDetectSyntaxRequest): BatchDetectSyntaxResponse {
        val op = SdkHttpOperation.build<BatchDetectSyntaxRequest, BatchDetectSyntaxResponse> {
            serializer = BatchDetectSyntaxOperationSerializer()
            deserializer = BatchDetectSyntaxOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDetectSyntax"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new document classification request to analyze a single document in real-time, using a previously created and trained custom model and an endpoint.
     */
    override suspend fun classifyDocument(input: ClassifyDocumentRequest): ClassifyDocumentResponse {
        val op = SdkHttpOperation.build<ClassifyDocumentRequest, ClassifyDocumentResponse> {
            serializer = ClassifyDocumentOperationSerializer()
            deserializer = ClassifyDocumentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ClassifyDocument"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Analyzes input text for the presence of personally identifiable information (PII) and returns the labels of identified PII entity types such as name, address, bank account number, or phone number.
     */
    override suspend fun containsPiiEntities(input: ContainsPiiEntitiesRequest): ContainsPiiEntitiesResponse {
        val op = SdkHttpOperation.build<ContainsPiiEntitiesRequest, ContainsPiiEntitiesResponse> {
            serializer = ContainsPiiEntitiesOperationSerializer()
            deserializer = ContainsPiiEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ContainsPiiEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new document classifier that you can use to categorize documents. To create a classifier, you provide a set of training documents that labeled with the categories that you want to use. After the classifier is trained you can use it to categorize a set of labeled documents into the categories. For more information, see how-document-classification.
     */
    override suspend fun createDocumentClassifier(input: CreateDocumentClassifierRequest): CreateDocumentClassifierResponse {
        val op = SdkHttpOperation.build<CreateDocumentClassifierRequest, CreateDocumentClassifierResponse> {
            serializer = CreateDocumentClassifierOperationSerializer()
            deserializer = CreateDocumentClassifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDocumentClassifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a model-specific endpoint for synchronous inference for a previously trained custom model
     */
    override suspend fun createEndpoint(input: CreateEndpointRequest): CreateEndpointResponse {
        val op = SdkHttpOperation.build<CreateEndpointRequest, CreateEndpointResponse> {
            serializer = CreateEndpointOperationSerializer()
            deserializer = CreateEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an entity recognizer using submitted files. After your `CreateEntityRecognizer` request is submitted, you can check job status using the API.
     */
    override suspend fun createEntityRecognizer(input: CreateEntityRecognizerRequest): CreateEntityRecognizerResponse {
        val op = SdkHttpOperation.build<CreateEntityRecognizerRequest, CreateEntityRecognizerResponse> {
            serializer = CreateEntityRecognizerOperationSerializer()
            deserializer = CreateEntityRecognizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEntityRecognizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a previously created document classifier
     *
     * Only those classifiers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the classifier into a DELETING state, and it is then removed by a background job. Once removed, the classifier disappears from your account and is no longer available for use.
     */
    override suspend fun deleteDocumentClassifier(input: DeleteDocumentClassifierRequest): DeleteDocumentClassifierResponse {
        val op = SdkHttpOperation.build<DeleteDocumentClassifierRequest, DeleteDocumentClassifierResponse> {
            serializer = DeleteDocumentClassifierOperationSerializer()
            deserializer = DeleteDocumentClassifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDocumentClassifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a model-specific endpoint for a previously-trained custom model. All endpoints must be deleted in order for the model to be deleted.
     */
    override suspend fun deleteEndpoint(input: DeleteEndpointRequest): DeleteEndpointResponse {
        val op = SdkHttpOperation.build<DeleteEndpointRequest, DeleteEndpointResponse> {
            serializer = DeleteEndpointOperationSerializer()
            deserializer = DeleteEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an entity recognizer.
     *
     * Only those recognizers that are in terminated states (IN_ERROR, TRAINED) will be deleted. If an active inference job is using the model, a `ResourceInUseException` will be returned.
     *
     * This is an asynchronous action that puts the recognizer into a DELETING state, and it is then removed by a background job. Once removed, the recognizer disappears from your account and is no longer available for use.
     */
    override suspend fun deleteEntityRecognizer(input: DeleteEntityRecognizerRequest): DeleteEntityRecognizerResponse {
        val op = SdkHttpOperation.build<DeleteEntityRecognizerRequest, DeleteEntityRecognizerResponse> {
            serializer = DeleteEntityRecognizerOperationSerializer()
            deserializer = DeleteEntityRecognizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEntityRecognizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a resource-based policy that is attached to a custom model.
     */
    override suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse {
        val op = SdkHttpOperation.build<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse> {
            serializer = DeleteResourcePolicyOperationSerializer()
            deserializer = DeleteResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a document classification job. Use this operation to get the status of a classification job.
     */
    override suspend fun describeDocumentClassificationJob(input: DescribeDocumentClassificationJobRequest): DescribeDocumentClassificationJobResponse {
        val op = SdkHttpOperation.build<DescribeDocumentClassificationJobRequest, DescribeDocumentClassificationJobResponse> {
            serializer = DescribeDocumentClassificationJobOperationSerializer()
            deserializer = DescribeDocumentClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDocumentClassificationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a document classifier.
     */
    override suspend fun describeDocumentClassifier(input: DescribeDocumentClassifierRequest): DescribeDocumentClassifierResponse {
        val op = SdkHttpOperation.build<DescribeDocumentClassifierRequest, DescribeDocumentClassifierResponse> {
            serializer = DescribeDocumentClassifierOperationSerializer()
            deserializer = DescribeDocumentClassifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDocumentClassifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a dominant language detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeDominantLanguageDetectionJob(input: DescribeDominantLanguageDetectionJobRequest): DescribeDominantLanguageDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeDominantLanguageDetectionJobRequest, DescribeDominantLanguageDetectionJobResponse> {
            serializer = DescribeDominantLanguageDetectionJobOperationSerializer()
            deserializer = DescribeDominantLanguageDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDominantLanguageDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a specific endpoint. Use this operation to get the status of an endpoint.
     */
    override suspend fun describeEndpoint(input: DescribeEndpointRequest): DescribeEndpointResponse {
        val op = SdkHttpOperation.build<DescribeEndpointRequest, DescribeEndpointResponse> {
            serializer = DescribeEndpointOperationSerializer()
            deserializer = DescribeEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with an entities detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeEntitiesDetectionJob(input: DescribeEntitiesDetectionJobRequest): DescribeEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeEntitiesDetectionJobRequest, DescribeEntitiesDetectionJobResponse> {
            serializer = DescribeEntitiesDetectionJobOperationSerializer()
            deserializer = DescribeEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEntitiesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides details about an entity recognizer including status, S3 buckets containing training data, recognizer metadata, metrics, and so on.
     */
    override suspend fun describeEntityRecognizer(input: DescribeEntityRecognizerRequest): DescribeEntityRecognizerResponse {
        val op = SdkHttpOperation.build<DescribeEntityRecognizerRequest, DescribeEntityRecognizerResponse> {
            serializer = DescribeEntityRecognizerOperationSerializer()
            deserializer = DescribeEntityRecognizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEntityRecognizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status and details of an events detection job.
     */
    override suspend fun describeEventsDetectionJob(input: DescribeEventsDetectionJobRequest): DescribeEventsDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeEventsDetectionJobRequest, DescribeEventsDetectionJobResponse> {
            serializer = DescribeEventsDetectionJobOperationSerializer()
            deserializer = DescribeEventsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEventsDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a key phrases detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeKeyPhrasesDetectionJob(input: DescribeKeyPhrasesDetectionJobRequest): DescribeKeyPhrasesDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeKeyPhrasesDetectionJobRequest, DescribeKeyPhrasesDetectionJobResponse> {
            serializer = DescribeKeyPhrasesDetectionJobOperationSerializer()
            deserializer = DescribeKeyPhrasesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeKeyPhrasesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a PII entities detection job. For example, you can use this operation to get the job status.
     */
    override suspend fun describePiiEntitiesDetectionJob(input: DescribePiiEntitiesDetectionJobRequest): DescribePiiEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribePiiEntitiesDetectionJobRequest, DescribePiiEntitiesDetectionJobResponse> {
            serializer = DescribePiiEntitiesDetectionJobOperationSerializer()
            deserializer = DescribePiiEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePiiEntitiesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of a resource-based policy that is attached to a custom model, including the JSON body of the policy.
     */
    override suspend fun describeResourcePolicy(input: DescribeResourcePolicyRequest): DescribeResourcePolicyResponse {
        val op = SdkHttpOperation.build<DescribeResourcePolicyRequest, DescribeResourcePolicyResponse> {
            serializer = DescribeResourcePolicyOperationSerializer()
            deserializer = DescribeResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a sentiment detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeSentimentDetectionJob(input: DescribeSentimentDetectionJobRequest): DescribeSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeSentimentDetectionJobRequest, DescribeSentimentDetectionJobResponse> {
            serializer = DescribeSentimentDetectionJobOperationSerializer()
            deserializer = DescribeSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSentimentDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a targeted sentiment detection job. Use this operation to get the status of the job.
     */
    override suspend fun describeTargetedSentimentDetectionJob(input: DescribeTargetedSentimentDetectionJobRequest): DescribeTargetedSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeTargetedSentimentDetectionJobRequest, DescribeTargetedSentimentDetectionJobResponse> {
            serializer = DescribeTargetedSentimentDetectionJobOperationSerializer()
            deserializer = DescribeTargetedSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTargetedSentimentDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the properties associated with a topic detection job. Use this operation to get the status of a detection job.
     */
    override suspend fun describeTopicsDetectionJob(input: DescribeTopicsDetectionJobRequest): DescribeTopicsDetectionJobResponse {
        val op = SdkHttpOperation.build<DescribeTopicsDetectionJobRequest, DescribeTopicsDetectionJobResponse> {
            serializer = DescribeTopicsDetectionJobOperationSerializer()
            deserializer = DescribeTopicsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTopicsDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Determines the dominant language of the input text. For a list of languages that Amazon Comprehend can detect, see [Amazon Comprehend Supported Languages](https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
     */
    override suspend fun detectDominantLanguage(input: DetectDominantLanguageRequest): DetectDominantLanguageResponse {
        val op = SdkHttpOperation.build<DetectDominantLanguageRequest, DetectDominantLanguageResponse> {
            serializer = DetectDominantLanguageOperationSerializer()
            deserializer = DetectDominantLanguageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectDominantLanguage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Inspects text for named entities, and returns information about them. For more information, about named entities, see how-entities.
     */
    override suspend fun detectEntities(input: DetectEntitiesRequest): DetectEntitiesResponse {
        val op = SdkHttpOperation.build<DetectEntitiesRequest, DetectEntitiesResponse> {
            serializer = DetectEntitiesOperationSerializer()
            deserializer = DetectEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detects the key noun phrases found in the text.
     */
    override suspend fun detectKeyPhrases(input: DetectKeyPhrasesRequest): DetectKeyPhrasesResponse {
        val op = SdkHttpOperation.build<DetectKeyPhrasesRequest, DetectKeyPhrasesResponse> {
            serializer = DetectKeyPhrasesOperationSerializer()
            deserializer = DetectKeyPhrasesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectKeyPhrases"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Inspects the input text for entities that contain personally identifiable information (PII) and returns information about them.
     */
    override suspend fun detectPiiEntities(input: DetectPiiEntitiesRequest): DetectPiiEntitiesResponse {
        val op = SdkHttpOperation.build<DetectPiiEntitiesRequest, DetectPiiEntitiesResponse> {
            serializer = DetectPiiEntitiesOperationSerializer()
            deserializer = DetectPiiEntitiesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectPiiEntities"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Inspects text and returns an inference of the prevailing sentiment (`POSITIVE`, `NEUTRAL`, `MIXED`, or `NEGATIVE`).
     */
    override suspend fun detectSentiment(input: DetectSentimentRequest): DetectSentimentResponse {
        val op = SdkHttpOperation.build<DetectSentimentRequest, DetectSentimentResponse> {
            serializer = DetectSentimentOperationSerializer()
            deserializer = DetectSentimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectSentiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Inspects text for syntax and the part of speech of words in the document. For more information, how-syntax.
     */
    override suspend fun detectSyntax(input: DetectSyntaxRequest): DetectSyntaxResponse {
        val op = SdkHttpOperation.build<DetectSyntaxRequest, DetectSyntaxResponse> {
            serializer = DetectSyntaxOperationSerializer()
            deserializer = DetectSyntaxOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetectSyntax"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new custom model that replicates a source custom model that you import. The source model can be in your AWS account or another one.
     *
     * If the source model is in another AWS account, then it must have a resource-based policy that authorizes you to import it.
     *
     * The source model must be in the same AWS region that you're using when you import. You can't import a model that's in a different region.
     */
    override suspend fun importModel(input: ImportModelRequest): ImportModelResponse {
        val op = SdkHttpOperation.build<ImportModelRequest, ImportModelResponse> {
            serializer = ImportModelOperationSerializer()
            deserializer = ImportModelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportModel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the documentation classification jobs that you have submitted.
     */
    override suspend fun listDocumentClassificationJobs(input: ListDocumentClassificationJobsRequest): ListDocumentClassificationJobsResponse {
        val op = SdkHttpOperation.build<ListDocumentClassificationJobsRequest, ListDocumentClassificationJobsResponse> {
            serializer = ListDocumentClassificationJobsOperationSerializer()
            deserializer = ListDocumentClassificationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDocumentClassificationJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of summaries of the document classifiers that you have created
     */
    override suspend fun listDocumentClassifierSummaries(input: ListDocumentClassifierSummariesRequest): ListDocumentClassifierSummariesResponse {
        val op = SdkHttpOperation.build<ListDocumentClassifierSummariesRequest, ListDocumentClassifierSummariesResponse> {
            serializer = ListDocumentClassifierSummariesOperationSerializer()
            deserializer = ListDocumentClassifierSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDocumentClassifierSummaries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the document classifiers that you have created.
     */
    override suspend fun listDocumentClassifiers(input: ListDocumentClassifiersRequest): ListDocumentClassifiersResponse {
        val op = SdkHttpOperation.build<ListDocumentClassifiersRequest, ListDocumentClassifiersResponse> {
            serializer = ListDocumentClassifiersOperationSerializer()
            deserializer = ListDocumentClassifiersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDocumentClassifiers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the dominant language detection jobs that you have submitted.
     */
    override suspend fun listDominantLanguageDetectionJobs(input: ListDominantLanguageDetectionJobsRequest): ListDominantLanguageDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListDominantLanguageDetectionJobsRequest, ListDominantLanguageDetectionJobsResponse> {
            serializer = ListDominantLanguageDetectionJobsOperationSerializer()
            deserializer = ListDominantLanguageDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDominantLanguageDetectionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of all existing endpoints that you've created.
     */
    override suspend fun listEndpoints(input: ListEndpointsRequest): ListEndpointsResponse {
        val op = SdkHttpOperation.build<ListEndpointsRequest, ListEndpointsResponse> {
            serializer = ListEndpointsOperationSerializer()
            deserializer = ListEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEndpoints"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the entity detection jobs that you have submitted.
     */
    override suspend fun listEntitiesDetectionJobs(input: ListEntitiesDetectionJobsRequest): ListEntitiesDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListEntitiesDetectionJobsRequest, ListEntitiesDetectionJobsResponse> {
            serializer = ListEntitiesDetectionJobsOperationSerializer()
            deserializer = ListEntitiesDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEntitiesDetectionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of summaries for the entity recognizers that you have created.
     */
    override suspend fun listEntityRecognizerSummaries(input: ListEntityRecognizerSummariesRequest): ListEntityRecognizerSummariesResponse {
        val op = SdkHttpOperation.build<ListEntityRecognizerSummariesRequest, ListEntityRecognizerSummariesResponse> {
            serializer = ListEntityRecognizerSummariesOperationSerializer()
            deserializer = ListEntityRecognizerSummariesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEntityRecognizerSummaries"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the properties of all entity recognizers that you created, including recognizers currently in training. Allows you to filter the list of recognizers based on criteria such as status and submission time. This call returns up to 500 entity recognizers in the list, with a default number of 100 recognizers in the list.
     *
     * The results of this list are not in any particular order. Please get the list and sort locally if needed.
     */
    override suspend fun listEntityRecognizers(input: ListEntityRecognizersRequest): ListEntityRecognizersResponse {
        val op = SdkHttpOperation.build<ListEntityRecognizersRequest, ListEntityRecognizersResponse> {
            serializer = ListEntityRecognizersOperationSerializer()
            deserializer = ListEntityRecognizersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEntityRecognizers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the events detection jobs that you have submitted.
     */
    override suspend fun listEventsDetectionJobs(input: ListEventsDetectionJobsRequest): ListEventsDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListEventsDetectionJobsRequest, ListEventsDetectionJobsResponse> {
            serializer = ListEventsDetectionJobsOperationSerializer()
            deserializer = ListEventsDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEventsDetectionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Get a list of key phrase detection jobs that you have submitted.
     */
    override suspend fun listKeyPhrasesDetectionJobs(input: ListKeyPhrasesDetectionJobsRequest): ListKeyPhrasesDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListKeyPhrasesDetectionJobsRequest, ListKeyPhrasesDetectionJobsResponse> {
            serializer = ListKeyPhrasesDetectionJobsOperationSerializer()
            deserializer = ListKeyPhrasesDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListKeyPhrasesDetectionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the PII entity detection jobs that you have submitted.
     */
    override suspend fun listPiiEntitiesDetectionJobs(input: ListPiiEntitiesDetectionJobsRequest): ListPiiEntitiesDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListPiiEntitiesDetectionJobsRequest, ListPiiEntitiesDetectionJobsResponse> {
            serializer = ListPiiEntitiesDetectionJobsOperationSerializer()
            deserializer = ListPiiEntitiesDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPiiEntitiesDetectionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of sentiment detection jobs that you have submitted.
     */
    override suspend fun listSentimentDetectionJobs(input: ListSentimentDetectionJobsRequest): ListSentimentDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListSentimentDetectionJobsRequest, ListSentimentDetectionJobsResponse> {
            serializer = ListSentimentDetectionJobsOperationSerializer()
            deserializer = ListSentimentDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSentimentDetectionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags associated with a given Amazon Comprehend resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of targeted sentiment detection jobs that you have submitted.
     */
    override suspend fun listTargetedSentimentDetectionJobs(input: ListTargetedSentimentDetectionJobsRequest): ListTargetedSentimentDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListTargetedSentimentDetectionJobsRequest, ListTargetedSentimentDetectionJobsResponse> {
            serializer = ListTargetedSentimentDetectionJobsOperationSerializer()
            deserializer = ListTargetedSentimentDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTargetedSentimentDetectionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets a list of the topic detection jobs that you have submitted.
     */
    override suspend fun listTopicsDetectionJobs(input: ListTopicsDetectionJobsRequest): ListTopicsDetectionJobsResponse {
        val op = SdkHttpOperation.build<ListTopicsDetectionJobsRequest, ListTopicsDetectionJobsResponse> {
            serializer = ListTopicsDetectionJobsOperationSerializer()
            deserializer = ListTopicsDetectionJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTopicsDetectionJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a resource-based policy to a custom model. You can use this policy to authorize an entity in another AWS account to import the custom model, which replicates it in Amazon Comprehend in their account.
     */
    override suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse {
        val op = SdkHttpOperation.build<PutResourcePolicyRequest, PutResourcePolicyResponse> {
            serializer = PutResourcePolicyOperationSerializer()
            deserializer = PutResourcePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutResourcePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous document classification job. Use the operation to track the progress of the job.
     */
    override suspend fun startDocumentClassificationJob(input: StartDocumentClassificationJobRequest): StartDocumentClassificationJobResponse {
        val op = SdkHttpOperation.build<StartDocumentClassificationJobRequest, StartDocumentClassificationJobResponse> {
            serializer = StartDocumentClassificationJobOperationSerializer()
            deserializer = StartDocumentClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDocumentClassificationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous dominant language detection job for a collection of documents. Use the operation to track the status of a job.
     */
    override suspend fun startDominantLanguageDetectionJob(input: StartDominantLanguageDetectionJobRequest): StartDominantLanguageDetectionJobResponse {
        val op = SdkHttpOperation.build<StartDominantLanguageDetectionJobRequest, StartDominantLanguageDetectionJobResponse> {
            serializer = StartDominantLanguageDetectionJobOperationSerializer()
            deserializer = StartDominantLanguageDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDominantLanguageDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous entity detection job for a collection of documents. Use the operation to track the status of a job.
     *
     * This API can be used for either standard entity detection or custom entity recognition. In order to be used for custom entity recognition, the optional `EntityRecognizerArn` must be used in order to provide access to the recognizer being used to detect the custom entity.
     */
    override suspend fun startEntitiesDetectionJob(input: StartEntitiesDetectionJobRequest): StartEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<StartEntitiesDetectionJobRequest, StartEntitiesDetectionJobResponse> {
            serializer = StartEntitiesDetectionJobOperationSerializer()
            deserializer = StartEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartEntitiesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous event detection job for a collection of documents.
     */
    override suspend fun startEventsDetectionJob(input: StartEventsDetectionJobRequest): StartEventsDetectionJobResponse {
        val op = SdkHttpOperation.build<StartEventsDetectionJobRequest, StartEventsDetectionJobResponse> {
            serializer = StartEventsDetectionJobOperationSerializer()
            deserializer = StartEventsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartEventsDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous key phrase detection job for a collection of documents. Use the operation to track the status of a job.
     */
    override suspend fun startKeyPhrasesDetectionJob(input: StartKeyPhrasesDetectionJobRequest): StartKeyPhrasesDetectionJobResponse {
        val op = SdkHttpOperation.build<StartKeyPhrasesDetectionJobRequest, StartKeyPhrasesDetectionJobResponse> {
            serializer = StartKeyPhrasesDetectionJobOperationSerializer()
            deserializer = StartKeyPhrasesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartKeyPhrasesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous PII entity detection job for a collection of documents.
     */
    override suspend fun startPiiEntitiesDetectionJob(input: StartPiiEntitiesDetectionJobRequest): StartPiiEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<StartPiiEntitiesDetectionJobRequest, StartPiiEntitiesDetectionJobResponse> {
            serializer = StartPiiEntitiesDetectionJobOperationSerializer()
            deserializer = StartPiiEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartPiiEntitiesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous sentiment detection job for a collection of documents. Use the operation to track the status of a job.
     */
    override suspend fun startSentimentDetectionJob(input: StartSentimentDetectionJobRequest): StartSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<StartSentimentDetectionJobRequest, StartSentimentDetectionJobResponse> {
            serializer = StartSentimentDetectionJobOperationSerializer()
            deserializer = StartSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartSentimentDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous targeted sentiment detection job for a collection of documents. Use the operation to track the status of a job.
     */
    override suspend fun startTargetedSentimentDetectionJob(input: StartTargetedSentimentDetectionJobRequest): StartTargetedSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<StartTargetedSentimentDetectionJobRequest, StartTargetedSentimentDetectionJobResponse> {
            serializer = StartTargetedSentimentDetectionJobOperationSerializer()
            deserializer = StartTargetedSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartTargetedSentimentDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an asynchronous topic detection job. Use the `DescribeTopicDetectionJob` operation to track the status of a job.
     */
    override suspend fun startTopicsDetectionJob(input: StartTopicsDetectionJobRequest): StartTopicsDetectionJobResponse {
        val op = SdkHttpOperation.build<StartTopicsDetectionJobRequest, StartTopicsDetectionJobResponse> {
            serializer = StartTopicsDetectionJobOperationSerializer()
            deserializer = StartTopicsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartTopicsDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a dominant language detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopDominantLanguageDetectionJob(input: StopDominantLanguageDetectionJobRequest): StopDominantLanguageDetectionJobResponse {
        val op = SdkHttpOperation.build<StopDominantLanguageDetectionJobRequest, StopDominantLanguageDetectionJobResponse> {
            serializer = StopDominantLanguageDetectionJobOperationSerializer()
            deserializer = StopDominantLanguageDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopDominantLanguageDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops an entities detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopEntitiesDetectionJob(input: StopEntitiesDetectionJobRequest): StopEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<StopEntitiesDetectionJobRequest, StopEntitiesDetectionJobResponse> {
            serializer = StopEntitiesDetectionJobOperationSerializer()
            deserializer = StopEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopEntitiesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops an events detection job in progress.
     */
    override suspend fun stopEventsDetectionJob(input: StopEventsDetectionJobRequest): StopEventsDetectionJobResponse {
        val op = SdkHttpOperation.build<StopEventsDetectionJobRequest, StopEventsDetectionJobResponse> {
            serializer = StopEventsDetectionJobOperationSerializer()
            deserializer = StopEventsDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopEventsDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a key phrases detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopKeyPhrasesDetectionJob(input: StopKeyPhrasesDetectionJobRequest): StopKeyPhrasesDetectionJobResponse {
        val op = SdkHttpOperation.build<StopKeyPhrasesDetectionJobRequest, StopKeyPhrasesDetectionJobResponse> {
            serializer = StopKeyPhrasesDetectionJobOperationSerializer()
            deserializer = StopKeyPhrasesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopKeyPhrasesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a PII entities detection job in progress.
     */
    override suspend fun stopPiiEntitiesDetectionJob(input: StopPiiEntitiesDetectionJobRequest): StopPiiEntitiesDetectionJobResponse {
        val op = SdkHttpOperation.build<StopPiiEntitiesDetectionJobRequest, StopPiiEntitiesDetectionJobResponse> {
            serializer = StopPiiEntitiesDetectionJobOperationSerializer()
            deserializer = StopPiiEntitiesDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopPiiEntitiesDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopSentimentDetectionJob(input: StopSentimentDetectionJobRequest): StopSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<StopSentimentDetectionJobRequest, StopSentimentDetectionJobResponse> {
            serializer = StopSentimentDetectionJobOperationSerializer()
            deserializer = StopSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopSentimentDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a targeted sentiment detection job in progress.
     *
     * If the job state is `IN_PROGRESS` the job is marked for termination and put into the `STOP_REQUESTED` state. If the job completes before it can be stopped, it is put into the `COMPLETED` state; otherwise the job is be stopped and put into the `STOPPED` state.
     *
     * If the job is in the `COMPLETED` or `FAILED` state when you call the `StopDominantLanguageDetectionJob` operation, the operation returns a 400 Internal Request Exception.
     *
     * When a job is stopped, any documents already processed are written to the output location.
     */
    override suspend fun stopTargetedSentimentDetectionJob(input: StopTargetedSentimentDetectionJobRequest): StopTargetedSentimentDetectionJobResponse {
        val op = SdkHttpOperation.build<StopTargetedSentimentDetectionJobRequest, StopTargetedSentimentDetectionJobResponse> {
            serializer = StopTargetedSentimentDetectionJobOperationSerializer()
            deserializer = StopTargetedSentimentDetectionJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopTargetedSentimentDetectionJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a document classifier training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and put into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    override suspend fun stopTrainingDocumentClassifier(input: StopTrainingDocumentClassifierRequest): StopTrainingDocumentClassifierResponse {
        val op = SdkHttpOperation.build<StopTrainingDocumentClassifierRequest, StopTrainingDocumentClassifierResponse> {
            serializer = StopTrainingDocumentClassifierOperationSerializer()
            deserializer = StopTrainingDocumentClassifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopTrainingDocumentClassifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops an entity recognizer training job while in progress.
     *
     * If the training job state is `TRAINING`, the job is marked for termination and put into the `STOP_REQUESTED` state. If the training job completes before it can be stopped, it is put into the `TRAINED`; otherwise the training job is stopped and putted into the `STOPPED` state and the service sends back an HTTP 200 response with an empty HTTP body.
     */
    override suspend fun stopTrainingEntityRecognizer(input: StopTrainingEntityRecognizerRequest): StopTrainingEntityRecognizerResponse {
        val op = SdkHttpOperation.build<StopTrainingEntityRecognizerRequest, StopTrainingEntityRecognizerResponse> {
            serializer = StopTrainingEntityRecognizerOperationSerializer()
            deserializer = StopTrainingEntityRecognizerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopTrainingEntityRecognizer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a specific tag with an Amazon Comprehend resource. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes a specific tag associated with an Amazon Comprehend resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates information about the specified endpoint.
     */
    override suspend fun updateEndpoint(input: UpdateEndpointRequest): UpdateEndpointResponse {
        val op = SdkHttpOperation.build<UpdateEndpointRequest, UpdateEndpointResponse> {
            serializer = UpdateEndpointOperationSerializer()
            deserializer = UpdateEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("Comprehend_20171127", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "comprehend"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "comprehend")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
