// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



class CreateEndpointRequest private constructor(builder: Builder) {
    /**
     * An idempotency token provided by the customer. If this token matches a previous endpoint creation request, Amazon Comprehend will not return a `ResourceInUseException`.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).
     */
    val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.
     */
    val desiredInferenceUnits: kotlin.Int? = builder.desiredInferenceUnits
    /**
     * This is the descriptive suffix that becomes part of the `EndpointArn` used for all subsequent requests to this resource.
     */
    val endpointName: kotlin.String? = builder.endpointName
    /**
     * The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.
     */
    val modelArn: kotlin.String? = builder.modelArn
    /**
     * Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.CreateEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEndpointRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("desiredInferenceUnits=$desiredInferenceUnits,")
        append("endpointName=$endpointName,")
        append("modelArn=$modelArn,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (desiredInferenceUnits ?: 0)
        result = 31 * result + (endpointName?.hashCode() ?: 0)
        result = 31 * result + (modelArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateEndpointRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (desiredInferenceUnits != other.desiredInferenceUnits) return false
        if (endpointName != other.endpointName) return false
        if (modelArn != other.modelArn) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.CreateEndpointRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * An idempotency token provided by the customer. If this token matches a previous endpoint creation request, Amazon Comprehend will not return a `ResourceInUseException`.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).
         */
        var dataAccessRoleArn: kotlin.String? = null
        /**
         * The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.
         */
        var desiredInferenceUnits: kotlin.Int? = null
        /**
         * This is the descriptive suffix that becomes part of the `EndpointArn` used for all subsequent requests to this resource.
         */
        var endpointName: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the model to which the endpoint will be attached.
         */
        var modelArn: kotlin.String? = null
        /**
         * Tags associated with the endpoint being created. A tag is a key-value pair that adds metadata to the endpoint. For example, a tag with "Sales" as the key might be added to an endpoint to indicate its use by the sales department.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.CreateEndpointRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.desiredInferenceUnits = x.desiredInferenceUnits
            this.endpointName = x.endpointName
            this.modelArn = x.modelArn
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.CreateEndpointRequest = CreateEndpointRequest(this)
    }
}
