// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a document classifier.
 */
class DocumentClassifierProperties private constructor(builder: Builder) {
    /**
     * Information about the document classifier, including the number of documents used for training the classifier, the number of documents used for test the classifier, and an accuracy rating.
     */
    val classifierMetadata: aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata? = builder.classifierMetadata
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.
     */
    val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The Amazon Resource Name (ARN) that identifies the document classifier.
     */
    val documentClassifierArn: kotlin.String? = builder.documentClassifierArn
    /**
     * The time that training the document classifier completed.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The input data configuration that you supplied when you created the document classifier for training.
     */
    val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig? = builder.inputDataConfig
    /**
     * The language code for the language of the documents that the classifier was trained on.
     */
    val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * Additional information about the status of the classifier.
     */
    val message: kotlin.String? = builder.message
    /**
     * Indicates the mode in which the specific classifier was trained. This also indicates the format of input documents and the format of the confusion matrix. Each classifier can only be trained in one mode and this cannot be changed once the classifier is trained.
     */
    val mode: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierMode? = builder.mode
    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    val modelKmsKeyId: kotlin.String? = builder.modelKmsKeyId
    /**
     * Provides output results configuration parameters for custom classifier jobs.
     */
    val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig? = builder.outputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the source model. This model was imported from a different AWS account to create the document classifier model in your AWS account.
     */
    val sourceModelArn: kotlin.String? = builder.sourceModelArn
    /**
     * The status of the document classifier. If the status is `TRAINED` the classifier is ready to use. If the status is `FAILED` you can see additional information about why the classifier wasn't trained in the `Message` field.
     */
    val status: aws.sdk.kotlin.services.comprehend.model.ModelStatus? = builder.status
    /**
     * The time that the document classifier was submitted for training.
     */
    val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * The time that training of the document classifier was completed. Indicates the time when the training completes on documentation classifiers. You are billed for the time interval between this time and the value of TrainingStartTime.
     */
    val trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingEndTime
    /**
     * Indicates the time when the training starts on documentation classifiers. You are billed for the time interval between this time and the value of TrainingEndTime.
     */
    val trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.trainingStartTime
    /**
     * The version name that you assigned to the document classifier.
     */
    val versionName: kotlin.String? = builder.versionName
    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
     */
    val vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentClassifierProperties(")
        append("classifierMetadata=*** Sensitive Data Redacted ***,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("documentClassifierArn=$documentClassifierArn,")
        append("endTime=$endTime,")
        append("inputDataConfig=$inputDataConfig,")
        append("languageCode=$languageCode,")
        append("message=$message,")
        append("mode=$mode,")
        append("modelKmsKeyId=$modelKmsKeyId,")
        append("outputDataConfig=$outputDataConfig,")
        append("sourceModelArn=$sourceModelArn,")
        append("status=$status,")
        append("submitTime=$submitTime,")
        append("trainingEndTime=$trainingEndTime,")
        append("trainingStartTime=$trainingStartTime,")
        append("versionName=$versionName,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = classifierMetadata?.hashCode() ?: 0
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (documentClassifierArn?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (modelKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceModelArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (trainingEndTime?.hashCode() ?: 0)
        result = 31 * result + (trainingStartTime?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentClassifierProperties

        if (classifierMetadata != other.classifierMetadata) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (documentClassifierArn != other.documentClassifierArn) return false
        if (endTime != other.endTime) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (languageCode != other.languageCode) return false
        if (message != other.message) return false
        if (mode != other.mode) return false
        if (modelKmsKeyId != other.modelKmsKeyId) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (sourceModelArn != other.sourceModelArn) return false
        if (status != other.status) return false
        if (submitTime != other.submitTime) return false
        if (trainingEndTime != other.trainingEndTime) return false
        if (trainingStartTime != other.trainingStartTime) return false
        if (versionName != other.versionName) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierProperties = Builder(this).apply(block).build()

    class Builder {
        /**
         * Information about the document classifier, including the number of documents used for training the classifier, the number of documents used for test the classifier, and an accuracy rating.
         */
        var classifierMetadata: aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your input data.
         */
        var dataAccessRoleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the document classifier.
         */
        var documentClassifierArn: kotlin.String? = null
        /**
         * The time that training the document classifier completed.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The input data configuration that you supplied when you created the document classifier for training.
         */
        var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig? = null
        /**
         * The language code for the language of the documents that the classifier was trained on.
         */
        var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * Additional information about the status of the classifier.
         */
        var message: kotlin.String? = null
        /**
         * Indicates the mode in which the specific classifier was trained. This also indicates the format of input documents and the format of the confusion matrix. Each classifier can only be trained in one mode and this cannot be changed once the classifier is trained.
         */
        var mode: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierMode? = null
        /**
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        var modelKmsKeyId: kotlin.String? = null
        /**
         * Provides output results configuration parameters for custom classifier jobs.
         */
        var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the source model. This model was imported from a different AWS account to create the document classifier model in your AWS account.
         */
        var sourceModelArn: kotlin.String? = null
        /**
         * The status of the document classifier. If the status is `TRAINED` the classifier is ready to use. If the status is `FAILED` you can see additional information about why the classifier wasn't trained in the `Message` field.
         */
        var status: aws.sdk.kotlin.services.comprehend.model.ModelStatus? = null
        /**
         * The time that the document classifier was submitted for training.
         */
        var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that training of the document classifier was completed. Indicates the time when the training completes on documentation classifiers. You are billed for the time interval between this time and the value of TrainingStartTime.
         */
        var trainingEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the time when the training starts on documentation classifiers. You are billed for the time interval between this time and the value of TrainingEndTime.
         */
        var trainingStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version name that you assigned to the document classifier.
         */
        var versionName: kotlin.String? = null
        /**
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        var volumeKmsKeyId: kotlin.String? = null
        /**
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
         */
        var vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierProperties) : this() {
            this.classifierMetadata = x.classifierMetadata
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.documentClassifierArn = x.documentClassifierArn
            this.endTime = x.endTime
            this.inputDataConfig = x.inputDataConfig
            this.languageCode = x.languageCode
            this.message = x.message
            this.mode = x.mode
            this.modelKmsKeyId = x.modelKmsKeyId
            this.outputDataConfig = x.outputDataConfig
            this.sourceModelArn = x.sourceModelArn
            this.status = x.status
            this.submitTime = x.submitTime
            this.trainingEndTime = x.trainingEndTime
            this.trainingStartTime = x.trainingStartTime
            this.versionName = x.versionName
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.DocumentClassifierProperties = DocumentClassifierProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata] inside the given [block]
         */
        fun classifierMetadata(block: aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata.Builder.() -> kotlin.Unit) {
            this.classifierMetadata = aws.sdk.kotlin.services.comprehend.model.ClassifierMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig] inside the given [block]
         */
        fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.DocumentClassifierInputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig] inside the given [block]
         */
        fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.DocumentClassifierOutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.VpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.comprehend.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.comprehend.model.VpcConfig.invoke(block)
        }
    }
}
