// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies information about the specified endpoint.
 */
class EndpointProperties private constructor(builder: Builder) {
    /**
     * The creation date and time of the endpoint.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The number of inference units currently used by the model using this endpoint.
     */
    val currentInferenceUnits: kotlin.Int? = builder.currentInferenceUnits
    /**
     * The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).
     */
    val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * Data access role ARN to use in case the new model is encrypted with a customer KMS key.
     */
    val desiredDataAccessRoleArn: kotlin.String? = builder.desiredDataAccessRoleArn
    /**
     * The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.
     */
    val desiredInferenceUnits: kotlin.Int? = builder.desiredInferenceUnits
    /**
     * ARN of the new model to use for updating an existing endpoint. This ARN is going to be different from the model ARN when the update is in progress
     */
    val desiredModelArn: kotlin.String? = builder.desiredModelArn
    /**
     * The Amazon Resource Number (ARN) of the endpoint.
     */
    val endpointArn: kotlin.String? = builder.endpointArn
    /**
     * The date and time that the endpoint was last modified.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Specifies a reason for failure in cases of `Failed` status.
     */
    val message: kotlin.String? = builder.message
    /**
     * The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
     */
    val modelArn: kotlin.String? = builder.modelArn
    /**
     * Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so customers will need to wait for the endpoint to be `Ready` status before making inference requests.
     */
    val status: aws.sdk.kotlin.services.comprehend.model.EndpointStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.EndpointProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointProperties(")
        append("creationTime=$creationTime,")
        append("currentInferenceUnits=$currentInferenceUnits,")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("desiredDataAccessRoleArn=$desiredDataAccessRoleArn,")
        append("desiredInferenceUnits=$desiredInferenceUnits,")
        append("desiredModelArn=$desiredModelArn,")
        append("endpointArn=$endpointArn,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("message=$message,")
        append("modelArn=$modelArn,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (currentInferenceUnits ?: 0)
        result = 31 * result + (dataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (desiredDataAccessRoleArn?.hashCode() ?: 0)
        result = 31 * result + (desiredInferenceUnits ?: 0)
        result = 31 * result + (desiredModelArn?.hashCode() ?: 0)
        result = 31 * result + (endpointArn?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (modelArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointProperties

        if (creationTime != other.creationTime) return false
        if (currentInferenceUnits != other.currentInferenceUnits) return false
        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (desiredDataAccessRoleArn != other.desiredDataAccessRoleArn) return false
        if (desiredInferenceUnits != other.desiredInferenceUnits) return false
        if (desiredModelArn != other.desiredModelArn) return false
        if (endpointArn != other.endpointArn) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (message != other.message) return false
        if (modelArn != other.modelArn) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.EndpointProperties = Builder(this).apply(block).build()

    class Builder {
        /**
         * The creation date and time of the endpoint.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of inference units currently used by the model using this endpoint.
         */
        var currentInferenceUnits: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS identity and Access Management (IAM) role that grants Amazon Comprehend read access to trained custom models encrypted with a customer managed key (ModelKmsKeyId).
         */
        var dataAccessRoleArn: kotlin.String? = null
        /**
         * Data access role ARN to use in case the new model is encrypted with a customer KMS key.
         */
        var desiredDataAccessRoleArn: kotlin.String? = null
        /**
         * The desired number of inference units to be used by the model using this endpoint. Each inference unit represents of a throughput of 100 characters per second.
         */
        var desiredInferenceUnits: kotlin.Int? = null
        /**
         * ARN of the new model to use for updating an existing endpoint. This ARN is going to be different from the model ARN when the update is in progress
         */
        var desiredModelArn: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the endpoint.
         */
        var endpointArn: kotlin.String? = null
        /**
         * The date and time that the endpoint was last modified.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies a reason for failure in cases of `Failed` status.
         */
        var message: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
         */
        var modelArn: kotlin.String? = null
        /**
         * Specifies the status of the endpoint. Because the endpoint updates and creation are asynchronous, so customers will need to wait for the endpoint to be `Ready` status before making inference requests.
         */
        var status: aws.sdk.kotlin.services.comprehend.model.EndpointStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.EndpointProperties) : this() {
            this.creationTime = x.creationTime
            this.currentInferenceUnits = x.currentInferenceUnits
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.desiredDataAccessRoleArn = x.desiredDataAccessRoleArn
            this.desiredInferenceUnits = x.desiredInferenceUnits
            this.desiredModelArn = x.desiredModelArn
            this.endpointArn = x.endpointArn
            this.lastModifiedTime = x.lastModifiedTime
            this.message = x.message
            this.modelArn = x.modelArn
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.EndpointProperties = EndpointProperties(this)
    }
}
