// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about an entities detection job.
 */
class EntitiesDetectionJobProperties private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input data.
     */
    val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The time that the entities detection job completed
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Resource Name (ARN) that identifies the entity recognizer.
     */
    val entityRecognizerArn: kotlin.String? = builder.entityRecognizerArn
    /**
     * The input data configuration that you supplied when you created the entities detection job.
     */
    val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
     *
     * `arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id>`
     *
     * The following is an example job ARN:
     *
     * `arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab`
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * The identifier assigned to the entities detection job.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The name that you assigned the entities detection job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The current status of the entities detection job. If the status is `FAILED`, the `Message` field shows the reason for the failure.
     */
    val jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = builder.jobStatus
    /**
     * The language code of the input documents.
     */
    val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * A description of the status of a job.
     */
    val message: kotlin.String? = builder.message
    /**
     * The output data configuration that you supplied when you created the entities detection job.
     */
    val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The time that the entities detection job was submitted for processing.
     */
    val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your entity detection job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
     */
    val vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.EntitiesDetectionJobProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EntitiesDetectionJobProperties(")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("endTime=$endTime,")
        append("entityRecognizerArn=$entityRecognizerArn,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("jobStatus=$jobStatus,")
        append("languageCode=$languageCode,")
        append("message=$message,")
        append("outputDataConfig=$outputDataConfig,")
        append("submitTime=$submitTime,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAccessRoleArn?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (entityRecognizerArn?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EntitiesDetectionJobProperties

        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (endTime != other.endTime) return false
        if (entityRecognizerArn != other.entityRecognizerArn) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (jobStatus != other.jobStatus) return false
        if (languageCode != other.languageCode) return false
        if (message != other.message) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (submitTime != other.submitTime) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.EntitiesDetectionJobProperties = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input data.
         */
        var dataAccessRoleArn: kotlin.String? = null
        /**
         * The time that the entities detection job completed
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the entity recognizer.
         */
        var entityRecognizerArn: kotlin.String? = null
        /**
         * The input data configuration that you supplied when you created the entities detection job.
         */
        var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the entities detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
         *
         * `arn:<partition>:comprehend:<region>:<account-id>:entities-detection-job/<job-id>`
         *
         * The following is an example job ARN:
         *
         * `arn:aws:comprehend:us-west-2:111122223333:entities-detection-job/1234abcd12ab34cd56ef1234567890ab`
         */
        var jobArn: kotlin.String? = null
        /**
         * The identifier assigned to the entities detection job.
         */
        var jobId: kotlin.String? = null
        /**
         * The name that you assigned the entities detection job.
         */
        var jobName: kotlin.String? = null
        /**
         * The current status of the entities detection job. If the status is `FAILED`, the `Message` field shows the reason for the failure.
         */
        var jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = null
        /**
         * The language code of the input documents.
         */
        var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * A description of the status of a job.
         */
        var message: kotlin.String? = null
        /**
         * The output data configuration that you supplied when you created the entities detection job.
         */
        var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = null
        /**
         * The time that the entities detection job was submitted for processing.
         */
        var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        var volumeKmsKeyId: kotlin.String? = null
        /**
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your entity detection job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
         */
        var vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.EntitiesDetectionJobProperties) : this() {
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.endTime = x.endTime
            this.entityRecognizerArn = x.entityRecognizerArn
            this.inputDataConfig = x.inputDataConfig
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.jobStatus = x.jobStatus
            this.languageCode = x.languageCode
            this.message = x.message
            this.outputDataConfig = x.outputDataConfig
            this.submitTime = x.submitTime
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.EntitiesDetectionJobProperties = EntitiesDetectionJobProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.InputDataConfig] inside the given [block]
         */
        fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.OutputDataConfig] inside the given [block]
         */
        fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.VpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.comprehend.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.comprehend.model.VpcConfig.invoke(block)
        }
    }
}
