// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Provides information about an entity.
 */
class Entity private constructor(builder: Builder) {
    /**
     * A character offset in the input text that shows where the entity begins (the first character is at position 0). The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
     */
    val beginOffset: kotlin.Int? = builder.beginOffset
    /**
     * A character offset in the input text that shows where the entity ends. The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
     */
    val endOffset: kotlin.Int? = builder.endOffset
    /**
     * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
     */
    val score: kotlin.Float? = builder.score
    /**
     * The text of the entity.
     */
    val text: kotlin.String? = builder.text
    /**
     * The entity's type.
     */
    val type: aws.sdk.kotlin.services.comprehend.model.EntityType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.Entity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Entity(")
        append("beginOffset=$beginOffset,")
        append("endOffset=$endOffset,")
        append("score=$score,")
        append("text=$text,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = beginOffset ?: 0
        result = 31 * result + (endOffset ?: 0)
        result = 31 * result + (score?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Entity

        if (beginOffset != other.beginOffset) return false
        if (endOffset != other.endOffset) return false
        if (score != other.score) return false
        if (text != other.text) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.Entity = Builder(this).apply(block).build()

    class Builder {
        /**
         * A character offset in the input text that shows where the entity begins (the first character is at position 0). The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
         */
        var beginOffset: kotlin.Int? = null
        /**
         * A character offset in the input text that shows where the entity ends. The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
         */
        var endOffset: kotlin.Int? = null
        /**
         * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
         */
        var score: kotlin.Float? = null
        /**
         * The text of the entity.
         */
        var text: kotlin.String? = null
        /**
         * The entity's type.
         */
        var type: aws.sdk.kotlin.services.comprehend.model.EntityType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.Entity) : this() {
            this.beginOffset = x.beginOffset
            this.endOffset = x.endOffset
            this.score = x.score
            this.text = x.text
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.Entity = Entity(this)
    }
}
