// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



class ImportModelRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon Comprehend to use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.
     */
    val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    val modelKmsKeyId: kotlin.String? = builder.modelKmsKeyId
    /**
     * The name to assign to the custom model that is created in Amazon Comprehend by this import.
     */
    val modelName: kotlin.String? = builder.modelName
    /**
     * The Amazon Resource Name (ARN) of the custom model to import.
     */
    val sourceModelArn: kotlin.String? = builder.sourceModelArn
    /**
     * Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The version name given to the custom model that is created by this import. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/AWS Region.
     */
    val versionName: kotlin.String? = builder.versionName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.ImportModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportModelRequest(")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("modelKmsKeyId=$modelKmsKeyId,")
        append("modelName=$modelName,")
        append("sourceModelArn=$sourceModelArn,")
        append("tags=$tags,")
        append("versionName=$versionName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAccessRoleArn?.hashCode() ?: 0
        result = 31 * result + (modelKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (modelName?.hashCode() ?: 0)
        result = 31 * result + (sourceModelArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportModelRequest

        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (modelKmsKeyId != other.modelKmsKeyId) return false
        if (modelName != other.modelName) return false
        if (sourceModelArn != other.sourceModelArn) return false
        if (tags != other.tags) return false
        if (versionName != other.versionName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.ImportModelRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that allows Amazon Comprehend to use Amazon Key Management Service (KMS) to encrypt or decrypt the custom model.
         */
        var dataAccessRoleArn: kotlin.String? = null
        /**
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt trained custom models. The ModelKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        var modelKmsKeyId: kotlin.String? = null
        /**
         * The name to assign to the custom model that is created in Amazon Comprehend by this import.
         */
        var modelName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the custom model to import.
         */
        var sourceModelArn: kotlin.String? = null
        /**
         * Tags to be associated with the custom model that is created by this import. A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
         */
        var tags: List<Tag>? = null
        /**
         * The version name given to the custom model that is created by this import. Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the account/AWS Region.
         */
        var versionName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.ImportModelRequest) : this() {
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.modelKmsKeyId = x.modelKmsKeyId
            this.modelName = x.modelName
            this.sourceModelArn = x.sourceModelArn
            this.tags = x.tags
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.ImportModelRequest = ImportModelRequest(this)
    }
}
