// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * The input properties for an inference job.
 */
class InputDataConfig private constructor(builder: Builder) {
    /**
     * The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob.
     *
     * Use DocumentReaderConfig to provide specifications about how you want your inference documents read. Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.
     */
    val documentReaderConfig: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig? = builder.documentReaderConfig
    /**
     * Specifies how the text in an input file should be processed:
     * + `ONE_DOC_PER_FILE` - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers.
     * + `ONE_DOC_PER_LINE` - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.
     */
    val inputFormat: aws.sdk.kotlin.services.comprehend.model.InputFormat? = builder.inputFormat
    /**
     * The Amazon S3 URI for the input data. The URI must be in same region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of data files.
     *
     * For example, if you use the URI `S3://bucketName/prefix`, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
     */
    val s3Uri: kotlin.String? = builder.s3Uri

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.InputDataConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputDataConfig(")
        append("documentReaderConfig=$documentReaderConfig,")
        append("inputFormat=$inputFormat,")
        append("s3Uri=$s3Uri)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentReaderConfig?.hashCode() ?: 0
        result = 31 * result + (inputFormat?.hashCode() ?: 0)
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputDataConfig

        if (documentReaderConfig != other.documentReaderConfig) return false
        if (inputFormat != other.inputFormat) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.InputDataConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * The document reader config field applies only for InputDataConfig of StartEntitiesDetectionJob.
         *
         * Use DocumentReaderConfig to provide specifications about how you want your inference documents read. Currently it applies for PDF documents in StartEntitiesDetectionJob custom inference.
         */
        var documentReaderConfig: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig? = null
        /**
         * Specifies how the text in an input file should be processed:
         * + `ONE_DOC_PER_FILE` - Each file is considered a separate document. Use this option when you are processing large documents, such as newspaper articles or scientific papers.
         * + `ONE_DOC_PER_LINE` - Each line in a file is considered a separate document. Use this option when you are processing many short documents, such as text messages.
         */
        var inputFormat: aws.sdk.kotlin.services.comprehend.model.InputFormat? = null
        /**
         * The Amazon S3 URI for the input data. The URI must be in same region as the API endpoint that you are calling. The URI can point to a single input file or it can provide the prefix for a collection of data files.
         *
         * For example, if you use the URI `S3://bucketName/prefix`, if the prefix is a single file, Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of them as input.
         */
        var s3Uri: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.InputDataConfig) : this() {
            this.documentReaderConfig = x.documentReaderConfig
            this.inputFormat = x.inputFormat
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.InputDataConfig = InputDataConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig] inside the given [block]
         */
        fun documentReaderConfig(block: aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig.Builder.() -> kotlin.Unit) {
            this.documentReaderConfig = aws.sdk.kotlin.services.comprehend.model.DocumentReaderConfig.invoke(block)
        }
    }
}
