// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a PII entities detection job.
 */
class PiiEntitiesDetectionJobProperties private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input data.
     */
    val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The time that the PII entities detection job completed.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The input properties for a PII entities detection job.
     */
    val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the PII entities detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
     *
     * `arn:<partition>:comprehend:<region>:<account-id>:pii-entities-detection-job/<job-id>`
     *
     * The following is an example job ARN:
     *
     * `arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab`
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * The identifier assigned to the PII entities detection job.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The name that you assigned the PII entities detection job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The current status of the PII entities detection job. If the status is `FAILED`, the `Message` field shows the reason for the failure.
     */
    val jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = builder.jobStatus
    /**
     * The language code of the input documents
     */
    val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * A description of the status of a job.
     */
    val message: kotlin.String? = builder.message
    /**
     * Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.
     */
    val mode: aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionMode? = builder.mode
    /**
     * The output data configuration that you supplied when you created the PII entities detection job.
     */
    val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.PiiOutputDataConfig? = builder.outputDataConfig
    /**
     * Provides configuration parameters for PII entity redaction.
     *
     * This parameter is required if you set the `Mode` parameter to `ONLY_REDACTION`. In that case, you must provide a `RedactionConfig` definition that includes the `PiiEntityTypes` parameter.
     */
    val redactionConfig: aws.sdk.kotlin.services.comprehend.model.RedactionConfig? = builder.redactionConfig
    /**
     * The time that the PII entities detection job was submitted for processing.
     */
    val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionJobProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PiiEntitiesDetectionJobProperties(")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("endTime=$endTime,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("jobStatus=$jobStatus,")
        append("languageCode=$languageCode,")
        append("message=$message,")
        append("mode=$mode,")
        append("outputDataConfig=$outputDataConfig,")
        append("redactionConfig=$redactionConfig,")
        append("submitTime=$submitTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAccessRoleArn?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (redactionConfig?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PiiEntitiesDetectionJobProperties

        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (endTime != other.endTime) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (jobStatus != other.jobStatus) return false
        if (languageCode != other.languageCode) return false
        if (message != other.message) return false
        if (mode != other.mode) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (redactionConfig != other.redactionConfig) return false
        if (submitTime != other.submitTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionJobProperties = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input data.
         */
        var dataAccessRoleArn: kotlin.String? = null
        /**
         * The time that the PII entities detection job completed.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The input properties for a PII entities detection job.
         */
        var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the PII entities detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
         *
         * `arn:<partition>:comprehend:<region>:<account-id>:pii-entities-detection-job/<job-id>`
         *
         * The following is an example job ARN:
         *
         * `arn:aws:comprehend:us-west-2:111122223333:pii-entities-detection-job/1234abcd12ab34cd56ef1234567890ab`
         */
        var jobArn: kotlin.String? = null
        /**
         * The identifier assigned to the PII entities detection job.
         */
        var jobId: kotlin.String? = null
        /**
         * The name that you assigned the PII entities detection job.
         */
        var jobName: kotlin.String? = null
        /**
         * The current status of the PII entities detection job. If the status is `FAILED`, the `Message` field shows the reason for the failure.
         */
        var jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = null
        /**
         * The language code of the input documents
         */
        var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * A description of the status of a job.
         */
        var message: kotlin.String? = null
        /**
         * Specifies whether the output provides the locations (offsets) of PII entities or a file in which PII entities are redacted.
         */
        var mode: aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionMode? = null
        /**
         * The output data configuration that you supplied when you created the PII entities detection job.
         */
        var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.PiiOutputDataConfig? = null
        /**
         * Provides configuration parameters for PII entity redaction.
         *
         * This parameter is required if you set the `Mode` parameter to `ONLY_REDACTION`. In that case, you must provide a `RedactionConfig` definition that includes the `PiiEntityTypes` parameter.
         */
        var redactionConfig: aws.sdk.kotlin.services.comprehend.model.RedactionConfig? = null
        /**
         * The time that the PII entities detection job was submitted for processing.
         */
        var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionJobProperties) : this() {
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.endTime = x.endTime
            this.inputDataConfig = x.inputDataConfig
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.jobStatus = x.jobStatus
            this.languageCode = x.languageCode
            this.message = x.message
            this.mode = x.mode
            this.outputDataConfig = x.outputDataConfig
            this.redactionConfig = x.redactionConfig
            this.submitTime = x.submitTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.PiiEntitiesDetectionJobProperties = PiiEntitiesDetectionJobProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.InputDataConfig] inside the given [block]
         */
        fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.PiiOutputDataConfig] inside the given [block]
         */
        fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.PiiOutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.PiiOutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.RedactionConfig] inside the given [block]
         */
        fun redactionConfig(block: aws.sdk.kotlin.services.comprehend.model.RedactionConfig.Builder.() -> kotlin.Unit) {
            this.redactionConfig = aws.sdk.kotlin.services.comprehend.model.RedactionConfig.invoke(block)
        }
    }
}
