// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Provides information about a PII entity.
 */
class PiiEntity private constructor(builder: Builder) {
    /**
     * A character offset in the input text that shows where the PII entity begins (the first character is at position 0). The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
     */
    val beginOffset: kotlin.Int? = builder.beginOffset
    /**
     * A character offset in the input text that shows where the PII entity ends. The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
     */
    val endOffset: kotlin.Int? = builder.endOffset
    /**
     * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
     */
    val score: kotlin.Float? = builder.score
    /**
     * The entity's type.
     */
    val type: aws.sdk.kotlin.services.comprehend.model.PiiEntityType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.PiiEntity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PiiEntity(")
        append("beginOffset=$beginOffset,")
        append("endOffset=$endOffset,")
        append("score=$score,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = beginOffset ?: 0
        result = 31 * result + (endOffset ?: 0)
        result = 31 * result + (score?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PiiEntity

        if (beginOffset != other.beginOffset) return false
        if (endOffset != other.endOffset) return false
        if (score != other.score) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.PiiEntity = Builder(this).apply(block).build()

    class Builder {
        /**
         * A character offset in the input text that shows where the PII entity begins (the first character is at position 0). The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
         */
        var beginOffset: kotlin.Int? = null
        /**
         * A character offset in the input text that shows where the PII entity ends. The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
         */
        var endOffset: kotlin.Int? = null
        /**
         * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
         */
        var score: kotlin.Float? = null
        /**
         * The entity's type.
         */
        var type: aws.sdk.kotlin.services.comprehend.model.PiiEntityType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.PiiEntity) : this() {
            this.beginOffset = x.beginOffset
            this.endOffset = x.endOffset
            this.score = x.score
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.PiiEntity = PiiEntity(this)
    }
}
