// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



class StartDocumentClassificationJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
     *
     * `arn:<partition>:comprehend:<region>:<account-id>:document-classification-job/<job-id>`
     *
     * The following is an example job ARN:
     *
     * `arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab`
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * The identifier generated for the job. To get the status of the job, use this identifier with the operation.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The status of the job:
     * + SUBMITTED - The job has been received and queued for processing.
     * + IN_PROGRESS - Amazon Comprehend is processing the job.
     * + COMPLETED - The job was successfully completed and the output is available.
     * + FAILED - The job did not complete. For details, use the operation.
     * + STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
     * + STOPPED - The job was successfully stopped without completing.
     */
    val jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = builder.jobStatus

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartDocumentClassificationJobResponse(")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobStatus=$jobStatus)")
    }

    override fun hashCode(): kotlin.Int {
        var result = jobArn?.hashCode() ?: 0
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartDocumentClassificationJobResponse

        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobStatus != other.jobStatus) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the document classification job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
         *
         * `arn:<partition>:comprehend:<region>:<account-id>:document-classification-job/<job-id>`
         *
         * The following is an example job ARN:
         *
         * `arn:aws:comprehend:us-west-2:111122223333:document-classification-job/1234abcd12ab34cd56ef1234567890ab`
         */
        var jobArn: kotlin.String? = null
        /**
         * The identifier generated for the job. To get the status of the job, use this identifier with the operation.
         */
        var jobId: kotlin.String? = null
        /**
         * The status of the job:
         * + SUBMITTED - The job has been received and queued for processing.
         * + IN_PROGRESS - Amazon Comprehend is processing the job.
         * + COMPLETED - The job was successfully completed and the output is available.
         * + FAILED - The job did not complete. For details, use the operation.
         * + STOP_REQUESTED - Amazon Comprehend has received a stop request for the job and is processing the request.
         * + STOPPED - The job was successfully stopped without completing.
         */
        var jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobResponse) : this() {
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobStatus = x.jobStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.StartDocumentClassificationJobResponse = StartDocumentClassificationJobResponse(this)
    }
}
