// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Represents a work in the input text that was recognized and assigned a part of speech. There is one syntax token record for each word in the source text.
 */
class SyntaxToken private constructor(builder: Builder) {
    /**
     * The zero-based offset from the beginning of the source text to the first character in the word.
     */
    val beginOffset: kotlin.Int? = builder.beginOffset
    /**
     * The zero-based offset from the beginning of the source text to the last character in the word.
     */
    val endOffset: kotlin.Int? = builder.endOffset
    /**
     * Provides the part of speech label and the confidence level that Amazon Comprehend has that the part of speech was correctly identified. For more information, see how-syntax.
     */
    val partOfSpeech: aws.sdk.kotlin.services.comprehend.model.PartOfSpeechTag? = builder.partOfSpeech
    /**
     * The word that was recognized in the source text.
     */
    val text: kotlin.String? = builder.text
    /**
     * A unique identifier for a token.
     */
    val tokenId: kotlin.Int? = builder.tokenId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.SyntaxToken = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SyntaxToken(")
        append("beginOffset=$beginOffset,")
        append("endOffset=$endOffset,")
        append("partOfSpeech=$partOfSpeech,")
        append("text=$text,")
        append("tokenId=$tokenId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = beginOffset ?: 0
        result = 31 * result + (endOffset ?: 0)
        result = 31 * result + (partOfSpeech?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        result = 31 * result + (tokenId ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SyntaxToken

        if (beginOffset != other.beginOffset) return false
        if (endOffset != other.endOffset) return false
        if (partOfSpeech != other.partOfSpeech) return false
        if (text != other.text) return false
        if (tokenId != other.tokenId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.SyntaxToken = Builder(this).apply(block).build()

    class Builder {
        /**
         * The zero-based offset from the beginning of the source text to the first character in the word.
         */
        var beginOffset: kotlin.Int? = null
        /**
         * The zero-based offset from the beginning of the source text to the last character in the word.
         */
        var endOffset: kotlin.Int? = null
        /**
         * Provides the part of speech label and the confidence level that Amazon Comprehend has that the part of speech was correctly identified. For more information, see how-syntax.
         */
        var partOfSpeech: aws.sdk.kotlin.services.comprehend.model.PartOfSpeechTag? = null
        /**
         * The word that was recognized in the source text.
         */
        var text: kotlin.String? = null
        /**
         * A unique identifier for a token.
         */
        var tokenId: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.SyntaxToken) : this() {
            this.beginOffset = x.beginOffset
            this.endOffset = x.endOffset
            this.partOfSpeech = x.partOfSpeech
            this.text = x.text
            this.tokenId = x.tokenId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.SyntaxToken = SyntaxToken(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.PartOfSpeechTag] inside the given [block]
         */
        fun partOfSpeech(block: aws.sdk.kotlin.services.comprehend.model.PartOfSpeechTag.Builder.() -> kotlin.Unit) {
            this.partOfSpeech = aws.sdk.kotlin.services.comprehend.model.PartOfSpeechTag.invoke(block)
        }
    }
}
