// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a topic detection job.
 */
class TopicsDetectionJobProperties private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your job data.
     */
    val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The time that the topic detection job was completed.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The input data configuration supplied when you created the topic detection job.
     */
    val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
     *
     * `arn:<partition>:comprehend:<region>:<account-id>:topics-detection-job/<job-id>`
     *
     * The following is an example job ARN:
     *
     * `arn:aws:comprehend:us-west-2:111122223333:topics-detection-job/1234abcd12ab34cd56ef1234567890ab`
     */
    val jobArn: kotlin.String? = builder.jobArn
    /**
     * The identifier assigned to the topic detection job.
     */
    val jobId: kotlin.String? = builder.jobId
    /**
     * The name of the topic detection job.
     */
    val jobName: kotlin.String? = builder.jobName
    /**
     * The current status of the topic detection job. If the status is `Failed`, the reason for the failure is shown in the `Message` field.
     */
    val jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = builder.jobStatus
    /**
     * A description for the status of a job.
     */
    val message: kotlin.String? = builder.message
    /**
     * The number of topics to detect supplied when you created the topic detection job. The default is 10.
     */
    val numberOfTopics: kotlin.Int? = builder.numberOfTopics
    /**
     * The output data configuration supplied when you created the topic detection job.
     */
    val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The time that the topic detection job was submitted for processing.
     */
    val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your topic detection job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
     */
    val vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = builder.vpcConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.TopicsDetectionJobProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TopicsDetectionJobProperties(")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("endTime=$endTime,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("jobStatus=$jobStatus,")
        append("message=$message,")
        append("numberOfTopics=$numberOfTopics,")
        append("outputDataConfig=$outputDataConfig,")
        append("submitTime=$submitTime,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAccessRoleArn?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (numberOfTopics ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TopicsDetectionJobProperties

        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (endTime != other.endTime) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (jobStatus != other.jobStatus) return false
        if (message != other.message) return false
        if (numberOfTopics != other.numberOfTopics) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (submitTime != other.submitTime) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.TopicsDetectionJobProperties = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role that grants Amazon Comprehend read access to your job data.
         */
        var dataAccessRoleArn: kotlin.String? = null
        /**
         * The time that the topic detection job was completed.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The input data configuration supplied when you created the topic detection job.
         */
        var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the topics detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
         *
         * `arn:<partition>:comprehend:<region>:<account-id>:topics-detection-job/<job-id>`
         *
         * The following is an example job ARN:
         *
         * `arn:aws:comprehend:us-west-2:111122223333:topics-detection-job/1234abcd12ab34cd56ef1234567890ab`
         */
        var jobArn: kotlin.String? = null
        /**
         * The identifier assigned to the topic detection job.
         */
        var jobId: kotlin.String? = null
        /**
         * The name of the topic detection job.
         */
        var jobName: kotlin.String? = null
        /**
         * The current status of the topic detection job. If the status is `Failed`, the reason for the failure is shown in the `Message` field.
         */
        var jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = null
        /**
         * A description for the status of a job.
         */
        var message: kotlin.String? = null
        /**
         * The number of topics to detect supplied when you created the topic detection job. The default is 10.
         */
        var numberOfTopics: kotlin.Int? = null
        /**
         * The output data configuration supplied when you created the topic detection job.
         */
        var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = null
        /**
         * The time that the topic detection job was submitted for processing.
         */
        var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        var volumeKmsKeyId: kotlin.String? = null
        /**
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your topic detection job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
         */
        var vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.TopicsDetectionJobProperties) : this() {
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.endTime = x.endTime
            this.inputDataConfig = x.inputDataConfig
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.jobStatus = x.jobStatus
            this.message = x.message
            this.numberOfTopics = x.numberOfTopics
            this.outputDataConfig = x.outputDataConfig
            this.submitTime = x.submitTime
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.TopicsDetectionJobProperties = TopicsDetectionJobProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.InputDataConfig] inside the given [block]
         */
        fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.OutputDataConfig] inside the given [block]
         */
        fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.VpcConfig] inside the given [block]
         */
        fun vpcConfig(block: aws.sdk.kotlin.services.comprehend.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.comprehend.model.VpcConfig.invoke(block)
        }
    }
}
