// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.comprehend.model.ClassifyDocumentResponse
import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.DocumentClass
import aws.sdk.kotlin.services.comprehend.model.DocumentLabel
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ClassifyDocumentOperationDeserializer: HttpDeserialize<ClassifyDocumentResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ClassifyDocumentResponse {
        if (!response.status.isSuccess()) {
            throwClassifyDocumentError(context, response)
        }
        val builder = ClassifyDocumentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeClassifyDocumentOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwClassifyDocumentError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceUnavailableException" -> ResourceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeClassifyDocumentOperationBody(builder: ClassifyDocumentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLASSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Classes"))
    val LABELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Labels"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLASSES_DESCRIPTOR)
        field(LABELS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLASSES_DESCRIPTOR.index -> builder.classes =
                    deserializer.deserializeList(CLASSES_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentClass>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentClassDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                LABELS_DESCRIPTOR.index -> builder.labels =
                    deserializer.deserializeList(LABELS_DESCRIPTOR) {
                        val col0 = mutableListOf<DocumentLabel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDocumentLabelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
