// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.DetectEntitiesResponse
import aws.sdk.kotlin.services.comprehend.model.Entity
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DetectEntitiesOperationDeserializer: HttpDeserialize<DetectEntitiesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DetectEntitiesResponse {
        if (!response.status.isSuccess()) {
            throwDetectEntitiesError(context, response)
        }
        val builder = DetectEntitiesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDetectEntitiesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDetectEntitiesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceUnavailableException" -> ResourceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedLanguageException" -> UnsupportedLanguageExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDetectEntitiesOperationBody(builder: DetectEntitiesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Entities"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITIES_DESCRIPTOR.index -> builder.entities =
                    deserializer.deserializeList(ENTITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Entity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEntityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
