// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.comprehend.model.BatchDetectDominantLanguageItemResult
import aws.sdk.kotlin.services.comprehend.model.BatchDetectDominantLanguageResponse
import aws.sdk.kotlin.services.comprehend.model.BatchItemError
import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchDetectDominantLanguageOperationDeserializer: HttpDeserialize<BatchDetectDominantLanguageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchDetectDominantLanguageResponse {
        if (!response.status.isSuccess()) {
            throwBatchDetectDominantLanguageError(context, response)
        }
        val builder = BatchDetectDominantLanguageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchDetectDominantLanguageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchDetectDominantLanguageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BatchSizeLimitExceededException" -> BatchSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "TextSizeLimitExceededException" -> TextSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDetectDominantLanguageOperationBody(builder: BatchDetectDominantLanguageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ErrorList"))
    val RESULTLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResultList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORLIST_DESCRIPTOR)
        field(RESULTLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORLIST_DESCRIPTOR.index -> builder.errorList =
                    deserializer.deserializeList(ERRORLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchItemError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchItemErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESULTLIST_DESCRIPTOR.index -> builder.resultList =
                    deserializer.deserializeList(RESULTLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchDetectDominantLanguageItemResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchDetectDominantLanguageItemResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
