// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.comprehend.model.ComprehendException
import aws.sdk.kotlin.services.comprehend.model.DescribeEventsDetectionJobResponse
import aws.sdk.kotlin.services.comprehend.model.EventsDetectionJobProperties
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeEventsDetectionJobOperationDeserializer: HttpDeserialize<DescribeEventsDetectionJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEventsDetectionJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEventsDetectionJobError(context, response)
        }
        val builder = DescribeEventsDetectionJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEventsDetectionJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEventsDetectionJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComprehendException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "JobNotFoundException" -> JobNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComprehendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEventsDetectionJobOperationBody(builder: DescribeEventsDetectionJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EVENTSDETECTIONJOBPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EventsDetectionJobProperties"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EVENTSDETECTIONJOBPROPERTIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EVENTSDETECTIONJOBPROPERTIES_DESCRIPTOR.index -> builder.eventsDetectionJobProperties = deserializeEventsDetectionJobPropertiesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
