// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model



/**
 * Describes a key noun phrase.
 */
public class KeyPhrase private constructor(builder: Builder) {
    /**
     * A character offset in the input text that shows where the key phrase begins (the first character is at position 0). The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
     */
    public val beginOffset: kotlin.Int? = builder.beginOffset
    /**
     * A character offset in the input text where the key phrase ends. The offset returns the position of each UTF-8 code point in the string. A `code point` is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
     */
    public val endOffset: kotlin.Int? = builder.endOffset
    /**
     * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
     */
    public val score: kotlin.Float? = builder.score
    /**
     * The text of a key noun phrase.
     */
    public val text: kotlin.String? = builder.text

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.KeyPhrase = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeyPhrase(")
        append("beginOffset=$beginOffset,")
        append("endOffset=$endOffset,")
        append("score=$score,")
        append("text=$text)")
    }

    override fun hashCode(): kotlin.Int {
        var result = beginOffset ?: 0
        result = 31 * result + (endOffset ?: 0)
        result = 31 * result + (score?.hashCode() ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeyPhrase

        if (beginOffset != other.beginOffset) return false
        if (endOffset != other.endOffset) return false
        if (score != other.score) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.KeyPhrase = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A character offset in the input text that shows where the key phrase begins (the first character is at position 0). The offset returns the position of each UTF-8 code point in the string. A *code point* is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
         */
        public var beginOffset: kotlin.Int? = null
        /**
         * A character offset in the input text where the key phrase ends. The offset returns the position of each UTF-8 code point in the string. A `code point` is the abstract character from a particular graphical representation. For example, a multi-byte UTF-8 character maps to a single code point.
         */
        public var endOffset: kotlin.Int? = null
        /**
         * The level of confidence that Amazon Comprehend has in the accuracy of the detection.
         */
        public var score: kotlin.Float? = null
        /**
         * The text of a key noun phrase.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.KeyPhrase) : this() {
            this.beginOffset = x.beginOffset
            this.endOffset = x.endOffset
            this.score = x.score
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.KeyPhrase = KeyPhrase(this)
    }
}
