// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.comprehend.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about a key phrases detection job.
 */
public class KeyPhrasesDetectionJobProperties private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input data.
     */
    public val dataAccessRoleArn: kotlin.String? = builder.dataAccessRoleArn
    /**
     * The time that the key phrases detection job completed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The input data configuration that you supplied when you created the key phrases detection job.
     */
    public val inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = builder.inputDataConfig
    /**
     * The Amazon Resource Name (ARN) of the key phrases detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
     *
     * `arn:<partition>:comprehend:<region>:<account-id>:key-phrases-detection-job/<job-id>`
     *
     * The following is an example job ARN:
     *
     * `arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab`
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The identifier assigned to the key phrases detection job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The name that you assigned the key phrases detection job.
     */
    public val jobName: kotlin.String? = builder.jobName
    /**
     * The current status of the key phrases detection job. If the status is `FAILED`, the `Message` field shows the reason for the failure.
     */
    public val jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = builder.jobStatus
    /**
     * The language code of the input documents.
     */
    public val languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = builder.languageCode
    /**
     * A description of the status of a job.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The output data configuration that you supplied when you created the key phrases detection job.
     */
    public val outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = builder.outputDataConfig
    /**
     * The time that the key phrases detection job was submitted for processing.
     */
    public val submitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.submitTime
    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
     * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
     * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
     */
    public val volumeKmsKeyId: kotlin.String? = builder.volumeKmsKeyId
    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your key phrases detection job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
     */
    public val vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.comprehend.model.KeyPhrasesDetectionJobProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KeyPhrasesDetectionJobProperties(")
        append("dataAccessRoleArn=$dataAccessRoleArn,")
        append("endTime=$endTime,")
        append("inputDataConfig=$inputDataConfig,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobName=$jobName,")
        append("jobStatus=$jobStatus,")
        append("languageCode=$languageCode,")
        append("message=$message,")
        append("outputDataConfig=$outputDataConfig,")
        append("submitTime=$submitTime,")
        append("volumeKmsKeyId=$volumeKmsKeyId,")
        append("vpcConfig=$vpcConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataAccessRoleArn?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (inputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobName?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (languageCode?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (outputDataConfig?.hashCode() ?: 0)
        result = 31 * result + (submitTime?.hashCode() ?: 0)
        result = 31 * result + (volumeKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KeyPhrasesDetectionJobProperties

        if (dataAccessRoleArn != other.dataAccessRoleArn) return false
        if (endTime != other.endTime) return false
        if (inputDataConfig != other.inputDataConfig) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobName != other.jobName) return false
        if (jobStatus != other.jobStatus) return false
        if (languageCode != other.languageCode) return false
        if (message != other.message) return false
        if (outputDataConfig != other.outputDataConfig) return false
        if (submitTime != other.submitTime) return false
        if (volumeKmsKeyId != other.volumeKmsKeyId) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.comprehend.model.KeyPhrasesDetectionJobProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to your input data.
         */
        public var dataAccessRoleArn: kotlin.String? = null
        /**
         * The time that the key phrases detection job completed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The input data configuration that you supplied when you created the key phrases detection job.
         */
        public var inputDataConfig: aws.sdk.kotlin.services.comprehend.model.InputDataConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the key phrases detection job. It is a unique, fully qualified identifier for the job. It includes the AWS account, Region, and the job ID. The format of the ARN is as follows:
         *
         * `arn:<partition>:comprehend:<region>:<account-id>:key-phrases-detection-job/<job-id>`
         *
         * The following is an example job ARN:
         *
         * `arn:aws:comprehend:us-west-2:111122223333:key-phrases-detection-job/1234abcd12ab34cd56ef1234567890ab`
         */
        public var jobArn: kotlin.String? = null
        /**
         * The identifier assigned to the key phrases detection job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The name that you assigned the key phrases detection job.
         */
        public var jobName: kotlin.String? = null
        /**
         * The current status of the key phrases detection job. If the status is `FAILED`, the `Message` field shows the reason for the failure.
         */
        public var jobStatus: aws.sdk.kotlin.services.comprehend.model.JobStatus? = null
        /**
         * The language code of the input documents.
         */
        public var languageCode: aws.sdk.kotlin.services.comprehend.model.LanguageCode? = null
        /**
         * A description of the status of a job.
         */
        public var message: kotlin.String? = null
        /**
         * The output data configuration that you supplied when you created the key phrases detection job.
         */
        public var outputDataConfig: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig? = null
        /**
         * The time that the key phrases detection job was submitted for processing.
         */
        public var submitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job. The VolumeKmsKeyId can be either of the following formats:
         * + KMS Key ID: `"1234abcd-12ab-34cd-56ef-1234567890ab"`
         * + Amazon Resource Name (ARN) of a KMS Key: `"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"`
         */
        public var volumeKmsKeyId: kotlin.String? = null
        /**
         * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your key phrases detection job. For more information, see [Amazon VPC](https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
         */
        public var vpcConfig: aws.sdk.kotlin.services.comprehend.model.VpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.comprehend.model.KeyPhrasesDetectionJobProperties) : this() {
            this.dataAccessRoleArn = x.dataAccessRoleArn
            this.endTime = x.endTime
            this.inputDataConfig = x.inputDataConfig
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobName = x.jobName
            this.jobStatus = x.jobStatus
            this.languageCode = x.languageCode
            this.message = x.message
            this.outputDataConfig = x.outputDataConfig
            this.submitTime = x.submitTime
            this.volumeKmsKeyId = x.volumeKmsKeyId
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.comprehend.model.KeyPhrasesDetectionJobProperties = KeyPhrasesDetectionJobProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.InputDataConfig] inside the given [block]
         */
        public fun inputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.InputDataConfig.Builder.() -> kotlin.Unit) {
            this.inputDataConfig = aws.sdk.kotlin.services.comprehend.model.InputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.OutputDataConfig] inside the given [block]
         */
        public fun outputDataConfig(block: aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.Builder.() -> kotlin.Unit) {
            this.outputDataConfig = aws.sdk.kotlin.services.comprehend.model.OutputDataConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.comprehend.model.VpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.comprehend.model.VpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.comprehend.model.VpcConfig.invoke(block)
        }
    }
}
