// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the enrollment status of an organization's member accounts in Compute Optimizer.
 */
public class AccountEnrollmentStatus private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.
     */
    public val lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTimestamp
    /**
     * The account enrollment status.
     */
    public val status: aws.sdk.kotlin.services.computeoptimizer.model.Status? = builder.status
    /**
     * The reason for the account enrollment status.
     *
     * For example, an account might show a status of `Pending` because member accounts of an organization require more time to be enrolled in the service.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.AccountEnrollmentStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountEnrollmentStatus(")
        append("accountId=$accountId,")
        append("lastUpdatedTimestamp=$lastUpdatedTimestamp,")
        append("status=$status,")
        append("statusReason=$statusReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountEnrollmentStatus

        if (accountId != other.accountId) return false
        if (lastUpdatedTimestamp != other.lastUpdatedTimestamp) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.AccountEnrollmentStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.
         */
        public var lastUpdatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The account enrollment status.
         */
        public var status: aws.sdk.kotlin.services.computeoptimizer.model.Status? = null
        /**
         * The reason for the account enrollment status.
         *
         * For example, an account might show a status of `Pending` because member accounts of an organization require more time to be enrolled in the service.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.AccountEnrollmentStatus) : this() {
            this.accountId = x.accountId
            this.lastUpdatedTimestamp = x.lastUpdatedTimestamp
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.AccountEnrollmentStatus = AccountEnrollmentStatus(this)
    }
}
