// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class ExportEbsVolumeRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The IDs of the Amazon Web Services accounts for which to export Amazon EBS volume recommendations.
     *
     * If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.
     *
     * This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.
     *
     * Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.
     *
     * You can specify multiple account IDs per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * The recommendations data to include in the export file. For more information about the fields that can be exported, see [Exported files](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files) in the *Compute Optimizer User Guide*.
     */
    public val fieldsToExport: List<ExportableVolumeField>? = builder.fieldsToExport
    /**
     * The format of the export file.
     *
     * The only export file format currently supported is `Csv`.
     */
    public val fileFormat: aws.sdk.kotlin.services.computeoptimizer.model.FileFormat? = builder.fileFormat
    /**
     * An array of objects to specify a filter that exports a more specific set of Amazon EBS volume recommendations.
     */
    public val filters: List<EbsFilter>? = builder.filters
    /**
     * Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.
     *
     * The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see [Compute Optimizer and Amazon Web Services Organizations trusted access](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access) in the *Compute Optimizer User Guide*.
     *
     * Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.
     *
     * This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.
     *
     * Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.
     */
    public val includeMemberAccounts: kotlin.Boolean = builder.includeMemberAccounts
    /**
     * Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for a recommendations export job.
     *
     * You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see [Amazon S3 Bucket Policy for Compute Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html) in the *Compute Optimizer User Guide*.
     */
    public val s3DestinationConfig: aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig? = builder.s3DestinationConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExportEbsVolumeRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("fieldsToExport=$fieldsToExport,")
        append("fileFormat=$fileFormat,")
        append("filters=$filters,")
        append("includeMemberAccounts=$includeMemberAccounts,")
        append("s3DestinationConfig=$s3DestinationConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (fieldsToExport?.hashCode() ?: 0)
        result = 31 * result + (fileFormat?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includeMemberAccounts.hashCode())
        result = 31 * result + (s3DestinationConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExportEbsVolumeRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (fieldsToExport != other.fieldsToExport) return false
        if (fileFormat != other.fileFormat) return false
        if (filters != other.filters) return false
        if (includeMemberAccounts != other.includeMemberAccounts) return false
        if (s3DestinationConfig != other.s3DestinationConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IDs of the Amazon Web Services accounts for which to export Amazon EBS volume recommendations.
         *
         * If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.
         *
         * This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.
         *
         * Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.
         *
         * You can specify multiple account IDs per request.
         */
        public var accountIds: List<String>? = null
        /**
         * The recommendations data to include in the export file. For more information about the fields that can be exported, see [Exported files](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files) in the *Compute Optimizer User Guide*.
         */
        public var fieldsToExport: List<ExportableVolumeField>? = null
        /**
         * The format of the export file.
         *
         * The only export file format currently supported is `Csv`.
         */
        public var fileFormat: aws.sdk.kotlin.services.computeoptimizer.model.FileFormat? = null
        /**
         * An array of objects to specify a filter that exports a more specific set of Amazon EBS volume recommendations.
         */
        public var filters: List<EbsFilter>? = null
        /**
         * Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.
         *
         * The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see [Compute Optimizer and Amazon Web Services Organizations trusted access](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access) in the *Compute Optimizer User Guide*.
         *
         * Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.
         *
         * This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.
         *
         * Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.
         */
        public var includeMemberAccounts: kotlin.Boolean = false
        /**
         * Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for a recommendations export job.
         *
         * You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see [Amazon S3 Bucket Policy for Compute Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html) in the *Compute Optimizer User Guide*.
         */
        public var s3DestinationConfig: aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.fieldsToExport = x.fieldsToExport
            this.fileFormat = x.fileFormat
            this.filters = x.filters
            this.includeMemberAccounts = x.includeMemberAccounts
            this.s3DestinationConfig = x.s3DestinationConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.ExportEbsVolumeRecommendationsRequest = ExportEbsVolumeRecommendationsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig] inside the given [block]
         */
        public fun s3DestinationConfig(block: aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig.Builder.() -> kotlin.Unit) {
            this.s3DestinationConfig = aws.sdk.kotlin.services.computeoptimizer.model.S3DestinationConfig.invoke(block)
        }
    }
}
