// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class GetAutoScalingGroupRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account for which to return Auto Scaling group recommendations.
     *
     * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return Auto Scaling group recommendations.
     *
     * Only one account ID can be specified per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.
     */
    public val autoScalingGroupArns: List<String>? = builder.autoScalingGroupArns
    /**
     * An array of objects to specify a filter that returns a more specific list of Auto Scaling group recommendations.
     */
    public val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of Auto Scaling group recommendations to return with a single request.
     *
     * To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of Auto Scaling group recommendations.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * An object to specify the preferences for the Auto Scaling group recommendations to return in the response.
     */
    public val recommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences? = builder.recommendationPreferences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetAutoScalingGroupRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("autoScalingGroupArns=$autoScalingGroupArns,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("recommendationPreferences=$recommendationPreferences)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (autoScalingGroupArns?.hashCode() ?: 0)
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (recommendationPreferences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetAutoScalingGroupRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (autoScalingGroupArns != other.autoScalingGroupArns) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (recommendationPreferences != other.recommendationPreferences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account for which to return Auto Scaling group recommendations.
         *
         * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return Auto Scaling group recommendations.
         *
         * Only one account ID can be specified per request.
         */
        public var accountIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.
         */
        public var autoScalingGroupArns: List<String>? = null
        /**
         * An array of objects to specify a filter that returns a more specific list of Auto Scaling group recommendations.
         */
        public var filters: List<Filter>? = null
        /**
         * The maximum number of Auto Scaling group recommendations to return with a single request.
         *
         * To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of Auto Scaling group recommendations.
         */
        public var nextToken: kotlin.String? = null
        /**
         * An object to specify the preferences for the Auto Scaling group recommendations to return in the response.
         */
        public var recommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.autoScalingGroupArns = x.autoScalingGroupArns
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.recommendationPreferences = x.recommendationPreferences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetAutoScalingGroupRecommendationsRequest = GetAutoScalingGroupRecommendationsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences] inside the given [block]
         */
        public fun recommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.recommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.RecommendationPreferences.invoke(block)
        }
    }
}
