// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



public class GetEbsVolumeRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account for which to return volume recommendations.
     *
     * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return volume recommendations.
     *
     * Only one account ID can be specified per request.
     */
    public val accountIds: List<String>? = builder.accountIds
    /**
     * An array of objects to specify a filter that returns a more specific list of volume recommendations.
     */
    public val filters: List<EbsFilter>? = builder.filters
    /**
     * The maximum number of volume recommendations to return with a single request.
     *
     * To retrieve the remaining results, make another request with the returned `nextToken` value.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to advance to the next page of volume recommendations.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The Amazon Resource Name (ARN) of the volumes for which to return recommendations.
     */
    public val volumeArns: List<String>? = builder.volumeArns

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEbsVolumeRecommendationsRequest(")
        append("accountIds=$accountIds,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("volumeArns=$volumeArns)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIds?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (volumeArns?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEbsVolumeRecommendationsRequest

        if (accountIds != other.accountIds) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (volumeArns != other.volumeArns) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account for which to return volume recommendations.
         *
         * If your account is the management account of an organization, use this parameter to specify the member account for which you want to return volume recommendations.
         *
         * Only one account ID can be specified per request.
         */
        public var accountIds: List<String>? = null
        /**
         * An array of objects to specify a filter that returns a more specific list of volume recommendations.
         */
        public var filters: List<EbsFilter>? = null
        /**
         * The maximum number of volume recommendations to return with a single request.
         *
         * To retrieve the remaining results, make another request with the returned `nextToken` value.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The token to advance to the next page of volume recommendations.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the volumes for which to return recommendations.
         */
        public var volumeArns: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest) : this() {
            this.accountIds = x.accountIds
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.volumeArns = x.volumeArns
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.GetEbsVolumeRecommendationsRequest = GetEbsVolumeRecommendationsRequest(this)
    }
}
