// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon EC2 instance recommendation.
 */
public class InstanceRecommendation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the instance.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The instance type of the current instance.
     */
    public val currentInstanceType: kotlin.String? = builder.currentInstanceType
    /**
     * The risk of the current instance not meeting the performance needs of its workloads. The higher the risk, the more likely the current instance cannot meet the performance requirements of its workload.
     */
    public val currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = builder.currentPerformanceRisk
    /**
     * An object that describes the effective recommendation preferences for the instance.
     */
    public val effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences? = builder.effectiveRecommendationPreferences
    /**
     * The finding classification of the instance.
     *
     * Findings for instances include:
     * + **`Underprovisioned`**—An instance is considered under-provisioned when at least one specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of your workload. Under-provisioned instances may lead to poor application performance.
     * + **`Overprovisioned`**—An instance is considered over-provisioned when at least one specification of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to unnecessary infrastructure cost.
     * + **`Optimized`**—An instance is considered optimized when all specifications of your instance, such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned. For optimized resources, Compute Optimizer might recommend a new generation instance type.
     */
    public val finding: aws.sdk.kotlin.services.computeoptimizer.model.Finding? = builder.finding
    /**
     * The reason for the finding classification of the instance.
     *
     * Finding reason codes for instances include:
     * + **`CPUOverprovisioned`** — The instance’s CPU configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `CPUUtilization` metric of the current instance during the look-back period.
     * + **`CPUUnderprovisioned`** — The instance’s CPU configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better CPU performance. This is identified by analyzing the `CPUUtilization` metric of the current instance during the look-back period.
     * + **`MemoryOverprovisioned`** — The instance’s memory configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the memory utilization metric of the current instance during the look-back period.
     * + **`MemoryUnderprovisioned`** — The instance’s memory configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better memory performance. This is identified by analyzing the memory utilization metric of the current instance during the look-back period.Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling memory utilization with the Amazon CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent) in the *Compute Optimizer User Guide*. On Linux instances, Compute Optimizer analyses the `mem_used_percent` metric in the `CWAgent` namespace, or the legacy `MemoryUtilization` metric in the `System/Linux` namespace. On Windows instances, Compute Optimizer analyses the `Memory % Committed Bytes In Use` metric in the `CWAgent` namespace.
     * + **`EBSThroughputOverprovisioned`** — The instance’s EBS throughput configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `VolumeReadOps` and `VolumeWriteOps` metrics of EBS volumes attached to the current instance during the look-back period.
     * + **`EBSThroughputUnderprovisioned`** — The instance’s EBS throughput configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better EBS throughput performance. This is identified by analyzing the `VolumeReadOps` and `VolumeWriteOps` metrics of EBS volumes attached to the current instance during the look-back period.
     * + **`EBSIOPSOverprovisioned`** — The instance’s EBS IOPS configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `VolumeReadBytes` and `VolumeWriteBytes` metric of EBS volumes attached to the current instance during the look-back period.
     * + **`EBSIOPSUnderprovisioned`** — The instance’s EBS IOPS configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS performance. This is identified by analyzing the `VolumeReadBytes` and `VolumeWriteBytes` metric of EBS volumes attached to the current instance during the look-back period.
     * + **`NetworkBandwidthOverprovisioned`** — The instance’s network bandwidth configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `NetworkIn` and `NetworkOut` metrics of the current instance during the look-back period.
     * + **`NetworkBandwidthUnderprovisioned`** — The instance’s network bandwidth configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better network bandwidth performance. This is identified by analyzing the `NetworkIn` and `NetworkOut` metrics of the current instance during the look-back period. This finding reason happens when the `NetworkIn` or `NetworkOut` performance of an instance is impacted.
     * + **`NetworkPPSOverprovisioned`** — The instance’s network PPS (packets per second) configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `NetworkPacketsIn` and `NetworkPacketsIn` metrics of the current instance during the look-back period.
     * + **`NetworkPPSUnderprovisioned`** — The instance’s network PPS (packets per second) configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better network PPS performance. This is identified by analyzing the `NetworkPacketsIn` and `NetworkPacketsIn` metrics of the current instance during the look-back period.
     * + **`DiskIOPSOverprovisioned`** — The instance’s disk IOPS configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `DiskReadOps` and `DiskWriteOps` metrics of the current instance during the look-back period.
     * + **`DiskIOPSUnderprovisioned`** — The instance’s disk IOPS configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better disk IOPS performance. This is identified by analyzing the `DiskReadOps` and `DiskWriteOps` metrics of the current instance during the look-back period.
     * + **`DiskThroughputOverprovisioned`** — The instance’s disk throughput configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `DiskReadBytes` and `DiskWriteBytes` metrics of the current instance during the look-back period.
     * + **`DiskThroughputUnderprovisioned`** — The instance’s disk throughput configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better disk throughput performance. This is identified by analyzing the `DiskReadBytes` and `DiskWriteBytes` metrics of the current instance during the look-back period.
     *
     * For more information about instance metrics, see [List the available CloudWatch metrics for your instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html) in the *Amazon Elastic Compute Cloud User Guide*. For more information about EBS volume metrics, see [Amazon CloudWatch metrics for Amazon EBS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    public val findingReasonCodes: List<InstanceRecommendationFindingReasonCode>? = builder.findingReasonCodes
    /**
     * The applications that might be running on the instance as inferred by Compute Optimizer.
     *
     * Compute Optimizer can infer if one of the following applications might be running on the instance:
     * + `AmazonEmr` - Infers that Amazon EMR might be running on the instance.
     * + `ApacheCassandra` - Infers that Apache Cassandra might be running on the instance.
     * + `ApacheHadoop` - Infers that Apache Hadoop might be running on the instance.
     * + `Memcached` - Infers that Memcached might be running on the instance.
     * + `NGINX` - Infers that NGINX might be running on the instance.
     * + `PostgreSql` - Infers that PostgreSQL might be running on the instance.
     * + `Redis` - Infers that Redis might be running on the instance.
     */
    public val inferredWorkloadTypes: List<InferredWorkloadType>? = builder.inferredWorkloadTypes
    /**
     * The Amazon Resource Name (ARN) of the current instance.
     */
    public val instanceArn: kotlin.String? = builder.instanceArn
    /**
     * The name of the current instance.
     */
    public val instanceName: kotlin.String? = builder.instanceName
    /**
     * The timestamp of when the instance recommendation was last generated.
     */
    public val lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRefreshTimestamp
    /**
     * The number of days for which utilization metrics were analyzed for the instance.
     */
    public val lookBackPeriodInDays: kotlin.Double = builder.lookBackPeriodInDays
    /**
     * An array of objects that describe the recommendation options for the instance.
     */
    public val recommendationOptions: List<InstanceRecommendationOption>? = builder.recommendationOptions
    /**
     * An array of objects that describe the source resource of the recommendation.
     */
    public val recommendationSources: List<RecommendationSource>? = builder.recommendationSources
    /**
     * An array of objects that describe the utilization metrics of the instance.
     */
    public val utilizationMetrics: List<UtilizationMetric>? = builder.utilizationMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceRecommendation(")
        append("accountId=$accountId,")
        append("currentInstanceType=$currentInstanceType,")
        append("currentPerformanceRisk=$currentPerformanceRisk,")
        append("effectiveRecommendationPreferences=$effectiveRecommendationPreferences,")
        append("finding=$finding,")
        append("findingReasonCodes=$findingReasonCodes,")
        append("inferredWorkloadTypes=$inferredWorkloadTypes,")
        append("instanceArn=$instanceArn,")
        append("instanceName=$instanceName,")
        append("lastRefreshTimestamp=$lastRefreshTimestamp,")
        append("lookBackPeriodInDays=$lookBackPeriodInDays,")
        append("recommendationOptions=$recommendationOptions,")
        append("recommendationSources=$recommendationSources,")
        append("utilizationMetrics=$utilizationMetrics)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (currentInstanceType?.hashCode() ?: 0)
        result = 31 * result + (currentPerformanceRisk?.hashCode() ?: 0)
        result = 31 * result + (effectiveRecommendationPreferences?.hashCode() ?: 0)
        result = 31 * result + (finding?.hashCode() ?: 0)
        result = 31 * result + (findingReasonCodes?.hashCode() ?: 0)
        result = 31 * result + (inferredWorkloadTypes?.hashCode() ?: 0)
        result = 31 * result + (instanceArn?.hashCode() ?: 0)
        result = 31 * result + (instanceName?.hashCode() ?: 0)
        result = 31 * result + (lastRefreshTimestamp?.hashCode() ?: 0)
        result = 31 * result + (lookBackPeriodInDays.hashCode())
        result = 31 * result + (recommendationOptions?.hashCode() ?: 0)
        result = 31 * result + (recommendationSources?.hashCode() ?: 0)
        result = 31 * result + (utilizationMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceRecommendation

        if (accountId != other.accountId) return false
        if (currentInstanceType != other.currentInstanceType) return false
        if (currentPerformanceRisk != other.currentPerformanceRisk) return false
        if (effectiveRecommendationPreferences != other.effectiveRecommendationPreferences) return false
        if (finding != other.finding) return false
        if (findingReasonCodes != other.findingReasonCodes) return false
        if (inferredWorkloadTypes != other.inferredWorkloadTypes) return false
        if (instanceArn != other.instanceArn) return false
        if (instanceName != other.instanceName) return false
        if (lastRefreshTimestamp != other.lastRefreshTimestamp) return false
        if (lookBackPeriodInDays != other.lookBackPeriodInDays) return false
        if (recommendationOptions != other.recommendationOptions) return false
        if (recommendationSources != other.recommendationSources) return false
        if (utilizationMetrics != other.utilizationMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID of the instance.
         */
        public var accountId: kotlin.String? = null
        /**
         * The instance type of the current instance.
         */
        public var currentInstanceType: kotlin.String? = null
        /**
         * The risk of the current instance not meeting the performance needs of its workloads. The higher the risk, the more likely the current instance cannot meet the performance requirements of its workload.
         */
        public var currentPerformanceRisk: aws.sdk.kotlin.services.computeoptimizer.model.CurrentPerformanceRisk? = null
        /**
         * An object that describes the effective recommendation preferences for the instance.
         */
        public var effectiveRecommendationPreferences: aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences? = null
        /**
         * The finding classification of the instance.
         *
         * Findings for instances include:
         * + **`Underprovisioned`**—An instance is considered under-provisioned when at least one specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of your workload. Under-provisioned instances may lead to poor application performance.
         * + **`Overprovisioned`**—An instance is considered over-provisioned when at least one specification of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to unnecessary infrastructure cost.
         * + **`Optimized`**—An instance is considered optimized when all specifications of your instance, such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned. For optimized resources, Compute Optimizer might recommend a new generation instance type.
         */
        public var finding: aws.sdk.kotlin.services.computeoptimizer.model.Finding? = null
        /**
         * The reason for the finding classification of the instance.
         *
         * Finding reason codes for instances include:
         * + **`CPUOverprovisioned`** — The instance’s CPU configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `CPUUtilization` metric of the current instance during the look-back period.
         * + **`CPUUnderprovisioned`** — The instance’s CPU configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better CPU performance. This is identified by analyzing the `CPUUtilization` metric of the current instance during the look-back period.
         * + **`MemoryOverprovisioned`** — The instance’s memory configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the memory utilization metric of the current instance during the look-back period.
         * + **`MemoryUnderprovisioned`** — The instance’s memory configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better memory performance. This is identified by analyzing the memory utilization metric of the current instance during the look-back period.Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling memory utilization with the Amazon CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent) in the *Compute Optimizer User Guide*. On Linux instances, Compute Optimizer analyses the `mem_used_percent` metric in the `CWAgent` namespace, or the legacy `MemoryUtilization` metric in the `System/Linux` namespace. On Windows instances, Compute Optimizer analyses the `Memory % Committed Bytes In Use` metric in the `CWAgent` namespace.
         * + **`EBSThroughputOverprovisioned`** — The instance’s EBS throughput configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `VolumeReadOps` and `VolumeWriteOps` metrics of EBS volumes attached to the current instance during the look-back period.
         * + **`EBSThroughputUnderprovisioned`** — The instance’s EBS throughput configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better EBS throughput performance. This is identified by analyzing the `VolumeReadOps` and `VolumeWriteOps` metrics of EBS volumes attached to the current instance during the look-back period.
         * + **`EBSIOPSOverprovisioned`** — The instance’s EBS IOPS configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `VolumeReadBytes` and `VolumeWriteBytes` metric of EBS volumes attached to the current instance during the look-back period.
         * + **`EBSIOPSUnderprovisioned`** — The instance’s EBS IOPS configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS performance. This is identified by analyzing the `VolumeReadBytes` and `VolumeWriteBytes` metric of EBS volumes attached to the current instance during the look-back period.
         * + **`NetworkBandwidthOverprovisioned`** — The instance’s network bandwidth configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `NetworkIn` and `NetworkOut` metrics of the current instance during the look-back period.
         * + **`NetworkBandwidthUnderprovisioned`** — The instance’s network bandwidth configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better network bandwidth performance. This is identified by analyzing the `NetworkIn` and `NetworkOut` metrics of the current instance during the look-back period. This finding reason happens when the `NetworkIn` or `NetworkOut` performance of an instance is impacted.
         * + **`NetworkPPSOverprovisioned`** — The instance’s network PPS (packets per second) configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `NetworkPacketsIn` and `NetworkPacketsIn` metrics of the current instance during the look-back period.
         * + **`NetworkPPSUnderprovisioned`** — The instance’s network PPS (packets per second) configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better network PPS performance. This is identified by analyzing the `NetworkPacketsIn` and `NetworkPacketsIn` metrics of the current instance during the look-back period.
         * + **`DiskIOPSOverprovisioned`** — The instance’s disk IOPS configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `DiskReadOps` and `DiskWriteOps` metrics of the current instance during the look-back period.
         * + **`DiskIOPSUnderprovisioned`** — The instance’s disk IOPS configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better disk IOPS performance. This is identified by analyzing the `DiskReadOps` and `DiskWriteOps` metrics of the current instance during the look-back period.
         * + **`DiskThroughputOverprovisioned`** — The instance’s disk throughput configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the `DiskReadBytes` and `DiskWriteBytes` metrics of the current instance during the look-back period.
         * + **`DiskThroughputUnderprovisioned`** — The instance’s disk throughput configuration doesn't meet the performance requirements of your workload and there is an alternative instance type that provides better disk throughput performance. This is identified by analyzing the `DiskReadBytes` and `DiskWriteBytes` metrics of the current instance during the look-back period.
         *
         * For more information about instance metrics, see [List the available CloudWatch metrics for your instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html) in the *Amazon Elastic Compute Cloud User Guide*. For more information about EBS volume metrics, see [Amazon CloudWatch metrics for Amazon EBS](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        public var findingReasonCodes: List<InstanceRecommendationFindingReasonCode>? = null
        /**
         * The applications that might be running on the instance as inferred by Compute Optimizer.
         *
         * Compute Optimizer can infer if one of the following applications might be running on the instance:
         * + `AmazonEmr` - Infers that Amazon EMR might be running on the instance.
         * + `ApacheCassandra` - Infers that Apache Cassandra might be running on the instance.
         * + `ApacheHadoop` - Infers that Apache Hadoop might be running on the instance.
         * + `Memcached` - Infers that Memcached might be running on the instance.
         * + `NGINX` - Infers that NGINX might be running on the instance.
         * + `PostgreSql` - Infers that PostgreSQL might be running on the instance.
         * + `Redis` - Infers that Redis might be running on the instance.
         */
        public var inferredWorkloadTypes: List<InferredWorkloadType>? = null
        /**
         * The Amazon Resource Name (ARN) of the current instance.
         */
        public var instanceArn: kotlin.String? = null
        /**
         * The name of the current instance.
         */
        public var instanceName: kotlin.String? = null
        /**
         * The timestamp of when the instance recommendation was last generated.
         */
        public var lastRefreshTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of days for which utilization metrics were analyzed for the instance.
         */
        public var lookBackPeriodInDays: kotlin.Double = 0.0
        /**
         * An array of objects that describe the recommendation options for the instance.
         */
        public var recommendationOptions: List<InstanceRecommendationOption>? = null
        /**
         * An array of objects that describe the source resource of the recommendation.
         */
        public var recommendationSources: List<RecommendationSource>? = null
        /**
         * An array of objects that describe the utilization metrics of the instance.
         */
        public var utilizationMetrics: List<UtilizationMetric>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendation) : this() {
            this.accountId = x.accountId
            this.currentInstanceType = x.currentInstanceType
            this.currentPerformanceRisk = x.currentPerformanceRisk
            this.effectiveRecommendationPreferences = x.effectiveRecommendationPreferences
            this.finding = x.finding
            this.findingReasonCodes = x.findingReasonCodes
            this.inferredWorkloadTypes = x.inferredWorkloadTypes
            this.instanceArn = x.instanceArn
            this.instanceName = x.instanceName
            this.lastRefreshTimestamp = x.lastRefreshTimestamp
            this.lookBackPeriodInDays = x.lookBackPeriodInDays
            this.recommendationOptions = x.recommendationOptions
            this.recommendationSources = x.recommendationSources
            this.utilizationMetrics = x.utilizationMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.InstanceRecommendation = InstanceRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences] inside the given [block]
         */
        public fun effectiveRecommendationPreferences(block: aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences.Builder.() -> kotlin.Unit) {
            this.effectiveRecommendationPreferences = aws.sdk.kotlin.services.computeoptimizer.model.EffectiveRecommendationPreferences.invoke(block)
        }
    }
}
