// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a utilization metric of a resource, such as an Amazon EC2 instance.
 *
 * Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.
 */
public class UtilizationMetric private constructor(builder: Builder) {
    /**
     * The name of the utilization metric.
     *
     * The following utilization metrics are available:
     * + `Cpu` - The percentage of allocated EC2 compute units that are currently in use on the instance. This metric identifies the processing power required to run an application on the instance.Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when the instance is not allocated a full processor core.Units: Percent
     * + `Memory` - The percentage of memory that is currently in use on the instance. This metric identifies the amount of memory required to run an application on the instance.Units: PercentThe `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
     * + `EBS_READ_OPS_PER_SECOND` - The completed read operations from all EBS volumes attached to the instance in a specified period of time.Unit: Count
     * + `EBS_WRITE_OPS_PER_SECOND` - The completed write operations to all EBS volumes attached to the instance in a specified period of time.Unit: Count
     * + `EBS_READ_BYTES_PER_SECOND` - The bytes read from all EBS volumes attached to the instance in a specified period of time.Unit: Bytes
     * + `EBS_WRITE_BYTES_PER_SECOND` - The bytes written to all EBS volumes attached to the instance in a specified period of time.Unit: Bytes
     * + `DISK_READ_OPS_PER_SECOND` - The completed read operations from all instance store volumes available to the instance in a specified period of time.If there are no instance store volumes, either the value is `0` or the metric is not reported.
     * + `DISK_WRITE_OPS_PER_SECOND` - The completed write operations from all instance store volumes available to the instance in a specified period of time.If there are no instance store volumes, either the value is `0` or the metric is not reported.
     * + `DISK_READ_BYTES_PER_SECOND` - The bytes read from all instance store volumes available to the instance. This metric is used to determine the volume of the data the application reads from the disk of the instance. This can be used to determine the speed of the application.If there are no instance store volumes, either the value is `0` or the metric is not reported.
     * + `DISK_WRITE_BYTES_PER_SECOND` - The bytes written to all instance store volumes available to the instance. This metric is used to determine the volume of the data the application writes onto the disk of the instance. This can be used to determine the speed of the application.If there are no instance store volumes, either the value is `0` or the metric is not reported.
     * + `NETWORK_IN_BYTES_PER_SECOND` - The number of bytes received by the instance on all network interfaces. This metric identifies the volume of incoming network traffic to a single instance.
     * + `NETWORK_OUT_BYTES_PER_SECOND` - The number of bytes sent out by the instance on all network interfaces. This metric identifies the volume of outgoing network traffic from a single instance.
     * + `NETWORK_PACKETS_IN_PER_SECOND` - The number of packets received by the instance on all network interfaces. This metric identifies the volume of incoming traffic in terms of the number of packets on a single instance.
     * + `NETWORK_PACKETS_OUT_PER_SECOND` - The number of packets sent out by the instance on all network interfaces. This metric identifies the volume of outgoing traffic in terms of the number of packets on a single instance.
     */
    public val name: aws.sdk.kotlin.services.computeoptimizer.model.MetricName? = builder.name
    /**
     * The statistic of the utilization metric.
     *
     * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the `Maximum` statistic, which is the highest value observed during the specified period.
     *
     * The Compute Optimizer console displays graphs for some utilization metrics using the `Average` statistic, which is the value of `Sum` / `SampleCount` during the specified period. For more information, see [Viewing resource recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html) in the *Compute Optimizer User Guide*. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
     */
    public val statistic: aws.sdk.kotlin.services.computeoptimizer.model.MetricStatistic? = builder.statistic
    /**
     * The value of the utilization metric.
     */
    public val value: kotlin.Double = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.UtilizationMetric = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UtilizationMetric(")
        append("name=$name,")
        append("statistic=$statistic,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (statistic?.hashCode() ?: 0)
        result = 31 * result + (value.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UtilizationMetric

        if (name != other.name) return false
        if (statistic != other.statistic) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.UtilizationMetric = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the utilization metric.
         *
         * The following utilization metrics are available:
         * + `Cpu` - The percentage of allocated EC2 compute units that are currently in use on the instance. This metric identifies the processing power required to run an application on the instance.Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when the instance is not allocated a full processor core.Units: Percent
         * + `Memory` - The percentage of memory that is currently in use on the instance. This metric identifies the amount of memory required to run an application on the instance.Units: PercentThe `Memory` metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see [Enabling Memory Utilization with the CloudWatch Agent](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent).
         * + `EBS_READ_OPS_PER_SECOND` - The completed read operations from all EBS volumes attached to the instance in a specified period of time.Unit: Count
         * + `EBS_WRITE_OPS_PER_SECOND` - The completed write operations to all EBS volumes attached to the instance in a specified period of time.Unit: Count
         * + `EBS_READ_BYTES_PER_SECOND` - The bytes read from all EBS volumes attached to the instance in a specified period of time.Unit: Bytes
         * + `EBS_WRITE_BYTES_PER_SECOND` - The bytes written to all EBS volumes attached to the instance in a specified period of time.Unit: Bytes
         * + `DISK_READ_OPS_PER_SECOND` - The completed read operations from all instance store volumes available to the instance in a specified period of time.If there are no instance store volumes, either the value is `0` or the metric is not reported.
         * + `DISK_WRITE_OPS_PER_SECOND` - The completed write operations from all instance store volumes available to the instance in a specified period of time.If there are no instance store volumes, either the value is `0` or the metric is not reported.
         * + `DISK_READ_BYTES_PER_SECOND` - The bytes read from all instance store volumes available to the instance. This metric is used to determine the volume of the data the application reads from the disk of the instance. This can be used to determine the speed of the application.If there are no instance store volumes, either the value is `0` or the metric is not reported.
         * + `DISK_WRITE_BYTES_PER_SECOND` - The bytes written to all instance store volumes available to the instance. This metric is used to determine the volume of the data the application writes onto the disk of the instance. This can be used to determine the speed of the application.If there are no instance store volumes, either the value is `0` or the metric is not reported.
         * + `NETWORK_IN_BYTES_PER_SECOND` - The number of bytes received by the instance on all network interfaces. This metric identifies the volume of incoming network traffic to a single instance.
         * + `NETWORK_OUT_BYTES_PER_SECOND` - The number of bytes sent out by the instance on all network interfaces. This metric identifies the volume of outgoing network traffic from a single instance.
         * + `NETWORK_PACKETS_IN_PER_SECOND` - The number of packets received by the instance on all network interfaces. This metric identifies the volume of incoming traffic in terms of the number of packets on a single instance.
         * + `NETWORK_PACKETS_OUT_PER_SECOND` - The number of packets sent out by the instance on all network interfaces. This metric identifies the volume of outgoing traffic in terms of the number of packets on a single instance.
         */
        public var name: aws.sdk.kotlin.services.computeoptimizer.model.MetricName? = null
        /**
         * The statistic of the utilization metric.
         *
         * The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the `Maximum` statistic, which is the highest value observed during the specified period.
         *
         * The Compute Optimizer console displays graphs for some utilization metrics using the `Average` statistic, which is the value of `Sum` / `SampleCount` during the specified period. For more information, see [Viewing resource recommendations](https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html) in the *Compute Optimizer User Guide*. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
         */
        public var statistic: aws.sdk.kotlin.services.computeoptimizer.model.MetricStatistic? = null
        /**
         * The value of the utilization metric.
         */
        public var value: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.UtilizationMetric) : this() {
            this.name = x.name
            this.statistic = x.statistic
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.UtilizationMetric = UtilizationMetric(this)
    }
}
