// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.model



/**
 * Describes a recommendation option for an Amazon Elastic Block Store (Amazon EBS) instance.
 */
public class VolumeRecommendationOption private constructor(builder: Builder) {
    /**
     * An array of objects that describe a volume configuration.
     */
    public val configuration: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration? = builder.configuration
    /**
     * The performance risk of the volume recommendation option.
     *
     * Performance risk is the likelihood of the recommended volume type meeting the performance requirement of your workload.
     *
     * The value ranges from `0` - `4`, with `0` meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.
     */
    public val performanceRisk: kotlin.Double = builder.performanceRisk
    /**
     * The rank of the volume recommendation option.
     *
     * The top recommendation option is ranked as `1`.
     */
    public val rank: kotlin.Int = builder.rank
    /**
     * An object that describes the savings opportunity for the EBS volume recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.
     */
    public val savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = builder.savingsOpportunity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeRecommendationOption(")
        append("configuration=$configuration,")
        append("performanceRisk=$performanceRisk,")
        append("rank=$rank,")
        append("savingsOpportunity=$savingsOpportunity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (performanceRisk.hashCode())
        result = 31 * result + (rank)
        result = 31 * result + (savingsOpportunity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VolumeRecommendationOption

        if (configuration != other.configuration) return false
        if (performanceRisk != other.performanceRisk) return false
        if (rank != other.rank) return false
        if (savingsOpportunity != other.savingsOpportunity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendationOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of objects that describe a volume configuration.
         */
        public var configuration: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration? = null
        /**
         * The performance risk of the volume recommendation option.
         *
         * Performance risk is the likelihood of the recommended volume type meeting the performance requirement of your workload.
         *
         * The value ranges from `0` - `4`, with `0` meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.
         */
        public var performanceRisk: kotlin.Double = 0.0
        /**
         * The rank of the volume recommendation option.
         *
         * The top recommendation option is ranked as `1`.
         */
        public var rank: kotlin.Int = 0
        /**
         * An object that describes the savings opportunity for the EBS volume recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.
         */
        public var savingsOpportunity: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendationOption) : this() {
            this.configuration = x.configuration
            this.performanceRisk = x.performanceRisk
            this.rank = x.rank
            this.savingsOpportunity = x.savingsOpportunity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.computeoptimizer.model.VolumeRecommendationOption = VolumeRecommendationOption(this)

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.computeoptimizer.model.VolumeConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity] inside the given [block]
         */
        public fun savingsOpportunity(block: aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.Builder.() -> kotlin.Unit) {
            this.savingsOpportunity = aws.sdk.kotlin.services.computeoptimizer.model.SavingsOpportunity.invoke(block)
        }
    }
}
