// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.endpoints.internal

import aws.sdk.kotlin.runtime.endpoint.applyToRequest
import aws.sdk.kotlin.runtime.endpoint.authScheme
import aws.sdk.kotlin.services.computeoptimizer.ComputeOptimizerClient
import aws.sdk.kotlin.services.computeoptimizer.endpoints.EndpointParameters
import aws.sdk.kotlin.services.computeoptimizer.endpoints.EndpointProvider
import aws.smithy.kotlin.runtime.http.endpoints.Endpoint
import aws.smithy.kotlin.runtime.http.endpoints.setResolvedEndpoint
import aws.smithy.kotlin.runtime.http.operation.InlineMiddleware
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation

internal class ResolveEndpointMiddleware<I, O>(
    private val endpointProvider: EndpointProvider,
    private val buildParams: EndpointParameters.Builder.(input: I) -> Unit,
) : InlineMiddleware<I, O> {
    private lateinit var endpoint: Endpoint

    override fun install(op: SdkHttpOperation<I, O>) {
        op.execution.initialize.intercept { req, next ->
            val params = EndpointParameters { buildParams(req.subject) }
            endpoint = endpointProvider.resolveEndpoint(params)
            next.call(req)
        }

        op.execution.mutate.intercept { req, next ->
            setResolvedEndpoint(req, endpoint)
            endpoint.authScheme?.applyToRequest(req)
            next.call(req)
        }
    }
}

internal fun EndpointParameters.Builder.bindAwsBuiltins(config: ComputeOptimizerClient.Config) {
    region = config.region
    useDualStack = config.useDualStack
    useFips = config.useFips
    endpoint = config.endpointUrl?.toString()
}
