// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.computeoptimizer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.computeoptimizer.model.ComputeOptimizerException
import aws.sdk.kotlin.services.computeoptimizer.model.EnhancedInfrastructureMetrics
import aws.sdk.kotlin.services.computeoptimizer.model.ExternalMetricsPreference
import aws.sdk.kotlin.services.computeoptimizer.model.GetEffectiveRecommendationPreferencesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetEffectiveRecommendationPreferencesOperationDeserializer: HttpDeserialize<GetEffectiveRecommendationPreferencesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetEffectiveRecommendationPreferencesResponse {
        if (!response.status.isSuccess()) {
            throwGetEffectiveRecommendationPreferencesError(context, response)
        }
        val builder = GetEffectiveRecommendationPreferencesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetEffectiveRecommendationPreferencesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetEffectiveRecommendationPreferencesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ComputeOptimizerException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingAuthenticationToken" -> MissingAuthenticationTokenDeserializer().deserialize(context, wrappedResponse)
        "OptInRequiredException" -> OptInRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ComputeOptimizerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetEffectiveRecommendationPreferencesOperationBody(builder: GetEffectiveRecommendationPreferencesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENHANCEDINFRASTRUCTUREMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("enhancedInfrastructureMetrics"))
    val EXTERNALMETRICSPREFERENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("externalMetricsPreference"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENHANCEDINFRASTRUCTUREMETRICS_DESCRIPTOR)
        field(EXTERNALMETRICSPREFERENCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENHANCEDINFRASTRUCTUREMETRICS_DESCRIPTOR.index -> builder.enhancedInfrastructureMetrics = deserializeString().let { EnhancedInfrastructureMetrics.fromValue(it) }
                EXTERNALMETRICSPREFERENCE_DESCRIPTOR.index -> builder.externalMetricsPreference = deserializeExternalMetricsPreferenceDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
