// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.connect.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.connect.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Connect is a cloud-based contact center solution that you use to set up and manage a customer contact center and provide reliable customer engagement at any scale.
 *
 * Amazon Connect provides metrics and real-time reporting that enable you to optimize contact routing. You can also resolve customer issues more efficiently by getting customers in touch with the appropriate agents.
 *
 * There are limits to the number of Amazon Connect resources that you can create. There are also limits to the number of requests that you can make per second. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
 *
 * You can connect programmatically to an Amazon Web Services service by using an endpoint. For a list of Amazon Connect endpoints, see [Amazon Connect Endpoints](https://docs.aws.amazon.com/general/latest/gr/connect_region.html).
 *
 * Working with contact flows? Check out the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
 */
interface ConnectClient : SdkClient {

    override val serviceName: String
        get() = "Connect"
    /**
     * ConnectClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ConnectClient {
            val config = Config.Builder().apply(block).build()
            return DefaultConnectClient(config)
        }

        operator fun invoke(config: Config): ConnectClient = DefaultConnectClient(config)

        /**
         * Construct a [ConnectClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ConnectClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultConnectClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates an approved origin to an Amazon Connect instance.
     */
    suspend fun associateApprovedOrigin(input: AssociateApprovedOriginRequest): AssociateApprovedOriginResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates an approved origin to an Amazon Connect instance.
     */
    suspend fun associateApprovedOrigin(block: AssociateApprovedOriginRequest.Builder.() -> Unit) = associateApprovedOrigin(AssociateApprovedOriginRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    suspend fun associateBot(input: AssociateBotRequest): AssociateBotResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    suspend fun associateBot(block: AssociateBotRequest.Builder.() -> Unit) = associateBot(AssociateBotRequest.Builder().apply(block).build())

    /**
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.
     */
    suspend fun associateDefaultVocabulary(input: AssociateDefaultVocabularyRequest): AssociateDefaultVocabularyResponse

    /**
     * Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.
     */
    suspend fun associateDefaultVocabulary(block: AssociateDefaultVocabularyRequest.Builder.() -> Unit) = associateDefaultVocabulary(AssociateDefaultVocabularyRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing chat transcripts.
     *
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     */
    suspend fun associateInstanceStorageConfig(input: AssociateInstanceStorageConfigRequest): AssociateInstanceStorageConfigResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can't define an instance with multiple S3 buckets for storing chat transcripts.
     *
     * This API does not create a resource that doesn't exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.
     */
    suspend fun associateInstanceStorageConfig(block: AssociateInstanceStorageConfigRequest.Builder.() -> Unit) = associateInstanceStorageConfig(AssociateInstanceStorageConfigRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     */
    suspend fun associateLambdaFunction(input: AssociateLambdaFunctionRequest): AssociateLambdaFunctionResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Lambda function.
     */
    suspend fun associateLambdaFunction(block: AssociateLambdaFunctionRequest.Builder.() -> Unit) = associateLambdaFunction(AssociateLambdaFunctionRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex bot.
     */
    suspend fun associateLexBot(input: AssociateLexBotRequest): AssociateLexBotResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Allows the specified Amazon Connect instance to access the specified Amazon Lex bot.
     */
    suspend fun associateLexBot(block: AssociateLexBotRequest.Builder.() -> Unit) = associateLexBot(AssociateLexBotRequest.Builder().apply(block).build())

    /**
     * Associates a contact flow with a phone number claimed to your Amazon Connect instance.
     */
    suspend fun associatePhoneNumberContactFlow(input: AssociatePhoneNumberContactFlowRequest): AssociatePhoneNumberContactFlowResponse

    /**
     * Associates a contact flow with a phone number claimed to your Amazon Connect instance.
     */
    suspend fun associatePhoneNumberContactFlow(block: AssociatePhoneNumberContactFlowRequest.Builder.() -> Unit) = associatePhoneNumberContactFlow(AssociatePhoneNumberContactFlowRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a set of quick connects with a queue.
     */
    suspend fun associateQueueQuickConnects(input: AssociateQueueQuickConnectsRequest): AssociateQueueQuickConnectsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a set of quick connects with a queue.
     */
    suspend fun associateQueueQuickConnects(block: AssociateQueueQuickConnectsRequest.Builder.() -> Unit) = associateQueueQuickConnects(AssociateQueueQuickConnectsRequest.Builder().apply(block).build())

    /**
     * Associates a set of queues with a routing profile.
     */
    suspend fun associateRoutingProfileQueues(input: AssociateRoutingProfileQueuesRequest): AssociateRoutingProfileQueuesResponse

    /**
     * Associates a set of queues with a routing profile.
     */
    suspend fun associateRoutingProfileQueues(block: AssociateRoutingProfileQueuesRequest.Builder.() -> Unit) = associateRoutingProfileQueues(AssociateRoutingProfileQueuesRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a security key to the instance.
     */
    suspend fun associateSecurityKey(input: AssociateSecurityKeyRequest): AssociateSecurityKeyResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Associates a security key to the instance.
     */
    suspend fun associateSecurityKey(block: AssociateSecurityKeyRequest.Builder.() -> Unit) = associateSecurityKey(AssociateSecurityKeyRequest.Builder().apply(block).build())

    /**
     * Claims an available phone number to your Amazon Connect instance.
     */
    suspend fun claimPhoneNumber(input: ClaimPhoneNumberRequest): ClaimPhoneNumberResponse

    /**
     * Claims an available phone number to your Amazon Connect instance.
     */
    suspend fun claimPhoneNumber(block: ClaimPhoneNumberRequest.Builder.() -> Unit) = claimPhoneNumber(ClaimPhoneNumberRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates an agent status for the specified Amazon Connect instance.
     */
    suspend fun createAgentStatus(input: CreateAgentStatusRequest): CreateAgentStatusResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates an agent status for the specified Amazon Connect instance.
     */
    suspend fun createAgentStatus(block: CreateAgentStatusRequest.Builder.() -> Unit) = createAgentStatus(CreateAgentStatusRequest.Builder().apply(block).build())

    /**
     * Creates a contact flow for the specified Amazon Connect instance.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     */
    suspend fun createContactFlow(input: CreateContactFlowRequest): CreateContactFlowResponse

    /**
     * Creates a contact flow for the specified Amazon Connect instance.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     */
    suspend fun createContactFlow(block: CreateContactFlowRequest.Builder.() -> Unit) = createContactFlow(CreateContactFlowRequest.Builder().apply(block).build())

    /**
     * Creates a contact flow module for the specified Amazon Connect instance.
     */
    suspend fun createContactFlowModule(input: CreateContactFlowModuleRequest): CreateContactFlowModuleResponse

    /**
     * Creates a contact flow module for the specified Amazon Connect instance.
     */
    suspend fun createContactFlowModule(block: CreateContactFlowModuleRequest.Builder.() -> Unit) = createContactFlowModule(CreateContactFlowModuleRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates hours of operation.
     */
    suspend fun createHoursOfOperation(input: CreateHoursOfOperationRequest): CreateHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates hours of operation.
     */
    suspend fun createHoursOfOperation(block: CreateHoursOfOperationRequest.Builder.() -> Unit) = createHoursOfOperation(CreateHoursOfOperationRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    suspend fun createInstance(input: CreateInstanceRequest): CreateInstanceResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    suspend fun createInstance(block: CreateInstanceRequest.Builder.() -> Unit) = createInstance(CreateInstanceRequest.Builder().apply(block).build())

    /**
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     */
    suspend fun createIntegrationAssociation(input: CreateIntegrationAssociationRequest): CreateIntegrationAssociationResponse

    /**
     * Creates an Amazon Web Services resource association with an Amazon Connect instance.
     */
    suspend fun createIntegrationAssociation(block: CreateIntegrationAssociationRequest.Builder.() -> Unit) = createIntegrationAssociation(CreateIntegrationAssociationRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates a new queue for the specified Amazon Connect instance.
     */
    suspend fun createQueue(input: CreateQueueRequest): CreateQueueResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates a new queue for the specified Amazon Connect instance.
     */
    suspend fun createQueue(block: CreateQueueRequest.Builder.() -> Unit) = createQueue(CreateQueueRequest.Builder().apply(block).build())

    /**
     * Creates a quick connect for the specified Amazon Connect instance.
     */
    suspend fun createQuickConnect(input: CreateQuickConnectRequest): CreateQuickConnectResponse

    /**
     * Creates a quick connect for the specified Amazon Connect instance.
     */
    suspend fun createQuickConnect(block: CreateQuickConnectRequest.Builder.() -> Unit) = createQuickConnect(CreateQuickConnectRequest.Builder().apply(block).build())

    /**
     * Creates a new routing profile.
     */
    suspend fun createRoutingProfile(input: CreateRoutingProfileRequest): CreateRoutingProfileResponse

    /**
     * Creates a new routing profile.
     */
    suspend fun createRoutingProfile(block: CreateRoutingProfileRequest.Builder.() -> Unit) = createRoutingProfile(CreateRoutingProfileRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates a security profile.
     */
    suspend fun createSecurityProfile(input: CreateSecurityProfileRequest): CreateSecurityProfileResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Creates a security profile.
     */
    suspend fun createSecurityProfile(block: CreateSecurityProfileRequest.Builder.() -> Unit) = createSecurityProfile(CreateSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Creates a new task template in the specified Amazon Connect instance.
     */
    suspend fun createTaskTemplate(input: CreateTaskTemplateRequest): CreateTaskTemplateResponse

    /**
     * Creates a new task template in the specified Amazon Connect instance.
     */
    suspend fun createTaskTemplate(block: CreateTaskTemplateRequest.Builder.() -> Unit) = createTaskTemplate(CreateTaskTemplateRequest.Builder().apply(block).build())

    /**
     * Creates a use case for an integration association.
     */
    suspend fun createUseCase(input: CreateUseCaseRequest): CreateUseCaseResponse

    /**
     * Creates a use case for an integration association.
     */
    suspend fun createUseCase(block: CreateUseCaseRequest.Builder.() -> Unit) = createUseCase(CreateUseCaseRequest.Builder().apply(block).build())

    /**
     * Creates a user account for the specified Amazon Connect instance.
     *
     * For information about how to create user accounts using the Amazon Connect console, see [Add Users](https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Creates a user account for the specified Amazon Connect instance.
     *
     * For information about how to create user accounts using the Amazon Connect console, see [Add Users](https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun createUser(block: CreateUserRequest.Builder.() -> Unit) = createUser(CreateUserRequest.Builder().apply(block).build())

    /**
     * Creates a new user hierarchy group.
     */
    suspend fun createUserHierarchyGroup(input: CreateUserHierarchyGroupRequest): CreateUserHierarchyGroupResponse

    /**
     * Creates a new user hierarchy group.
     */
    suspend fun createUserHierarchyGroup(block: CreateUserHierarchyGroupRequest.Builder.() -> Unit) = createUserHierarchyGroup(CreateUserHierarchyGroupRequest.Builder().apply(block).build())

    /**
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.
     */
    suspend fun createVocabulary(input: CreateVocabularyRequest): CreateVocabularyResponse

    /**
     * Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.
     */
    suspend fun createVocabulary(block: CreateVocabularyRequest.Builder.() -> Unit) = createVocabulary(CreateVocabularyRequest.Builder().apply(block).build())

    /**
     * Deletes a contact flow for the specified Amazon Connect instance.
     */
    suspend fun deleteContactFlow(input: DeleteContactFlowRequest): DeleteContactFlowResponse

    /**
     * Deletes a contact flow for the specified Amazon Connect instance.
     */
    suspend fun deleteContactFlow(block: DeleteContactFlowRequest.Builder.() -> Unit) = deleteContactFlow(DeleteContactFlowRequest.Builder().apply(block).build())

    /**
     * Deletes the specified contact flow module.
     */
    suspend fun deleteContactFlowModule(input: DeleteContactFlowModuleRequest): DeleteContactFlowModuleResponse

    /**
     * Deletes the specified contact flow module.
     */
    suspend fun deleteContactFlowModule(block: DeleteContactFlowModuleRequest.Builder.() -> Unit) = deleteContactFlowModule(DeleteContactFlowModuleRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes an hours of operation.
     */
    suspend fun deleteHoursOfOperation(input: DeleteHoursOfOperationRequest): DeleteHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes an hours of operation.
     */
    suspend fun deleteHoursOfOperation(block: DeleteHoursOfOperationRequest.Builder.() -> Unit) = deleteHoursOfOperation(DeleteHoursOfOperationRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the Amazon Connect instance.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    suspend fun deleteInstance(input: DeleteInstanceRequest): DeleteInstanceResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the Amazon Connect instance.
     *
     * Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.
     */
    suspend fun deleteInstance(block: DeleteInstanceRequest.Builder.() -> Unit) = deleteInstance(DeleteInstanceRequest.Builder().apply(block).build())

    /**
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.
     */
    suspend fun deleteIntegrationAssociation(input: DeleteIntegrationAssociationRequest): DeleteIntegrationAssociationResponse

    /**
     * Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.
     */
    suspend fun deleteIntegrationAssociation(block: DeleteIntegrationAssociationRequest.Builder.() -> Unit) = deleteIntegrationAssociation(DeleteIntegrationAssociationRequest.Builder().apply(block).build())

    /**
     * Deletes a quick connect.
     */
    suspend fun deleteQuickConnect(input: DeleteQuickConnectRequest): DeleteQuickConnectResponse

    /**
     * Deletes a quick connect.
     */
    suspend fun deleteQuickConnect(block: DeleteQuickConnectRequest.Builder.() -> Unit) = deleteQuickConnect(DeleteQuickConnectRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes a security profile.
     */
    suspend fun deleteSecurityProfile(input: DeleteSecurityProfileRequest): DeleteSecurityProfileResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes a security profile.
     */
    suspend fun deleteSecurityProfile(block: DeleteSecurityProfileRequest.Builder.() -> Unit) = deleteSecurityProfile(DeleteSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Deletes the task template.
     */
    suspend fun deleteTaskTemplate(input: DeleteTaskTemplateRequest): DeleteTaskTemplateResponse

    /**
     * Deletes the task template.
     */
    suspend fun deleteTaskTemplate(block: DeleteTaskTemplateRequest.Builder.() -> Unit) = deleteTaskTemplate(DeleteTaskTemplateRequest.Builder().apply(block).build())

    /**
     * Deletes a use case from an integration association.
     */
    suspend fun deleteUseCase(input: DeleteUseCaseRequest): DeleteUseCaseResponse

    /**
     * Deletes a use case from an integration association.
     */
    suspend fun deleteUseCase(block: DeleteUseCaseRequest.Builder.() -> Unit) = deleteUseCase(DeleteUseCaseRequest.Builder().apply(block).build())

    /**
     * Deletes a user account from the specified Amazon Connect instance.
     *
     * For information about what happens to a user's data when their account is deleted, see [Delete Users from Your Amazon Connect Instance](https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes a user account from the specified Amazon Connect instance.
     *
     * For information about what happens to a user's data when their account is deleted, see [Delete Users from Your Amazon Connect Instance](https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun deleteUser(block: DeleteUserRequest.Builder.() -> Unit) = deleteUser(DeleteUserRequest.Builder().apply(block).build())

    /**
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.
     */
    suspend fun deleteUserHierarchyGroup(input: DeleteUserHierarchyGroupRequest): DeleteUserHierarchyGroupResponse

    /**
     * Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.
     */
    suspend fun deleteUserHierarchyGroup(block: DeleteUserHierarchyGroupRequest.Builder.() -> Unit) = deleteUserHierarchyGroup(DeleteUserHierarchyGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the vocabulary that has the given identifier.
     */
    suspend fun deleteVocabulary(input: DeleteVocabularyRequest): DeleteVocabularyResponse

    /**
     * Deletes the vocabulary that has the given identifier.
     */
    suspend fun deleteVocabulary(block: DeleteVocabularyRequest.Builder.() -> Unit) = deleteVocabulary(DeleteVocabularyRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes an agent status.
     */
    suspend fun describeAgentStatus(input: DescribeAgentStatusRequest): DescribeAgentStatusResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes an agent status.
     */
    suspend fun describeAgentStatus(block: DescribeAgentStatusRequest.Builder.() -> Unit) = describeAgentStatus(DescribeAgentStatusRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified contact.
     *
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     */
    suspend fun describeContact(input: DescribeContactRequest): DescribeContactResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified contact.
     *
     * Contact information remains available in Amazon Connect for 24 months, and then it is deleted.
     */
    suspend fun describeContact(block: DescribeContactRequest.Builder.() -> Unit) = describeContact(DescribeContactRequest.Builder().apply(block).build())

    /**
     * Describes the specified contact flow.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     */
    suspend fun describeContactFlow(input: DescribeContactFlowRequest): DescribeContactFlowResponse

    /**
     * Describes the specified contact flow.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     */
    suspend fun describeContactFlow(block: DescribeContactFlowRequest.Builder.() -> Unit) = describeContactFlow(DescribeContactFlowRequest.Builder().apply(block).build())

    /**
     * Describes the specified contact flow module.
     */
    suspend fun describeContactFlowModule(input: DescribeContactFlowModuleRequest): DescribeContactFlowModuleResponse

    /**
     * Describes the specified contact flow module.
     */
    suspend fun describeContactFlowModule(block: DescribeContactFlowModuleRequest.Builder.() -> Unit) = describeContactFlowModule(DescribeContactFlowModuleRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the hours of operation.
     */
    suspend fun describeHoursOfOperation(input: DescribeHoursOfOperationRequest): DescribeHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the hours of operation.
     */
    suspend fun describeHoursOfOperation(block: DescribeHoursOfOperationRequest.Builder.() -> Unit) = describeHoursOfOperation(DescribeHoursOfOperationRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable.
     *
     * If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     */
    suspend fun describeInstance(input: DescribeInstanceRequest): DescribeInstanceResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable.
     *
     * If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.
     */
    suspend fun describeInstance(block: DescribeInstanceRequest.Builder.() -> Unit) = describeInstance(DescribeInstanceRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified instance attribute.
     */
    suspend fun describeInstanceAttribute(input: DescribeInstanceAttributeRequest): DescribeInstanceAttributeResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified instance attribute.
     */
    suspend fun describeInstanceAttribute(block: DescribeInstanceAttributeRequest.Builder.() -> Unit) = describeInstanceAttribute(DescribeInstanceAttributeRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     */
    suspend fun describeInstanceStorageConfig(input: DescribeInstanceStorageConfigRequest): DescribeInstanceStorageConfigResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.
     */
    suspend fun describeInstanceStorageConfig(block: DescribeInstanceStorageConfigRequest.Builder.() -> Unit) = describeInstanceStorageConfig(DescribeInstanceStorageConfigRequest.Builder().apply(block).build())

    /**
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance
     */
    suspend fun describePhoneNumber(input: DescribePhoneNumberRequest): DescribePhoneNumberResponse

    /**
     * Gets details and status of a phone number that’s claimed to your Amazon Connect instance
     */
    suspend fun describePhoneNumber(block: DescribePhoneNumberRequest.Builder.() -> Unit) = describePhoneNumber(DescribePhoneNumberRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified queue.
     */
    suspend fun describeQueue(input: DescribeQueueRequest): DescribeQueueResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Describes the specified queue.
     */
    suspend fun describeQueue(block: DescribeQueueRequest.Builder.() -> Unit) = describeQueue(DescribeQueueRequest.Builder().apply(block).build())

    /**
     * Describes the quick connect.
     */
    suspend fun describeQuickConnect(input: DescribeQuickConnectRequest): DescribeQuickConnectResponse

    /**
     * Describes the quick connect.
     */
    suspend fun describeQuickConnect(block: DescribeQuickConnectRequest.Builder.() -> Unit) = describeQuickConnect(DescribeQuickConnectRequest.Builder().apply(block).build())

    /**
     * Describes the specified routing profile.
     */
    suspend fun describeRoutingProfile(input: DescribeRoutingProfileRequest): DescribeRoutingProfileResponse

    /**
     * Describes the specified routing profile.
     */
    suspend fun describeRoutingProfile(block: DescribeRoutingProfileRequest.Builder.() -> Unit) = describeRoutingProfile(DescribeRoutingProfileRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Gets basic information about the security profle.
     */
    suspend fun describeSecurityProfile(input: DescribeSecurityProfileRequest): DescribeSecurityProfileResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Gets basic information about the security profle.
     */
    suspend fun describeSecurityProfile(block: DescribeSecurityProfileRequest.Builder.() -> Unit) = describeSecurityProfile(DescribeSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Describes the specified user account. You can find the instance ID in the console (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
     */
    suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Describes the specified user account. You can find the instance ID in the console (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
     */
    suspend fun describeUser(block: DescribeUserRequest.Builder.() -> Unit) = describeUser(DescribeUserRequest.Builder().apply(block).build())

    /**
     * Describes the specified hierarchy group.
     */
    suspend fun describeUserHierarchyGroup(input: DescribeUserHierarchyGroupRequest): DescribeUserHierarchyGroupResponse

    /**
     * Describes the specified hierarchy group.
     */
    suspend fun describeUserHierarchyGroup(block: DescribeUserHierarchyGroupRequest.Builder.() -> Unit) = describeUserHierarchyGroup(DescribeUserHierarchyGroupRequest.Builder().apply(block).build())

    /**
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     */
    suspend fun describeUserHierarchyStructure(input: DescribeUserHierarchyStructureRequest): DescribeUserHierarchyStructureResponse

    /**
     * Describes the hierarchy structure of the specified Amazon Connect instance.
     */
    suspend fun describeUserHierarchyStructure(block: DescribeUserHierarchyStructureRequest.Builder.() -> Unit) = describeUserHierarchyStructure(DescribeUserHierarchyStructureRequest.Builder().apply(block).build())

    /**
     * Describes the specified vocabulary.
     */
    suspend fun describeVocabulary(input: DescribeVocabularyRequest): DescribeVocabularyResponse

    /**
     * Describes the specified vocabulary.
     */
    suspend fun describeVocabulary(block: DescribeVocabularyRequest.Builder.() -> Unit) = describeVocabulary(DescribeVocabularyRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes access to integrated applications from Amazon Connect.
     */
    suspend fun disassociateApprovedOrigin(input: DisassociateApprovedOriginRequest): DisassociateApprovedOriginResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes access to integrated applications from Amazon Connect.
     */
    suspend fun disassociateApprovedOrigin(block: DisassociateApprovedOriginRequest.Builder.() -> Unit) = disassociateApprovedOrigin(DisassociateApprovedOriginRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    suspend fun disassociateBot(input: DisassociateBotRequest): DisassociateBotResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot.
     */
    suspend fun disassociateBot(block: DisassociateBotRequest.Builder.() -> Unit) = disassociateBot(DisassociateBotRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Removes the storage type configurations for the specified resource type and association ID.
     */
    suspend fun disassociateInstanceStorageConfig(input: DisassociateInstanceStorageConfigRequest): DisassociateInstanceStorageConfigResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Removes the storage type configurations for the specified resource type and association ID.
     */
    suspend fun disassociateInstanceStorageConfig(block: DisassociateInstanceStorageConfigRequest.Builder.() -> Unit) = disassociateInstanceStorageConfig(DisassociateInstanceStorageConfigRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Remove the Lambda function from the dropdown options available in the relevant contact flow blocks.
     */
    suspend fun disassociateLambdaFunction(input: DisassociateLambdaFunctionRequest): DisassociateLambdaFunctionResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Remove the Lambda function from the dropdown options available in the relevant contact flow blocks.
     */
    suspend fun disassociateLambdaFunction(block: DisassociateLambdaFunctionRequest.Builder.() -> Unit) = disassociateLambdaFunction(DisassociateLambdaFunctionRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     */
    suspend fun disassociateLexBot(input: DisassociateLexBotRequest): DisassociateLexBotResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Revokes authorization from the specified instance to access the specified Amazon Lex bot.
     */
    suspend fun disassociateLexBot(block: DisassociateLexBotRequest.Builder.() -> Unit) = disassociateLexBot(DisassociateLexBotRequest.Builder().apply(block).build())

    /**
     * Removes the contact flow association from a phone number claimed to your Amazon Connect instance, if a contact flow association exists.
     */
    suspend fun disassociatePhoneNumberContactFlow(input: DisassociatePhoneNumberContactFlowRequest): DisassociatePhoneNumberContactFlowResponse

    /**
     * Removes the contact flow association from a phone number claimed to your Amazon Connect instance, if a contact flow association exists.
     */
    suspend fun disassociatePhoneNumberContactFlow(block: DisassociatePhoneNumberContactFlowRequest.Builder.() -> Unit) = disassociatePhoneNumberContactFlow(DisassociatePhoneNumberContactFlowRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Disassociates a set of quick connects from a queue.
     */
    suspend fun disassociateQueueQuickConnects(input: DisassociateQueueQuickConnectsRequest): DisassociateQueueQuickConnectsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Disassociates a set of quick connects from a queue.
     */
    suspend fun disassociateQueueQuickConnects(block: DisassociateQueueQuickConnectsRequest.Builder.() -> Unit) = disassociateQueueQuickConnects(DisassociateQueueQuickConnectsRequest.Builder().apply(block).build())

    /**
     * Disassociates a set of queues from a routing profile.
     */
    suspend fun disassociateRoutingProfileQueues(input: DisassociateRoutingProfileQueuesRequest): DisassociateRoutingProfileQueuesResponse

    /**
     * Disassociates a set of queues from a routing profile.
     */
    suspend fun disassociateRoutingProfileQueues(block: DisassociateRoutingProfileQueuesRequest.Builder.() -> Unit) = disassociateRoutingProfileQueues(DisassociateRoutingProfileQueuesRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the specified security key.
     */
    suspend fun disassociateSecurityKey(input: DisassociateSecurityKeyRequest): DisassociateSecurityKeyResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Deletes the specified security key.
     */
    suspend fun disassociateSecurityKey(block: DisassociateSecurityKeyRequest.Builder.() -> Unit) = disassociateSecurityKey(DisassociateSecurityKeyRequest.Builder().apply(block).build())

    /**
     * Retrieves the contact attributes for the specified contact.
     */
    suspend fun getContactAttributes(input: GetContactAttributesRequest): GetContactAttributesResponse

    /**
     * Retrieves the contact attributes for the specified contact.
     */
    suspend fun getContactAttributes(block: GetContactAttributesRequest.Builder.() -> Unit) = getContactAttributes(GetContactAttributesRequest.Builder().apply(block).build())

    /**
     * Gets the real-time metric data from the specified Amazon Connect instance.
     *
     * For a description of each metric, see [Real-time Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun getCurrentMetricData(input: GetCurrentMetricDataRequest): GetCurrentMetricDataResponse

    /**
     * Gets the real-time metric data from the specified Amazon Connect instance.
     *
     * For a description of each metric, see [Real-time Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun getCurrentMetricData(block: GetCurrentMetricDataRequest.Builder.() -> Unit) = getCurrentMetricData(GetCurrentMetricDataRequest.Builder().apply(block).build())

    /**
     * Gets the real-time active user data from the specified Amazon Connect instance.
     */
    suspend fun getCurrentUserData(input: GetCurrentUserDataRequest): GetCurrentUserDataResponse

    /**
     * Gets the real-time active user data from the specified Amazon Connect instance.
     */
    suspend fun getCurrentUserData(block: GetCurrentUserDataRequest.Builder.() -> Unit) = getCurrentUserData(GetCurrentUserDataRequest.Builder().apply(block).build())

    /**
     * Retrieves a token for federation.
     *
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears:
     *
     * `Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect`
     */
    suspend fun getFederationToken(input: GetFederationTokenRequest): GetFederationTokenResponse

    /**
     * Retrieves a token for federation.
     *
     * This API doesn't support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears:
     *
     * `Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect`
     */
    suspend fun getFederationToken(block: GetFederationTokenRequest.Builder.() -> Unit) = getFederationToken(GetFederationTokenRequest.Builder().apply(block).build())

    /**
     * Gets historical metric data from the specified Amazon Connect instance.
     *
     * For a description of each historical metric, see [Historical Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun getMetricData(input: GetMetricDataRequest): GetMetricDataResponse

    /**
     * Gets historical metric data from the specified Amazon Connect instance.
     *
     * For a description of each historical metric, see [Historical Metrics Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun getMetricData(block: GetMetricDataRequest.Builder.() -> Unit) = getMetricData(GetMetricDataRequest.Builder().apply(block).build())

    /**
     * Gets details about a specific task template in the specified Amazon Connect instance.
     */
    suspend fun getTaskTemplate(input: GetTaskTemplateRequest): GetTaskTemplateResponse

    /**
     * Gets details about a specific task template in the specified Amazon Connect instance.
     */
    suspend fun getTaskTemplate(block: GetTaskTemplateRequest.Builder.() -> Unit) = getTaskTemplate(GetTaskTemplateRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists agent statuses.
     */
    suspend fun listAgentStatuses(input: ListAgentStatusesRequest): ListAgentStatusesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists agent statuses.
     */
    suspend fun listAgentStatuses(block: ListAgentStatusesRequest.Builder.() -> Unit) = listAgentStatuses(ListAgentStatusesRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all approved origins associated with the instance.
     */
    suspend fun listApprovedOrigins(input: ListApprovedOriginsRequest): ListApprovedOriginsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all approved origins associated with the instance.
     */
    suspend fun listApprovedOrigins(block: ListApprovedOriginsRequest.Builder.() -> Unit) = listApprovedOrigins(ListApprovedOriginsRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance.
     */
    suspend fun listBots(input: ListBotsRequest): ListBotsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance.
     */
    suspend fun listBots(block: ListBotsRequest.Builder.() -> Unit) = listBots(ListBotsRequest.Builder().apply(block).build())

    /**
     * Provides information about the contact flow modules for the specified Amazon Connect instance.
     */
    suspend fun listContactFlowModules(input: ListContactFlowModulesRequest): ListContactFlowModulesResponse

    /**
     * Provides information about the contact flow modules for the specified Amazon Connect instance.
     */
    suspend fun listContactFlowModules(block: ListContactFlowModulesRequest.Builder.() -> Unit) = listContactFlowModules(ListContactFlowModulesRequest.Builder().apply(block).build())

    /**
     * Provides information about the contact flows for the specified Amazon Connect instance.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     *
     * For more information about contact flows, see [Contact Flows](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listContactFlows(input: ListContactFlowsRequest): ListContactFlowsResponse

    /**
     * Provides information about the contact flows for the specified Amazon Connect instance.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     *
     * For more information about contact flows, see [Contact Flows](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listContactFlows(block: ListContactFlowsRequest.Builder.() -> Unit) = listContactFlows(ListContactFlowsRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified `referenceTypes`, returns a list of references associated with the contact.
     */
    suspend fun listContactReferences(input: ListContactReferencesRequest): ListContactReferencesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * For the specified `referenceTypes`, returns a list of references associated with the contact.
     */
    suspend fun listContactReferences(block: ListContactReferencesRequest.Builder.() -> Unit) = listContactReferences(ListContactReferencesRequest.Builder().apply(block).build())

    /**
     * Lists the default vocabularies for the specified Amazon Connect instance.
     */
    suspend fun listDefaultVocabularies(input: ListDefaultVocabulariesRequest): ListDefaultVocabulariesResponse

    /**
     * Lists the default vocabularies for the specified Amazon Connect instance.
     */
    suspend fun listDefaultVocabularies(block: ListDefaultVocabulariesRequest.Builder.() -> Unit) = listDefaultVocabularies(ListDefaultVocabulariesRequest.Builder().apply(block).build())

    /**
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     *
     * For more information about hours of operation, see [Set the Hours of Operation for a Queue](https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listHoursOfOperations(input: ListHoursOfOperationsRequest): ListHoursOfOperationsResponse

    /**
     * Provides information about the hours of operation for the specified Amazon Connect instance.
     *
     * For more information about hours of operation, see [Set the Hours of Operation for a Queue](https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listHoursOfOperations(block: ListHoursOfOperationsRequest.Builder.() -> Unit) = listHoursOfOperations(ListHoursOfOperationsRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all attribute types for the given instance.
     */
    suspend fun listInstanceAttributes(input: ListInstanceAttributesRequest): ListInstanceAttributesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all attribute types for the given instance.
     */
    suspend fun listInstanceAttributes(block: ListInstanceAttributesRequest.Builder.() -> Unit) = listInstanceAttributes(ListInstanceAttributesRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of storage configs for the identified instance and resource type.
     */
    suspend fun listInstanceStorageConfigs(input: ListInstanceStorageConfigsRequest): ListInstanceStorageConfigsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of storage configs for the identified instance and resource type.
     */
    suspend fun listInstanceStorageConfigs(block: ListInstanceStorageConfigsRequest.Builder.() -> Unit) = listInstanceStorageConfigs(ListInstanceStorageConfigsRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren't successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.
     */
    suspend fun listInstances(input: ListInstancesRequest = ListInstancesRequest {}): ListInstancesResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren't successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.
     */
    suspend fun listInstances(block: ListInstancesRequest.Builder.() -> Unit) = listInstances(ListInstancesRequest.Builder().apply(block).build())

    /**
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.
     */
    suspend fun listIntegrationAssociations(input: ListIntegrationAssociationsRequest): ListIntegrationAssociationsResponse

    /**
     * Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.
     */
    suspend fun listIntegrationAssociations(block: ListIntegrationAssociationsRequest.Builder.() -> Unit) = listIntegrationAssociations(ListIntegrationAssociationsRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact flow blocks.
     */
    suspend fun listLambdaFunctions(input: ListLambdaFunctionsRequest): ListLambdaFunctionsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant contact flow blocks.
     */
    suspend fun listLambdaFunctions(block: ListLambdaFunctionsRequest.Builder.() -> Unit) = listLambdaFunctions(ListLambdaFunctionsRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all the Amazon Lex bots currently associated with the instance.
     */
    suspend fun listLexBots(input: ListLexBotsRequest): ListLexBotsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all the Amazon Lex bots currently associated with the instance.
     */
    suspend fun listLexBots(block: ListLexBotsRequest.Builder.() -> Unit) = listLexBots(ListLexBotsRequest.Builder().apply(block).build())

    /**
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listPhoneNumbers(input: ListPhoneNumbersRequest): ListPhoneNumbersResponse

    /**
     * Provides information about the phone numbers for the specified Amazon Connect instance.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listPhoneNumbers(block: ListPhoneNumbersRequest.Builder.() -> Unit) = listPhoneNumbers(ListPhoneNumbersRequest.Builder().apply(block).build())

    /**
     * Lists phone numbers claimed to your Amazon Connect instance.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listPhoneNumbersV2(input: ListPhoneNumbersV2Request = ListPhoneNumbersV2Request {}): ListPhoneNumbersV2Response

    /**
     * Lists phone numbers claimed to your Amazon Connect instance.
     *
     * For more information about phone numbers, see [Set Up Phone Numbers for Your Contact Center](https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listPhoneNumbersV2(block: ListPhoneNumbersV2Request.Builder.() -> Unit) = listPhoneNumbersV2(ListPhoneNumbersV2Request.Builder().apply(block).build())

    /**
     * Provides information about the prompts for the specified Amazon Connect instance.
     */
    suspend fun listPrompts(input: ListPromptsRequest): ListPromptsResponse

    /**
     * Provides information about the prompts for the specified Amazon Connect instance.
     */
    suspend fun listPrompts(block: ListPromptsRequest.Builder.() -> Unit) = listPrompts(ListPromptsRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the quick connects associated with a queue.
     */
    suspend fun listQueueQuickConnects(input: ListQueueQuickConnectsRequest): ListQueueQuickConnectsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the quick connects associated with a queue.
     */
    suspend fun listQueueQuickConnects(block: ListQueueQuickConnectsRequest.Builder.() -> Unit) = listQueueQuickConnects(ListQueueQuickConnectsRequest.Builder().apply(block).build())

    /**
     * Provides information about the queues for the specified Amazon Connect instance.
     *
     * If you do not specify a `QueueTypes` parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.
     *
     * For more information about queues, see [Queues: Standard and Agent](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listQueues(input: ListQueuesRequest): ListQueuesResponse

    /**
     * Provides information about the queues for the specified Amazon Connect instance.
     *
     * If you do not specify a `QueueTypes` parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.
     *
     * For more information about queues, see [Queues: Standard and Agent](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listQueues(block: ListQueuesRequest.Builder.() -> Unit) = listQueues(ListQueuesRequest.Builder().apply(block).build())

    /**
     * Provides information about the quick connects for the specified Amazon Connect instance.
     */
    suspend fun listQuickConnects(input: ListQuickConnectsRequest): ListQuickConnectsResponse

    /**
     * Provides information about the quick connects for the specified Amazon Connect instance.
     */
    suspend fun listQuickConnects(block: ListQuickConnectsRequest.Builder.() -> Unit) = listQuickConnects(ListQuickConnectsRequest.Builder().apply(block).build())

    /**
     * Lists the queues associated with a routing profile.
     */
    suspend fun listRoutingProfileQueues(input: ListRoutingProfileQueuesRequest): ListRoutingProfileQueuesResponse

    /**
     * Lists the queues associated with a routing profile.
     */
    suspend fun listRoutingProfileQueues(block: ListRoutingProfileQueuesRequest.Builder.() -> Unit) = listRoutingProfileQueues(ListRoutingProfileQueuesRequest.Builder().apply(block).build())

    /**
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     *
     * For more information about routing profiles, see [Routing Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html) and [Create a Routing Profile](https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listRoutingProfiles(input: ListRoutingProfilesRequest): ListRoutingProfilesResponse

    /**
     * Provides summary information about the routing profiles for the specified Amazon Connect instance.
     *
     * For more information about routing profiles, see [Routing Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html) and [Create a Routing Profile](https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listRoutingProfiles(block: ListRoutingProfilesRequest.Builder.() -> Unit) = listRoutingProfiles(ListRoutingProfilesRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all security keys associated with the instance.
     */
    suspend fun listSecurityKeys(input: ListSecurityKeysRequest): ListSecurityKeysResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Returns a paginated list of all security keys associated with the instance.
     */
    suspend fun listSecurityKeys(block: ListSecurityKeysRequest.Builder.() -> Unit) = listSecurityKeys(ListSecurityKeysRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the permissions granted to a security profile.
     */
    suspend fun listSecurityProfilePermissions(input: ListSecurityProfilePermissionsRequest): ListSecurityProfilePermissionsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Lists the permissions granted to a security profile.
     */
    suspend fun listSecurityProfilePermissions(block: ListSecurityProfilePermissionsRequest.Builder.() -> Unit) = listSecurityProfilePermissions(ListSecurityProfilePermissionsRequest.Builder().apply(block).build())

    /**
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     *
     * For more information about security profiles, see [Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listSecurityProfiles(input: ListSecurityProfilesRequest): ListSecurityProfilesResponse

    /**
     * Provides summary information about the security profiles for the specified Amazon Connect instance.
     *
     * For more information about security profiles, see [Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listSecurityProfiles(block: ListSecurityProfilesRequest.Builder.() -> Unit) = listSecurityProfiles(ListSecurityProfilesRequest.Builder().apply(block).build())

    /**
     * Lists the tags for the specified resource.
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for the specified resource.
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Lists task templates for the specified Amazon Connect instance.
     */
    suspend fun listTaskTemplates(input: ListTaskTemplatesRequest): ListTaskTemplatesResponse

    /**
     * Lists task templates for the specified Amazon Connect instance.
     */
    suspend fun listTaskTemplates(block: ListTaskTemplatesRequest.Builder.() -> Unit) = listTaskTemplates(ListTaskTemplatesRequest.Builder().apply(block).build())

    /**
     * Lists the use cases for the integration association.
     */
    suspend fun listUseCases(input: ListUseCasesRequest): ListUseCasesResponse

    /**
     * Lists the use cases for the integration association.
     */
    suspend fun listUseCases(block: ListUseCasesRequest.Builder.() -> Unit) = listUseCases(ListUseCasesRequest.Builder().apply(block).build())

    /**
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     *
     * For more information about agent hierarchies, see [Set Up Agent Hierarchies](https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listUserHierarchyGroups(input: ListUserHierarchyGroupsRequest): ListUserHierarchyGroupsResponse

    /**
     * Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
     *
     * For more information about agent hierarchies, see [Set Up Agent Hierarchies](https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun listUserHierarchyGroups(block: ListUserHierarchyGroupsRequest.Builder.() -> Unit) = listUserHierarchyGroups(ListUserHierarchyGroupsRequest.Builder().apply(block).build())

    /**
     * Provides summary information about the users for the specified Amazon Connect instance.
     */
    suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Provides summary information about the users for the specified Amazon Connect instance.
     */
    suspend fun listUsers(block: ListUsersRequest.Builder.() -> Unit) = listUsers(ListUsersRequest.Builder().apply(block).build())

    /**
     * Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact, this sets the agent's next status.
     *
     * For more information, see [Agent status](https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html) and [Set your next status](https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun putUserStatus(input: PutUserStatusRequest): PutUserStatusResponse

    /**
     * Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact, this sets the agent's next status.
     *
     * For more information, see [Agent status](https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html) and [Set your next status](https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun putUserStatus(block: PutUserStatusRequest.Builder.() -> Unit) = putUserStatus(PutUserStatusRequest.Builder().apply(block).build())

    /**
     * Releases a phone number previously claimed to an Amazon Connect instance.
     */
    suspend fun releasePhoneNumber(input: ReleasePhoneNumberRequest): ReleasePhoneNumberResponse

    /**
     * Releases a phone number previously claimed to an Amazon Connect instance.
     */
    suspend fun releasePhoneNumber(block: ReleasePhoneNumberRequest.Builder.() -> Unit) = releasePhoneNumber(ReleasePhoneNumberRequest.Builder().apply(block).build())

    /**
     * When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording the call.
     *
     * Only voice recordings are supported at this time.
     */
    suspend fun resumeContactRecording(input: ResumeContactRecordingRequest): ResumeContactRecordingResponse

    /**
     * When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording the call.
     *
     * Only voice recordings are supported at this time.
     */
    suspend fun resumeContactRecording(block: ResumeContactRecordingRequest.Builder.() -> Unit) = resumeContactRecording(ResumeContactRecordingRequest.Builder().apply(block).build())

    /**
     * Searches for available phone numbers that you can claim to your Amazon Connect instance.
     */
    suspend fun searchAvailablePhoneNumbers(input: SearchAvailablePhoneNumbersRequest): SearchAvailablePhoneNumbersResponse

    /**
     * Searches for available phone numbers that you can claim to your Amazon Connect instance.
     */
    suspend fun searchAvailablePhoneNumbers(block: SearchAvailablePhoneNumbersRequest.Builder.() -> Unit) = searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest.Builder().apply(block).build())

    /**
     * Searches users in an Amazon Connect instance, with optional filtering.
     */
    suspend fun searchUsers(input: SearchUsersRequest = SearchUsersRequest {}): SearchUsersResponse

    /**
     * Searches users in an Amazon Connect instance, with optional filtering.
     */
    suspend fun searchUsers(block: SearchUsersRequest.Builder.() -> Unit) = searchUsers(SearchUsersRequest.Builder().apply(block).build())

    /**
     * Searches for vocabularies within a specific Amazon Connect instance using `State`, `NameStartsWith`, and `LanguageCode`.
     */
    suspend fun searchVocabularies(input: SearchVocabulariesRequest): SearchVocabulariesResponse

    /**
     * Searches for vocabularies within a specific Amazon Connect instance using `State`, `NameStartsWith`, and `LanguageCode`.
     */
    suspend fun searchVocabularies(block: SearchVocabulariesRequest.Builder.() -> Unit) = searchVocabularies(SearchVocabulariesRequest.Builder().apply(block).build())

    /**
     * Initiates a contact flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) API in the Amazon Connect Participant Service.
     *
     * When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) with WEBSOCKET and CONNECTION_CREDENTIALS.
     *
     * A 429 error occurs in the following situations:
     * + API rate limit is exceeded. API TPS throttling returns a `TooManyRequests` exception.
     * + The [quota for concurrent active chats](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) is exceeded. Active chat throttling returns a `LimitExceededException`.
     *
     * If you use the `ChatDurationInMinutes` parameter and receive a 400 error, your account may not support the ability to configure custom chat durations. For more information, contact Amazon Web Services Support.
     *
     * For more information about chat, see [Chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun startChatContact(input: StartChatContactRequest): StartChatContactResponse

    /**
     * Initiates a contact flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) API in the Amazon Connect Participant Service.
     *
     * When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking [CreateParticipantConnection](https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html) with WEBSOCKET and CONNECTION_CREDENTIALS.
     *
     * A 429 error occurs in the following situations:
     * + API rate limit is exceeded. API TPS throttling returns a `TooManyRequests` exception.
     * + The [quota for concurrent active chats](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) is exceeded. Active chat throttling returns a `LimitExceededException`.
     *
     * If you use the `ChatDurationInMinutes` parameter and receive a 400 error, your account may not support the ability to configure custom chat durations. For more information, contact Amazon Web Services Support.
     *
     * For more information about chat, see [Chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun startChatContact(block: StartChatContactRequest.Builder.() -> Unit) = startChatContact(StartChatContactRequest.Builder().apply(block).build())

    /**
     * Starts recording the contact:
     * + If the API is called *before* the agent joins the call, recording starts when the agent joins the call.
     * + If the API is called *after* the agent joins the call, recording starts at the time of the API call.
     *
     * StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.
     *
     * You can use this API to override the recording behavior configured in the [Set recording behavior](https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html) block.
     *
     * Only voice recordings are supported at this time.
     */
    suspend fun startContactRecording(input: StartContactRecordingRequest): StartContactRecordingResponse

    /**
     * Starts recording the contact:
     * + If the API is called *before* the agent joins the call, recording starts when the agent joins the call.
     * + If the API is called *after* the agent joins the call, recording starts at the time of the API call.
     *
     * StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.
     *
     * You can use this API to override the recording behavior configured in the [Set recording behavior](https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html) block.
     *
     * Only voice recordings are supported at this time.
     */
    suspend fun startContactRecording(block: StartContactRecordingRequest.Builder.() -> Unit) = startContactRecording(StartContactRecordingRequest.Builder().apply(block).build())

    /**
     * Initiates real-time message streaming for a new chat contact.
     *
     *  For more information about message streaming, see [Enable real-time chat message streaming](https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun startContactStreaming(input: StartContactStreamingRequest): StartContactStreamingResponse

    /**
     * Initiates real-time message streaming for a new chat contact.
     *
     *  For more information about message streaming, see [Enable real-time chat message streaming](https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun startContactStreaming(block: StartContactStreamingRequest.Builder.() -> Unit) = startContactStreaming(StartContactStreamingRequest.Builder().apply(block).build())

    /**
     * Places an outbound call to a contact, and then initiates the contact flow. It performs the actions in the contact flow that's specified (in `ContactFlowId`).
     *
     * Agents do not initiate the outbound API, which means that they do not dial the contact. If the contact flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.
     *
     * There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.
     *
     * UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     *
     * Campaign calls are not allowed by default. Before you can make a call with `TrafficType` = `CAMPAIGN`, you must submit a service quota increase request. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun startOutboundVoiceContact(input: StartOutboundVoiceContactRequest): StartOutboundVoiceContactResponse

    /**
     * Places an outbound call to a contact, and then initiates the contact flow. It performs the actions in the contact flow that's specified (in `ContactFlowId`).
     *
     * Agents do not initiate the outbound API, which means that they do not dial the contact. If the contact flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.
     *
     * There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.
     *
     * UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     *
     * Campaign calls are not allowed by default. Before you can make a call with `TrafficType` = `CAMPAIGN`, you must submit a service quota increase request. For more information, see [Amazon Connect Service Quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun startOutboundVoiceContact(block: StartOutboundVoiceContactRequest.Builder.() -> Unit) = startOutboundVoiceContact(StartOutboundVoiceContactRequest.Builder().apply(block).build())

    /**
     * Initiates a contact flow to start a new task.
     */
    suspend fun startTaskContact(input: StartTaskContactRequest): StartTaskContactResponse

    /**
     * Initiates a contact flow to start a new task.
     */
    suspend fun startTaskContact(block: StartTaskContactRequest.Builder.() -> Unit) = startTaskContact(StartTaskContactRequest.Builder().apply(block).build())

    /**
     * Ends the specified contact. This call does not work for the following initiation methods:
     * + DISCONNECT
     * + TRANSFER
     * + QUEUE_TRANSFER
     */
    suspend fun stopContact(input: StopContactRequest): StopContactResponse

    /**
     * Ends the specified contact. This call does not work for the following initiation methods:
     * + DISCONNECT
     * + TRANSFER
     * + QUEUE_TRANSFER
     */
    suspend fun stopContact(block: StopContactRequest.Builder.() -> Unit) = stopContact(StopContactRequest.Builder().apply(block).build())

    /**
     * Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
     *
     * Only voice recordings are supported at this time.
     */
    suspend fun stopContactRecording(input: StopContactRecordingRequest): StopContactRecordingResponse

    /**
     * Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
     *
     * Only voice recordings are supported at this time.
     */
    suspend fun stopContactRecording(block: StopContactRecordingRequest.Builder.() -> Unit) = stopContactRecording(StopContactRecordingRequest.Builder().apply(block).build())

    /**
     * Ends message streaming on a specified contact. To restart message streaming on that contact, call the [StartContactStreaming](https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html) API.
     */
    suspend fun stopContactStreaming(input: StopContactStreamingRequest): StopContactStreamingResponse

    /**
     * Ends message streaming on a specified contact. To restart message streaming on that contact, call the [StartContactStreaming](https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html) API.
     */
    suspend fun stopContactStreaming(block: StopContactStreamingRequest.Builder.() -> Unit) = stopContactStreaming(StopContactStreamingRequest.Builder().apply(block).build())

    /**
     * When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording.
     *
     * The period of time that the recording is suspended is filled with silence in the final recording.
     *
     * Only voice recordings are supported at this time.
     */
    suspend fun suspendContactRecording(input: SuspendContactRecordingRequest): SuspendContactRecordingResponse

    /**
     * When a contact is being recorded, this API suspends recording the call. For example, you might suspend the call recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording.
     *
     * The period of time that the recording is suspended is filled with silence in the final recording.
     *
     * Only voice recordings are supported at this time.
     */
    suspend fun suspendContactRecording(block: SuspendContactRecordingRequest.Builder.() -> Unit) = suspendContactRecording(SuspendContactRecordingRequest.Builder().apply(block).build())

    /**
     * Adds the specified tags to the specified resource.
     *
     * The supported resource types are users, routing profiles, queues, quick connects, contact flows, agent status, hours of operation, phone number, security profiles, and task templates.
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds the specified tags to the specified resource.
     *
     * The supported resource types are users, routing profiles, queues, quick connects, contact flows, agent status, hours of operation, phone number, security profiles, and task templates.
     *
     * For sample policies that use tags, see [Amazon Connect Identity-Based Policy Examples](https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Transfers contacts from one agent or queue to another agent or queue at any point after a contact is created. You can transfer a contact to another queue by providing the contact flow which orchestrates the contact to the destination queue. This gives you more control over contact handling and helps you adhere to the service level agreement (SLA) guaranteed to your customers.
     *
     * Note the following requirements:
     * + Transfer is supported for only `TASK` contacts.
     * + Do not use both `QueueId` and `UserId` in the same call.
     * + The following contact flow types are supported: Inbound contact flow, Transfer to agent flow, and Transfer to queue flow.
     * + The `TransferContact` API can be called only on active contacts.
     * + A contact cannot be transferred more than 11 times.
     */
    suspend fun transferContact(input: TransferContactRequest): TransferContactResponse

    /**
     * Transfers contacts from one agent or queue to another agent or queue at any point after a contact is created. You can transfer a contact to another queue by providing the contact flow which orchestrates the contact to the destination queue. This gives you more control over contact handling and helps you adhere to the service level agreement (SLA) guaranteed to your customers.
     *
     * Note the following requirements:
     * + Transfer is supported for only `TASK` contacts.
     * + Do not use both `QueueId` and `UserId` in the same call.
     * + The following contact flow types are supported: Inbound contact flow, Transfer to agent flow, and Transfer to queue flow.
     * + The `TransferContact` API can be called only on active contacts.
     * + A contact cannot be transferred more than 11 times.
     */
    suspend fun transferContact(block: TransferContactRequest.Builder.() -> Unit) = transferContact(TransferContactRequest.Builder().apply(block).build())

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates agent status.
     */
    suspend fun updateAgentStatus(input: UpdateAgentStatusRequest): UpdateAgentStatusResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates agent status.
     */
    suspend fun updateAgentStatus(block: UpdateAgentStatusRequest.Builder.() -> Unit) = updateAgentStatus(UpdateAgentStatusRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.
     *
     * You can add or update user-defined contact information for both ongoing and completed contacts.
     */
    suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.
     *
     * You can add or update user-defined contact information for both ongoing and completed contacts.
     */
    suspend fun updateContact(block: UpdateContactRequest.Builder.() -> Unit) = updateContact(UpdateContactRequest.Builder().apply(block).build())

    /**
     * Creates or updates user-defined contact attributes associated with the specified contact.
     *
     * You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer's name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.
     *
     * Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about CTR retention and the maximum size of the CTR attributes section, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits) in the *Amazon Connect Administrator Guide*.
     *
     * **Important:** You cannot use the operation to update attributes for contacts that occurred prior to the release of the API, which was September 12, 2018. You can update attributes only for contacts that started after the release of the API. If you attempt to update attributes for a contact that occurred prior to the release of the API, a 400 error is returned. This applies also to queued callbacks that were initiated prior to the release of the API but are still active in your instance.
     */
    suspend fun updateContactAttributes(input: UpdateContactAttributesRequest): UpdateContactAttributesResponse

    /**
     * Creates or updates user-defined contact attributes associated with the specified contact.
     *
     * You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer's name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.
     *
     * Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about CTR retention and the maximum size of the CTR attributes section, see [Feature specifications](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits) in the *Amazon Connect Administrator Guide*.
     *
     * **Important:** You cannot use the operation to update attributes for contacts that occurred prior to the release of the API, which was September 12, 2018. You can update attributes only for contacts that started after the release of the API. If you attempt to update attributes for a contact that occurred prior to the release of the API, a 400 error is returned. This applies also to queued callbacks that were initiated prior to the release of the API but are still active in your instance.
     */
    suspend fun updateContactAttributes(block: UpdateContactAttributesRequest.Builder.() -> Unit) = updateContactAttributes(UpdateContactAttributesRequest.Builder().apply(block).build())

    /**
     * Updates the specified contact flow.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     */
    suspend fun updateContactFlowContent(input: UpdateContactFlowContentRequest): UpdateContactFlowContentResponse

    /**
     * Updates the specified contact flow.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     */
    suspend fun updateContactFlowContent(block: UpdateContactFlowContentRequest.Builder.() -> Unit) = updateContactFlowContent(UpdateContactFlowContentRequest.Builder().apply(block).build())

    /**
     * Updates metadata about specified contact flow.
     */
    suspend fun updateContactFlowMetadata(input: UpdateContactFlowMetadataRequest): UpdateContactFlowMetadataResponse

    /**
     * Updates metadata about specified contact flow.
     */
    suspend fun updateContactFlowMetadata(block: UpdateContactFlowMetadataRequest.Builder.() -> Unit) = updateContactFlowMetadata(UpdateContactFlowMetadataRequest.Builder().apply(block).build())

    /**
     * Updates specified contact flow module for the specified Amazon Connect instance.
     */
    suspend fun updateContactFlowModuleContent(input: UpdateContactFlowModuleContentRequest): UpdateContactFlowModuleContentResponse

    /**
     * Updates specified contact flow module for the specified Amazon Connect instance.
     */
    suspend fun updateContactFlowModuleContent(block: UpdateContactFlowModuleContentRequest.Builder.() -> Unit) = updateContactFlowModuleContent(UpdateContactFlowModuleContentRequest.Builder().apply(block).build())

    /**
     * Updates metadata about specified contact flow module.
     */
    suspend fun updateContactFlowModuleMetadata(input: UpdateContactFlowModuleMetadataRequest): UpdateContactFlowModuleMetadataResponse

    /**
     * Updates metadata about specified contact flow module.
     */
    suspend fun updateContactFlowModuleMetadata(block: UpdateContactFlowModuleMetadataRequest.Builder.() -> Unit) = updateContactFlowModuleMetadata(UpdateContactFlowModuleMetadataRequest.Builder().apply(block).build())

    /**
     * The name of the contact flow.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     */
    suspend fun updateContactFlowName(input: UpdateContactFlowNameRequest): UpdateContactFlowNameResponse

    /**
     * The name of the contact flow.
     *
     * You can also create and update contact flows using the [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html).
     */
    suspend fun updateContactFlowName(block: UpdateContactFlowNameRequest.Builder.() -> Unit) = updateContactFlowName(UpdateContactFlowNameRequest.Builder().apply(block).build())

    /**
     * Updates the scheduled time of a task contact that is already scheduled.
     */
    suspend fun updateContactSchedule(input: UpdateContactScheduleRequest): UpdateContactScheduleResponse

    /**
     * Updates the scheduled time of a task contact that is already scheduled.
     */
    suspend fun updateContactSchedule(block: UpdateContactScheduleRequest.Builder.() -> Unit) = updateContactSchedule(UpdateContactScheduleRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation.
     */
    suspend fun updateHoursOfOperation(input: UpdateHoursOfOperationRequest): UpdateHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation.
     */
    suspend fun updateHoursOfOperation(block: UpdateHoursOfOperationRequest.Builder.() -> Unit) = updateHoursOfOperation(UpdateHoursOfOperationRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the value for the specified attribute type.
     */
    suspend fun updateInstanceAttribute(input: UpdateInstanceAttributeRequest): UpdateInstanceAttributeResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the value for the specified attribute type.
     */
    suspend fun updateInstanceAttribute(block: UpdateInstanceAttributeRequest.Builder.() -> Unit) = updateInstanceAttribute(UpdateInstanceAttributeRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates an existing configuration for a resource type. This API is idempotent.
     */
    suspend fun updateInstanceStorageConfig(input: UpdateInstanceStorageConfigRequest): UpdateInstanceStorageConfigResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates an existing configuration for a resource type. This API is idempotent.
     */
    suspend fun updateInstanceStorageConfig(block: UpdateInstanceStorageConfigRequest.Builder.() -> Unit) = updateInstanceStorageConfig(UpdateInstanceStorageConfigRequest.Builder().apply(block).build())

    /**
     * Updates your claimed phone number from its current Amazon Connect instance to another Amazon Connect instance in the same Region.
     */
    suspend fun updatePhoneNumber(input: UpdatePhoneNumberRequest): UpdatePhoneNumberResponse

    /**
     * Updates your claimed phone number from its current Amazon Connect instance to another Amazon Connect instance in the same Region.
     */
    suspend fun updatePhoneNumber(block: UpdatePhoneNumberRequest.Builder.() -> Unit) = updatePhoneNumber(UpdatePhoneNumberRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation for the specified queue.
     */
    suspend fun updateQueueHoursOfOperation(input: UpdateQueueHoursOfOperationRequest): UpdateQueueHoursOfOperationResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the hours of operation for the specified queue.
     */
    suspend fun updateQueueHoursOfOperation(block: UpdateQueueHoursOfOperationRequest.Builder.() -> Unit) = updateQueueHoursOfOperation(UpdateQueueHoursOfOperationRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the maximum number of contacts allowed in a queue before it is considered full.
     */
    suspend fun updateQueueMaxContacts(input: UpdateQueueMaxContactsRequest): UpdateQueueMaxContactsResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the maximum number of contacts allowed in a queue before it is considered full.
     */
    suspend fun updateQueueMaxContacts(block: UpdateQueueMaxContactsRequest.Builder.() -> Unit) = updateQueueMaxContacts(UpdateQueueMaxContactsRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the name and description of a queue. At least `Name` or `Description` must be provided.
     */
    suspend fun updateQueueName(input: UpdateQueueNameRequest): UpdateQueueNameResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the name and description of a queue. At least `Name` or `Description` must be provided.
     */
    suspend fun updateQueueName(block: UpdateQueueNameRequest.Builder.() -> Unit) = updateQueueName(UpdateQueueNameRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.
     */
    suspend fun updateQueueOutboundCallerConfig(input: UpdateQueueOutboundCallerConfigRequest): UpdateQueueOutboundCallerConfigResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.
     */
    suspend fun updateQueueOutboundCallerConfig(block: UpdateQueueOutboundCallerConfigRequest.Builder.() -> Unit) = updateQueueOutboundCallerConfig(UpdateQueueOutboundCallerConfigRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the status of the queue.
     */
    suspend fun updateQueueStatus(input: UpdateQueueStatusRequest): UpdateQueueStatusResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates the status of the queue.
     */
    suspend fun updateQueueStatus(block: UpdateQueueStatusRequest.Builder.() -> Unit) = updateQueueStatus(UpdateQueueStatusRequest.Builder().apply(block).build())

    /**
     * Updates the configuration settings for the specified quick connect.
     */
    suspend fun updateQuickConnectConfig(input: UpdateQuickConnectConfigRequest): UpdateQuickConnectConfigResponse

    /**
     * Updates the configuration settings for the specified quick connect.
     */
    suspend fun updateQuickConnectConfig(block: UpdateQuickConnectConfigRequest.Builder.() -> Unit) = updateQuickConnectConfig(UpdateQuickConnectConfigRequest.Builder().apply(block).build())

    /**
     * Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    suspend fun updateQuickConnectName(input: UpdateQuickConnectNameRequest): UpdateQuickConnectNameResponse

    /**
     * Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    suspend fun updateQuickConnectName(block: UpdateQuickConnectNameRequest.Builder.() -> Unit) = updateQuickConnectName(UpdateQuickConnectNameRequest.Builder().apply(block).build())

    /**
     * Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
     */
    suspend fun updateRoutingProfileConcurrency(input: UpdateRoutingProfileConcurrencyRequest): UpdateRoutingProfileConcurrencyResponse

    /**
     * Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
     */
    suspend fun updateRoutingProfileConcurrency(block: UpdateRoutingProfileConcurrencyRequest.Builder.() -> Unit) = updateRoutingProfileConcurrency(UpdateRoutingProfileConcurrencyRequest.Builder().apply(block).build())

    /**
     * Updates the default outbound queue of a routing profile.
     */
    suspend fun updateRoutingProfileDefaultOutboundQueue(input: UpdateRoutingProfileDefaultOutboundQueueRequest): UpdateRoutingProfileDefaultOutboundQueueResponse

    /**
     * Updates the default outbound queue of a routing profile.
     */
    suspend fun updateRoutingProfileDefaultOutboundQueue(block: UpdateRoutingProfileDefaultOutboundQueueRequest.Builder.() -> Unit) = updateRoutingProfileDefaultOutboundQueue(UpdateRoutingProfileDefaultOutboundQueueRequest.Builder().apply(block).build())

    /**
     * Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    suspend fun updateRoutingProfileName(input: UpdateRoutingProfileNameRequest): UpdateRoutingProfileNameResponse

    /**
     * Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
     */
    suspend fun updateRoutingProfileName(block: UpdateRoutingProfileNameRequest.Builder.() -> Unit) = updateRoutingProfileName(UpdateRoutingProfileNameRequest.Builder().apply(block).build())

    /**
     * Updates the properties associated with a set of queues for a routing profile.
     */
    suspend fun updateRoutingProfileQueues(input: UpdateRoutingProfileQueuesRequest): UpdateRoutingProfileQueuesResponse

    /**
     * Updates the properties associated with a set of queues for a routing profile.
     */
    suspend fun updateRoutingProfileQueues(block: UpdateRoutingProfileQueuesRequest.Builder.() -> Unit) = updateRoutingProfileQueues(UpdateRoutingProfileQueuesRequest.Builder().apply(block).build())

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates a security profile.
     */
    suspend fun updateSecurityProfile(input: UpdateSecurityProfileRequest): UpdateSecurityProfileResponse

    /**
     * This API is in preview release for Amazon Connect and is subject to change.
     *
     * Updates a security profile.
     */
    suspend fun updateSecurityProfile(block: UpdateSecurityProfileRequest.Builder.() -> Unit) = updateSecurityProfile(UpdateSecurityProfileRequest.Builder().apply(block).build())

    /**
     * Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.
     */
    suspend fun updateTaskTemplate(input: UpdateTaskTemplateRequest): UpdateTaskTemplateResponse

    /**
     * Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.
     */
    suspend fun updateTaskTemplate(block: UpdateTaskTemplateRequest.Builder.() -> Unit) = updateTaskTemplate(UpdateTaskTemplateRequest.Builder().apply(block).build())

    /**
     * Assigns the specified hierarchy group to the specified user.
     */
    suspend fun updateUserHierarchy(input: UpdateUserHierarchyRequest): UpdateUserHierarchyResponse

    /**
     * Assigns the specified hierarchy group to the specified user.
     */
    suspend fun updateUserHierarchy(block: UpdateUserHierarchyRequest.Builder.() -> Unit) = updateUserHierarchy(UpdateUserHierarchyRequest.Builder().apply(block).build())

    /**
     * Updates the name of the user hierarchy group.
     */
    suspend fun updateUserHierarchyGroupName(input: UpdateUserHierarchyGroupNameRequest): UpdateUserHierarchyGroupNameResponse

    /**
     * Updates the name of the user hierarchy group.
     */
    suspend fun updateUserHierarchyGroupName(block: UpdateUserHierarchyGroupNameRequest.Builder.() -> Unit) = updateUserHierarchyGroupName(UpdateUserHierarchyGroupNameRequest.Builder().apply(block).build())

    /**
     * Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
     */
    suspend fun updateUserHierarchyStructure(input: UpdateUserHierarchyStructureRequest): UpdateUserHierarchyStructureResponse

    /**
     * Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
     */
    suspend fun updateUserHierarchyStructure(block: UpdateUserHierarchyStructureRequest.Builder.() -> Unit) = updateUserHierarchyStructure(UpdateUserHierarchyStructureRequest.Builder().apply(block).build())

    /**
     * Updates the identity information for the specified user.
     *
     * We strongly recommend limiting who has the ability to invoke `UpdateUserIdentityInfo`. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker's email address, and then reset the password through email. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun updateUserIdentityInfo(input: UpdateUserIdentityInfoRequest): UpdateUserIdentityInfoResponse

    /**
     * Updates the identity information for the specified user.
     *
     * We strongly recommend limiting who has the ability to invoke `UpdateUserIdentityInfo`. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker's email address, and then reset the password through email. For more information, see [Best Practices for Security Profiles](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html) in the *Amazon Connect Administrator Guide*.
     */
    suspend fun updateUserIdentityInfo(block: UpdateUserIdentityInfoRequest.Builder.() -> Unit) = updateUserIdentityInfo(UpdateUserIdentityInfoRequest.Builder().apply(block).build())

    /**
     * Updates the phone configuration settings for the specified user.
     */
    suspend fun updateUserPhoneConfig(input: UpdateUserPhoneConfigRequest): UpdateUserPhoneConfigResponse

    /**
     * Updates the phone configuration settings for the specified user.
     */
    suspend fun updateUserPhoneConfig(block: UpdateUserPhoneConfigRequest.Builder.() -> Unit) = updateUserPhoneConfig(UpdateUserPhoneConfigRequest.Builder().apply(block).build())

    /**
     * Assigns the specified routing profile to the specified user.
     */
    suspend fun updateUserRoutingProfile(input: UpdateUserRoutingProfileRequest): UpdateUserRoutingProfileResponse

    /**
     * Assigns the specified routing profile to the specified user.
     */
    suspend fun updateUserRoutingProfile(block: UpdateUserRoutingProfileRequest.Builder.() -> Unit) = updateUserRoutingProfile(UpdateUserRoutingProfileRequest.Builder().apply(block).build())

    /**
     * Assigns the specified security profiles to the specified user.
     */
    suspend fun updateUserSecurityProfiles(input: UpdateUserSecurityProfilesRequest): UpdateUserSecurityProfilesResponse

    /**
     * Assigns the specified security profiles to the specified user.
     */
    suspend fun updateUserSecurityProfiles(block: UpdateUserSecurityProfilesRequest.Builder.() -> Unit) = updateUserSecurityProfiles(UpdateUserSecurityProfilesRequest.Builder().apply(block).build())
}
