// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Information about a phone number that has been claimed to your Amazon Connect instance.
 */
class ClaimedPhoneNumberSummary private constructor(builder: Builder) {
    /**
     * The phone number. Phone numbers are formatted `[+] [country code] [subscriber number including area code]`.
     */
    val phoneNumber: kotlin.String? = builder.phoneNumber
    /**
     * The Amazon Resource Name (ARN) of the phone number.
     */
    val phoneNumberArn: kotlin.String? = builder.phoneNumberArn
    /**
     * The ISO country code.
     */
    val phoneNumberCountryCode: aws.sdk.kotlin.services.connect.model.PhoneNumberCountryCode? = builder.phoneNumberCountryCode
    /**
     * The description of the phone number.
     */
    val phoneNumberDescription: kotlin.String? = builder.phoneNumberDescription
    /**
     * A unique identifier for the phone number.
     */
    val phoneNumberId: kotlin.String? = builder.phoneNumberId
    /**
     * The status of the phone number.
     */
    val phoneNumberStatus: aws.sdk.kotlin.services.connect.model.PhoneNumberStatus? = builder.phoneNumberStatus
    /**
     * The type of phone number.
     */
    val phoneNumberType: aws.sdk.kotlin.services.connect.model.PhoneNumberType? = builder.phoneNumberType
    /**
     * The tags used to organize, track, or control access for this resource.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) for Amazon Connect instances that phone numbers are claimed to.
     */
    val targetArn: kotlin.String? = builder.targetArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ClaimedPhoneNumberSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClaimedPhoneNumberSummary(")
        append("phoneNumber=$phoneNumber,")
        append("phoneNumberArn=$phoneNumberArn,")
        append("phoneNumberCountryCode=$phoneNumberCountryCode,")
        append("phoneNumberDescription=$phoneNumberDescription,")
        append("phoneNumberId=$phoneNumberId,")
        append("phoneNumberStatus=$phoneNumberStatus,")
        append("phoneNumberType=$phoneNumberType,")
        append("tags=$tags,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = phoneNumber?.hashCode() ?: 0
        result = 31 * result + (phoneNumberArn?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberCountryCode?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberDescription?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberId?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberStatus?.hashCode() ?: 0)
        result = 31 * result + (phoneNumberType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClaimedPhoneNumberSummary

        if (phoneNumber != other.phoneNumber) return false
        if (phoneNumberArn != other.phoneNumberArn) return false
        if (phoneNumberCountryCode != other.phoneNumberCountryCode) return false
        if (phoneNumberDescription != other.phoneNumberDescription) return false
        if (phoneNumberId != other.phoneNumberId) return false
        if (phoneNumberStatus != other.phoneNumberStatus) return false
        if (phoneNumberType != other.phoneNumberType) return false
        if (tags != other.tags) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ClaimedPhoneNumberSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * The phone number. Phone numbers are formatted `[+] [country code] [subscriber number including area code]`.
         */
        var phoneNumber: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the phone number.
         */
        var phoneNumberArn: kotlin.String? = null
        /**
         * The ISO country code.
         */
        var phoneNumberCountryCode: aws.sdk.kotlin.services.connect.model.PhoneNumberCountryCode? = null
        /**
         * The description of the phone number.
         */
        var phoneNumberDescription: kotlin.String? = null
        /**
         * A unique identifier for the phone number.
         */
        var phoneNumberId: kotlin.String? = null
        /**
         * The status of the phone number.
         */
        var phoneNumberStatus: aws.sdk.kotlin.services.connect.model.PhoneNumberStatus? = null
        /**
         * The type of phone number.
         */
        var phoneNumberType: aws.sdk.kotlin.services.connect.model.PhoneNumberType? = null
        /**
         * The tags used to organize, track, or control access for this resource.
         */
        var tags: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) for Amazon Connect instances that phone numbers are claimed to.
         */
        var targetArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ClaimedPhoneNumberSummary) : this() {
            this.phoneNumber = x.phoneNumber
            this.phoneNumberArn = x.phoneNumberArn
            this.phoneNumberCountryCode = x.phoneNumberCountryCode
            this.phoneNumberDescription = x.phoneNumberDescription
            this.phoneNumberId = x.phoneNumberId
            this.phoneNumberStatus = x.phoneNumberStatus
            this.phoneNumberType = x.phoneNumberType
            this.tags = x.tags
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ClaimedPhoneNumberSummary = ClaimedPhoneNumberSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.connect.model.PhoneNumberStatus] inside the given [block]
         */
        fun phoneNumberStatus(block: aws.sdk.kotlin.services.connect.model.PhoneNumberStatus.Builder.() -> kotlin.Unit) {
            this.phoneNumberStatus = aws.sdk.kotlin.services.connect.model.PhoneNumberStatus.invoke(block)
        }
    }
}
