// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.connect.model



/**
 * Contains information about a contact flow.
 */
class ContactFlow private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the contact flow.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The content of the contact flow.
     */
    val content: kotlin.String? = builder.content
    /**
     * The description of the contact flow.
     */
    val description: kotlin.String? = builder.description
    /**
     * The identifier of the contact flow.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the contact flow.
     */
    val name: kotlin.String? = builder.name
    /**
     * The type of contact flow.
     */
    val state: aws.sdk.kotlin.services.connect.model.ContactFlowState? = builder.state
    /**
     * One or more tags.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The type of the contact flow. For descriptions of the available types, see [Choose a Contact Flow Type](https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types) in the *Amazon Connect Administrator Guide*.
     */
    val type: aws.sdk.kotlin.services.connect.model.ContactFlowType? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.connect.model.ContactFlow = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContactFlow(")
        append("arn=$arn,")
        append("content=$content,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (content?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContactFlow

        if (arn != other.arn) return false
        if (content != other.content) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.connect.model.ContactFlow = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the contact flow.
         */
        var arn: kotlin.String? = null
        /**
         * The content of the contact flow.
         */
        var content: kotlin.String? = null
        /**
         * The description of the contact flow.
         */
        var description: kotlin.String? = null
        /**
         * The identifier of the contact flow.
         */
        var id: kotlin.String? = null
        /**
         * The name of the contact flow.
         */
        var name: kotlin.String? = null
        /**
         * The type of contact flow.
         */
        var state: aws.sdk.kotlin.services.connect.model.ContactFlowState? = null
        /**
         * One or more tags.
         */
        var tags: Map<String, String>? = null
        /**
         * The type of the contact flow. For descriptions of the available types, see [Choose a Contact Flow Type](https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types) in the *Amazon Connect Administrator Guide*.
         */
        var type: aws.sdk.kotlin.services.connect.model.ContactFlowType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.connect.model.ContactFlow) : this() {
            this.arn = x.arn
            this.content = x.content
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.connect.model.ContactFlow = ContactFlow(this)
    }
}
